/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task.forge;

import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.EnergyTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ForgeEnergyTask
extends EnergyTask {
    public static TaskType TYPE;
    public static final ResourceLocation EMPTY_TEXTURE;
    public static final ResourceLocation FULL_TEXTURE;

    public ForgeEnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TYPE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TranslatableComponent("ftbquests.task.ftbquests.forge_energy.text", new Object[]{StringUtils.formatDouble((double)this.value, (boolean)true)});
    }

    public int receiveEnergy(TeamData teamData, int maxReceive, boolean simulate) {
        if (maxReceive > 0 && !teamData.isCompleted(this)) {
            long add = Math.min((long)maxReceive, this.value - teamData.getProgress(this));
            if (this.maxInput > 0L) {
                add = Math.min(add, this.maxInput);
            }
            if (add > 0L) {
                if (!simulate) {
                    teamData.addProgress(this, add);
                }
                return (int)add;
            }
        }
        return 0;
    }

    static {
        EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_empty.png");
        FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/fe_full.png");
    }
}

