/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.architectury.hooks.item.ItemStackHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.net.DisplayItemRewardToastMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemReward
extends Reward {
    public ItemStack item;
    public int count;
    public int randomBonus;
    public boolean onlyOne;

    public ItemReward(Quest quest, ItemStack is) {
        super(quest);
        this.item = is;
        this.count = 1;
        this.randomBonus = 0;
        this.onlyOne = false;
    }

    public ItemReward(Quest quest) {
        this(quest, new ItemStack((ItemLike)Items.f_42410_));
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ITEM;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1) {
            nbt.m_128405_("count", this.count);
        }
        if (this.randomBonus > 0) {
            nbt.m_128405_("random_bonus", this.randomBonus);
        }
        if (this.onlyOne) {
            nbt.m_128379_("only_one", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = nbt.m_128451_("count");
        if (this.count == 0) {
            this.count = this.item.m_41613_();
            this.item.m_41764_(1);
        }
        this.randomBonus = nbt.m_128451_("random_bonus");
        this.onlyOne = nbt.m_128471_("only_one");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        FTBQuestsNetHandler.writeItemType(buffer, this.item);
        buffer.m_130130_(this.count);
        buffer.m_130130_(this.randomBonus);
        buffer.writeBoolean(this.onlyOne);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.item = FTBQuestsNetHandler.readItemType(buffer);
        this.count = buffer.m_130242_();
        this.randomBonus = buffer.m_130242_();
        this.onlyOne = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, false).setNameKey("ftbquests.reward.ftbquests.item");
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, 8192);
        config.addInt("random_bonus", this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, 8192).setNameKey("ftbquests.reward.random_bonus");
        config.addBool("only_one", this.onlyOne, v -> {
            this.onlyOne = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        int size;
        int s;
        if (this.onlyOne && player.m_150109_().m_36063_(this.item)) {
            return;
        }
        for (size = this.count + player.f_19853_.f_46441_.nextInt(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.m_41741_());
            ItemStackHooks.giveItem((ServerPlayer)player, (ItemStack)ItemStackHooks.copyWithCount((ItemStack)this.item, (int)s));
        }
        if (notify) {
            new DisplayItemRewardToastMessage(this.item, size).sendTo(player);
        }
    }

    @Override
    public boolean automatedClaimPre(BlockEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayer player) {
        int s;
        for (int size = this.count + random.nextInt(this.randomBonus + 1); size > 0; size -= s) {
            s = Math.min(size, this.item.m_41741_());
            ItemStack copy = this.item.m_41777_();
            copy.m_41764_(s);
            items.add(copy);
        }
        return true;
    }

    @Override
    public void automatedClaimPost(BlockEntity tileEntity, UUID playerId, @Nullable ServerPlayer player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TextComponent((String)(this.count > 1 ? (this.randomBonus > 0 ? this.count + "-" + (this.count + this.randomBonus) + "x " : this.count + "x ") : "")).m_7220_(this.item.m_41786_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.item.m_41619_()) {
            return super.getAltIcon();
        }
        ItemStack copy = this.item.m_41777_();
        copy.m_41764_(1);
        return ItemIcon.getItemIcon((ItemStack)copy);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean addTitleInMouseOverText() {
        return !this.getTitle().getString().equals(this.getAltTitle().getString());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Object getIngredient() {
        return new WrappedIngredient((Object)this.item).tooltip();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.count + "-" + (this.count + this.randomBonus);
        }
        return Integer.toString(this.count);
    }
}

