/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChangeProgressMessage
extends BaseC2SMessage {
    private final UUID team;
    private final ProgressChange progressChange;

    ChangeProgressMessage(FriendlyByteBuf buffer) {
        this.team = buffer.m_130259_();
        this.progressChange = new ProgressChange(ServerQuestFile.INSTANCE, buffer);
    }

    public ChangeProgressMessage(UUID t, ProgressChange p) {
        this.team = t;
        this.progressChange = p;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CHANGE_PROGRESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void send(TeamData team, QuestObjectBase object, Consumer<ProgressChange> progressChange) {
        if (team.isLocked()) {
            return;
        }
        ProgressChange change = new ProgressChange(team.file);
        change.origin = object;
        change.player = Minecraft.m_91087_().f_91074_.m_142081_();
        progressChange.accept(change);
        new ChangeProgressMessage(team.uuid, change).sendToServer();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.team);
        this.progressChange.write(buffer);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (NetUtils.canEdit(context) && this.progressChange.origin != null) {
            TeamData t = ServerQuestFile.INSTANCE.getData(this.team);
            this.progressChange.origin.forceProgressRaw(t, this.progressChange);
        }
    }
}

