/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import dev.ftb.mods.ftbquests.integration.jei.QuestWrapper;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class QuestCategory
implements IRecipeCategory<QuestWrapper> {
    public static final ResourceLocation UID = new ResourceLocation("ftbquests", "quests");
    public static final ResourceLocation TEXTURE = new ResourceLocation("ftbquests:textures/gui/jei/quest.png");
    public static QuestCategory instance;
    private final IDrawable background;
    private final IDrawable icon;

    public QuestCategory(IGuiHelper guiHelper) {
        instance = this;
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 144, 74);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)FTBQuestsItems.BOOK.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<QuestWrapper> getRecipeClass() {
        return QuestWrapper.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("ftbquests.quests");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(QuestWrapper questWrapper, IIngredients iIngredients) {
    }

    public void setRecipe(IRecipeLayout layout, QuestWrapper entry, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup stacks = layout.getItemStacks();
        int is = Math.min(9, entry.input.size());
        for (i = 0; i < is; ++i) {
            stacks.init(i, true, i % 3 * 18, i / 3 * 18 + 20);
        }
        for (i = 0; i < Math.min(9, entry.output.size()); ++i) {
            stacks.init(i + is, false, i % 3 * 18 + 90, i / 3 * 18 + 20);
        }
        stacks.set(ingredients);
    }
}

