/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bhc")
public class DropHandler {
    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.f_19853_.f_46443_ || entity instanceof Player) {
            return;
        }
        if (!ModList.get().isLoaded("tinkersconstruct") && entity instanceof WitherSkeleton && entity.f_19853_.f_46441_.nextDouble() < (Double)ConfigHandler.general.boneDropRate.get()) {
            entity.m_20000_((ItemLike)RegistryHandler.WITHER_BONE.get(), 1);
        }
        for (ItemStack stack : DropHandler.getEntityDrops(entity)) {
            entity.m_20000_((ItemLike)stack.m_41720_(), 0);
        }
    }

    public static List<ItemStack> getEntityDrops(LivingEntity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        DropHandler.handleEntry("red", entity, list);
        DropHandler.handleEntry("yellow", entity, list);
        DropHandler.handleEntry("green", entity, list);
        DropHandler.handleEntry("blue", entity, list);
        return list;
    }

    public static void handleEntry(String category, LivingEntity entity, List<ItemStack> items) {
        for (Map.Entry<String, Double> entry : BaubleyHeartCanisters.config.getHeartTypeEntries(category).entrySet()) {
            ItemStack stack = ItemStack.f_41583_;
            switch (category) {
                case "red": {
                    stack = new ItemStack((ItemLike)RegistryHandler.RED_HEART.get());
                    break;
                }
                case "yellow": {
                    stack = new ItemStack((ItemLike)RegistryHandler.YELLOW_HEART.get());
                    break;
                }
                case "green": {
                    stack = new ItemStack((ItemLike)RegistryHandler.GREEN_HEART.get());
                    break;
                }
                case "blue": {
                    stack = new ItemStack((ItemLike)RegistryHandler.BLUE_HEART.get());
                }
            }
            if (entry.getKey().equals(entity.m_20078_())) {
                DropHandler.addWithPercent(items, stack, entry.getValue());
                continue;
            }
            switch (entry.getKey()) {
                case "hostile": {
                    if (!(entity instanceof Monster) || !entity.m_6072_()) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "boss": {
                    if (entity.m_6072_() || entity instanceof EnderDragon) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                    break;
                }
                case "dragon": {
                    if (!(entity instanceof EnderDragon)) break;
                    DropHandler.addWithPercent(items, stack, entry.getValue());
                }
            }
        }
    }

    public static void addWithPercent(List<ItemStack> list, ItemStack stack, double percentage) {
        Random random = new Random();
        int percent = (int)(percentage * 100.0);
        if (random.nextInt(100) < percent) {
            list.add(stack);
        }
    }
}

