/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.IMultiRecipe;

public class RecipeHelper {
    public static <C extends Recipe<?>> Optional<C> getRecipe(RecipeManager manager, ResourceLocation name, Class<C> clazz) {
        return manager.m_44043_(name).filter(clazz::isInstance).map(clazz::cast);
    }

    public static <I extends Container, T extends Recipe<I>, C extends T> List<C> getRecipes(RecipeManager manager, RecipeType<T> type, Class<C> clazz) {
        return manager.m_44054_(type).values().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends Container, T extends Recipe<I>, C extends T> List<C> getUIRecipes(RecipeManager manager, RecipeType<T> type, Class<C> clazz, Predicate<? super C> filter) {
        return manager.m_44054_(type).values().stream().filter(clazz::isInstance).map(clazz::cast).filter(filter).sorted(Comparator.comparing(Recipe::m_6423_)).collect(Collectors.toList());
    }

    public static <C> List<C> getJEIRecipes(Stream<? extends Recipe<?>> recipes, Class<C> clazz) {
        return recipes.sorted((r1, r2) -> {
            boolean m1 = r1 instanceof IMultiRecipe;
            boolean m2 = r2 instanceof IMultiRecipe;
            if (m1 && !m2) {
                return 1;
            }
            if (!m1 && m2) {
                return -1;
            }
            return r1.m_6423_().compareTo(r2.m_6423_());
        }).flatMap(recipe -> {
            if (recipe instanceof IMultiRecipe) {
                return ((IMultiRecipe)recipe).getRecipes().stream();
            }
            return Stream.of(recipe);
        }).filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static <I extends Container, T extends Recipe<I>, C> List<C> getJEIRecipes(RecipeManager manager, RecipeType<T> type, Class<C> clazz) {
        return RecipeHelper.getJEIRecipes(manager.m_44054_(type).values().stream(), clazz);
    }

    public static JsonObject serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", Objects.requireNonNull(stack.getFluid().getRegistryName()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }

    public static FluidStack deserializeFluidStack(JsonObject json) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Unknown fluid " + fluidName);
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        return new FluidStack(fluid, amount);
    }

    public static <C> C deserializeItem(String name, String key, Class<C> clazz) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            throw new JsonSyntaxException("Invalid " + key + ": Unknown item " + name + "'");
        }
        if (!clazz.isInstance(item)) {
            throw new JsonSyntaxException("Invalid " + key + ": must be " + clazz.getSimpleName());
        }
        return clazz.cast(item);
    }

    public static Item readItem(FriendlyByteBuf buffer) {
        return Item.m_41445_((int)buffer.m_130242_());
    }

    public static <T> T readItem(FriendlyByteBuf buffer, Class<T> clazz) {
        Item item = RecipeHelper.readItem(buffer);
        if (!clazz.isInstance(item)) {
            throw new DecoderException("Invalid item '" + item.getRegistryName() + "', must be " + clazz.getSimpleName());
        }
        return clazz.cast(item);
    }

    public static void writeItem(FriendlyByteBuf buffer, ItemLike item) {
        buffer.m_130130_(Item.m_41393_((Item)item.m_5456_()));
    }

    private RecipeHelper() {
    }
}

