/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.gui.GuiUtils;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.screen.book.BookScreen;

public class TextComponentDataRenderer {
    public static String drawText(PoseStack matrixStack, int x, int y, int boxWidth, int boxHeight, TextComponentData[] data, int mouseX, int mouseY, Font fr, List<Component> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextComponentData item : data) {
            boolean mouseCheck;
            int box1W = 9999;
            Objects.requireNonNull(fr);
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null) continue;
            if (item.text.getString().equals("\n")) {
                atX = x;
                Objects.requireNonNull(fr);
                atY += 9;
                continue;
            }
            if (item.isParagraph) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            List<FormattedText> textLines = TextComponentDataRenderer.splitTextComponentBySize(item.text, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                if (lineNumber == textLines.size() - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                FormattedText textComponent = textLines.get(lineNumber);
                TextComponentDataRenderer.drawScaledTextComponent(matrixStack, fr, textComponent, atX, atY, item.dropShadow, item.scale);
                if (lineNumber < textLines.size() - 1) {
                    Objects.requireNonNull(fr);
                    atY += 9;
                    atX = x;
                }
                if (lineNumber != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.m_92724_(Language.m_128107_().m_5536_(textLines.get(textLines.size() - 1))) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            Objects.requireNonNull(fr);
            int box3H = (int)(f + 9.0f * item.scale);
            boolean bl = mouseCheck = mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H;
            if (item.tooltips != null && item.tooltips.length > 0) {
                if (BookScreen.debug) {
                    Matrix4f matrix = matrixStack.m_85850_().m_85861_();
                    GuiUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box1X, (int)box1Y, (int)box1W, (int)box1H, (int)-16711936, (int)-16711936);
                    GuiUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box2X, (int)box2Y, (int)box2W, (int)box2H, (int)-65536, (int)-65536);
                    GuiUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box3X, (int)box3Y, (int)box3W, (int)box3H, (int)-16776961, (int)-16776961);
                    GuiUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)mouseX, (int)mouseY, (int)(mouseX + 5), (int)(mouseY + 5), (int)-65281, (int)-256);
                }
                if (mouseCheck) {
                    tooltip.addAll(Arrays.asList(item.tooltips));
                }
            }
            if (item.action != null && !item.action.isEmpty() && mouseCheck) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                if (item.dropShadow) {
                    fr.m_92750_(matrixStack, "...", (float)atX, (float)atY, 0);
                    break;
                }
                fr.m_92883_(matrixStack, "...", (float)atX, (float)atY, 0);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && !action.isEmpty()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TextComponent("Action: " + action).m_130940_(ChatFormatting.GRAY));
        }
        return action;
    }

    public static List<FormattedText> splitTextComponentBySize(Component textComponent, int width, int height, int firstWidth, Font fontRenderer, float scale) {
        ArrayList<Object> textLines;
        boolean needsWrap;
        block6: {
            block5: {
                int curWidth = (int)((float)fontRenderer.m_92852_((FormattedText)textComponent) * scale);
                Objects.requireNonNull(fontRenderer);
                int curHeight = (int)(9.0f * scale);
                needsWrap = false;
                textLines = new ArrayList<FormattedText>();
                Objects.requireNonNull(fontRenderer);
                if (curHeight == (int)(9.0f * scale) && curWidth > firstWidth) break block5;
                Objects.requireNonNull(fontRenderer);
                if (curHeight == (int)(9.0f * scale) || curWidth <= width) break block6;
            }
            needsWrap = true;
        }
        if (needsWrap) {
            textLines = new ArrayList(fontRenderer.m_92865_().m_92414_((FormattedText)textComponent, firstWidth, Style.f_131099_));
        } else {
            textLines.add((FormattedText)textComponent);
        }
        return textLines;
    }

    public static void drawScaledTextComponent(PoseStack matrixStack, Font font, FormattedText textComponent, float x, float y, boolean dropShadow, float scale) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(scale, scale, 1.0f);
        if (dropShadow) {
            font.m_92744_(matrixStack, Language.m_128107_().m_5536_(textComponent), 0.0f, 0.0f, 0);
        } else {
            font.m_92877_(matrixStack, Language.m_128107_().m_5536_(textComponent), 0.0f, 0.0f, 0);
        }
        matrixStack.m_85849_();
    }
}

