/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.Widget;

public class TabsWidget
extends Widget {
    private static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private final ElementScreen[] tabActive = new ElementScreen[3];
    private final ElementScreen[] tab = new ElementScreen[3];
    public ResourceLocation tabsResource = creativeInventoryTabs;
    public int yOffset = 4;
    public int spacing = 2;
    public int selected;
    public int highlighted;
    protected List<ItemStack> icons = Lists.newArrayList();
    private final MultiModuleScreen<?> parent;
    private boolean clicked = false;
    private boolean leftMouseDown = false;

    public TabsWidget(MultiModuleScreen<?> parent, ElementScreen tabLeft, ElementScreen tabCenter, ElementScreen tabRight, ElementScreen activeLeft, ElementScreen activeCenter, ElementScreen activeRight) {
        this.parent = parent;
        this.tab[0] = tabLeft;
        this.tab[1] = tabCenter;
        this.tab[2] = tabRight;
        this.tabActive[0] = activeLeft;
        this.tabActive[1] = activeCenter;
        this.tabActive[2] = activeRight;
        this.selected = 0;
    }

    public void addTab(ItemStack icon) {
        this.icons.add(icon);
    }

    public void clear() {
        this.selected = 0;
        this.icons.clear();
    }

    @Override
    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.leftMouseDown = true;
        }
    }

    @Override
    public void handleMouseReleased() {
        this.leftMouseDown = false;
    }

    public void update(int mouseX, int mouseY) {
        mouseX -= this.xPos;
        this.highlighted = -1;
        if ((mouseY -= this.yPos) >= 0 && mouseY <= this.tab[1].h) {
            int x = 0;
            for (int i = 0; i < this.icons.size(); ++i) {
                if (mouseX >= x && mouseX < x + this.tab[1].w) {
                    this.highlighted = i;
                    break;
                }
                x += this.tab[1].w;
                x += this.spacing;
            }
        }
        if (this.clicked) {
            if (!this.leftMouseDown) {
                this.clicked = false;
            }
            return;
        }
        if (!this.leftMouseDown) {
            return;
        }
        this.clicked = true;
        if (this.highlighted > -1) {
            this.selected = this.highlighted;
        }
    }

    @Override
    public void draw(PoseStack matrixStack) {
        int y = this.yPos + this.yOffset;
        for (int i = 0; i < this.icons.size(); ++i) {
            int x = this.xPos + i * this.tab[0].w;
            if (i > 0) {
                x += i * this.spacing;
            }
            ElementScreen[] toDraw = i == this.selected ? this.tabActive : this.tab;
            ElementScreen actualTab = i == 0 && x == this.parent.cornerX ? toDraw[0] : (x == this.parent.cornerX + this.parent.f_96543_ ? toDraw[2] : toDraw[1]);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.tabsResource);
            actualTab.draw(matrixStack, x, y);
            ItemStack icon = this.icons.get(i);
            if (icon == null) continue;
            this.drawItemStack(icon, x + (actualTab.w - 16) / 2, y + (actualTab.h - 16) / 2);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        PoseStack poses = RenderSystem.m_157191_();
        poses.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157182_();
        ItemRenderer itemRender = Minecraft.m_91087_().m_91291_();
        itemRender.f_115093_ = 200.0f;
        itemRender.m_115203_(stack, x, y);
        itemRender.f_115093_ = 0.0f;
    }
}

