/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class FluidsModel
implements IModelGeometry<FluidsModel> {
    private final SimpleBlockModel model;
    private final List<FluidCuboid> fluids;

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new Baked(baked, this.fluids);
    }

    public FluidsModel(SimpleBlockModel model, List<FluidCuboid> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    public static class Baked
    extends BakedModelWrapper<BakedModel> {
        private final List<FluidCuboid> fluids;

        public Baked(BakedModel originalModel, List<FluidCuboid> fluids) {
            super(originalModel);
            this.fluids = fluids;
        }

        public List<FluidCuboid> getFluids() {
            return this.fluids;
        }
    }

    public static class Loader
    implements IModelLoader<FluidsModel> {
        public static final Loader INSTANCE = new Loader();

        public void m_6213_(ResourceManager resourceManager) {
        }

        public FluidsModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(deserializationContext, modelContents);
            List<FluidCuboid> fluid = FluidCuboid.listFromJson(modelContents, "fluids");
            return new FluidsModel(model, fluid);
        }
    }
}

