/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.ItemInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RainGutter
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    private static final BooleanProperty WATER = BooleanProperty.m_61465_((String)"water");
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public RainGutter(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122434_().m_122479_() ? (BlockState)stateIn.m_61124_(SHAPE, (Comparable)RainGutter.getShapeProperty(stateIn, (BlockGetter)worldIn, currentPos)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public RenderShape m_7514_(BlockState p_53554_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BASE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Boolean i = (Boolean)state.m_61143_((Property)WATER);
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.m_61122_(SHAPE);
            world.m_7731_(pos, state, 2);
        }
        if (item == Items.f_42447_ && !i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        if (item == Items.f_42446_ && i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            itemstack.m_41774_(1);
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
        }
        if (item == Items.f_42590_ && i.booleanValue()) {
            state = (BlockState)state.m_61122_((Property)WATER);
            world.m_7731_(pos, state, 2);
            player.m_21008_(hand, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)RainGutter.getShapeProperty(blockstate, (BlockGetter)context.m_43725_(), blockpos));
    }

    private static StairsShape getShapeProperty(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState blockstate = worldIn.m_8055_(pos.m_142300_(direction));
        if (RainGutter.isBlockStairs(blockstate) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (RainGutter.isBlockStairs(blockstate1) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.m_60734_() instanceof RainGutter;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    protected boolean isRainingday(Level world, BlockPos pos) {
        return world.m_46758_(pos);
    }

    public boolean m_6724_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockPos blockpos = pos.m_6630_(30);
        if (world.m_46758_(blockpos) && !((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(true)));
        }
        if (!world.m_46758_(blockpos) && ((Boolean)state.m_61143_((Property)WATER)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATER, FACING, SHAPE});
    }
}

