/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.debugtools.DumpItemNBT;
import mcjty.lib.varia.Logging;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketDumpItemInfo {
    private final boolean verbose;

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.verbose);
    }

    public PacketDumpItemInfo(ByteBuf buf) {
        this.verbose = buf.readBoolean();
    }

    public PacketDumpItemInfo(boolean verbose) {
        this.verbose = verbose;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ItemStack item;
            int perm;
            ServerPlayer player = ctx.getSender();
            MinecraftServer server = player.m_20193_().m_142572_();
            ServerOpList oppedPlayers = server.m_6846_().m_11307_();
            ServerOpListEntry entry = (ServerOpListEntry)oppedPlayers.m_11388_((Object)player.m_36316_());
            int n = perm = entry == null ? server.m_7022_() : entry.m_11363_();
            if (perm >= 1 && !(item = player.m_21205_()).m_41619_()) {
                String output = DumpItemNBT.dumpItemNBT(item, this.verbose);
                Logging.getLogger().log(Level.INFO, "### Server side ###");
                Logging.getLogger().log(Level.INFO, output);
            }
        });
        ctx.setPacketHandled(true);
    }
}

