/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.joefoxe.hexerei.Hexerei;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class HexereiAbstractTreeFeature
extends Feature<TreeConfiguration> {
    private static final ResourceLocation WILLOW_TREE1 = new ResourceLocation("hexerei:willow_tree1");
    private static final ResourceLocation WILLOW_TREE2 = new ResourceLocation("hexerei:willow_tree2");
    private static final ResourceLocation WILLOW_TREE3 = new ResourceLocation("hexerei:willow_tree3");
    private static final ResourceLocation[] WILLOW_TREE = new ResourceLocation[]{WILLOW_TREE1, WILLOW_TREE2, WILLOW_TREE3};

    public HexereiAbstractTreeFeature(Codec codec) {
        super(codec);
    }

    public static boolean isAirOrLeavesAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_));
    }

    public static boolean isAirOrLeavesOrLogsAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_));
    }

    private static boolean isDirtOrFarmlandAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> {
            Block block = state.m_60734_();
            return HexereiAbstractTreeFeature.m_159759_((BlockState)state) || block == Blocks.f_50093_;
        });
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel reader = context.m_159774_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        int i = rand.nextInt(WILLOW_TREE.length);
        if (!HexereiAbstractTreeFeature.isDirtOrFarmlandAt((LevelSimulatedReader)reader, pos.m_7495_())) {
            return false;
        }
        for (int j = 0; j < 8; ++j) {
            BlockPos upPos = new BlockPos((Vec3i)pos).m_7494_();
            for (int k = 0; k < j; ++k) {
                upPos = upPos.m_7494_();
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos)) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142127_())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142128_())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142126_())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142126_().m_142127_())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142126_().m_142128_())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142125_())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142125_().m_142127_())) {
                return false;
            }
            if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_142125_().m_142128_())) continue;
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_142127_())) {
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_142128_())) {
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_142126_())) {
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_142125_())) {
            return false;
        }
        BlockRotProcessor BlockRotProcessor2 = new BlockRotProcessor(0.9f);
        StructureManager templatemanager = reader.m_6018_().m_142572_().m_129909_();
        StructureTemplate template = templatemanager.m_74341_(WILLOW_TREE[i]);
        if (template == null) {
            Hexerei.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)WILLOW_TREE[i]);
            return false;
        }
        Rotation rotation = Rotation.m_55956_((Random)rand);
        BlockPos halfLengths = new BlockPos(template.m_163801_().m_123341_() / 2, template.m_163801_().m_123342_() / 2, template.m_163801_().m_123343_() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74379_(rotation).m_74385_(halfLengths).m_74392_(false);
        Optional processor = ((Registry)reader.m_6018_().m_142572_().m_206579_().m_6632_(Registry.f_122883_).get()).m_6612_(new ResourceLocation("hexerei", "mangrove_tree/mangrove_tree_legs"));
        processor.ifPresent(structureProcessorList -> structureProcessorList.m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0)));
        BlockPos.MutableBlockPos pos1 = mutable.m_122190_((Vec3i)pos).m_122184_(-halfLengths.m_123341_(), 0, -halfLengths.m_123343_());
        template.m_74536_((ServerLevelAccessor)reader, (BlockPos)pos1, (BlockPos)pos1, placementsettings, rand, 2);
        return true;
    }
}

