/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.gen;

import java.util.Arrays;
import java.util.List;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.config.HexConfig;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ModEntityGeneration {
    public static void onEntitySpawn(BiomeLoadingEvent event) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
        if (BiomeDictionary.hasType((ResourceKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && BiomeDictionary.hasType((ResourceKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.CROW.get(), ((Integer)HexConfig.CROW_SPAWN_WEIGHT.get()).intValue(), ((Integer)HexConfig.CROW_SPAWN_MIN_COUNT.get()).intValue(), ((Integer)HexConfig.CROW_SPAWN_MAX_COUNT.get()).intValue()));
        }
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::getRegistryName).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, ResourceKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(ResourceKey::getRegistryName).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            ModEntityGeneration.addEntityToAllBiomes(event, type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllOverworldBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND) && !event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomesNoNether(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomesNoEnd(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND)) {
            List base = event.getSpawns().getSpawner(type.m_20674_());
            base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
        }
    }

    private static void addEntityToAllBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = event.getSpawns().getSpawner(type.m_20674_());
        base.add(new MobSpawnSettings.SpawnerData(type, weight, minCount, maxCount));
    }
}

