/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.PestleAndMortarRecipe;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class PestleAndMortarTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider {
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    public int craftDelay;
    public static final int craftDelayMax = 100;
    public boolean crafted = false;
    public boolean crafting = false;
    public boolean grindSoundPlayed = false;
    public int grindingTimeMax = 200;
    public int grindingTime = 200;
    public ItemStack output = ItemStack.f_41583_;

    public PestleAndMortarTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                PestleAndMortarTile.this.sync();
            }

            public int getSlotLimit(int slot) {
                if (slot != 5) {
                    return 1;
                }
                return 64;
            }
        };
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6596_() {
        super.m_6596_();
        this.sync();
    }

    public void sync() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public Item getItemInSlot(int slot) {
        return ((ItemStack)this.items.get(slot)).m_41720_();
    }

    public ItemStack getItemStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    public PestleAndMortarTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.PESTLE_AND_MORTAR_TILE.get(), blockPos, blockState);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.m_41777_();
            this.items.set(index, (Object)itemStack);
            if (index != 5) {
                this.grindingTime = this.grindingTimeMax;
            }
        }
        this.m_6596_();
    }

    public ItemStack m_7407_(int index, int p_59614_) {
        this.m_59640_(null);
        ItemStack itemstack = ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)p_59614_);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        this.m_6596_();
        return itemstack;
    }

    public void craft() {
        SimpleContainer inv = new SimpleContainer(5);
        for (int i = 0; i < 5; ++i) {
            inv.m_6836_(i, (ItemStack)this.items.get(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)PestleAndMortarRecipe.Type.INSTANCE, (Container)inv, this.f_58857_);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_);
        AtomicBoolean matches = new AtomicBoolean(false);
        if (blockEntity instanceof PestleAndMortarTile) {
            recipe.ifPresent(iRecipe -> {
                ItemStack recipeOutput;
                this.output = recipeOutput = iRecipe.m_8043_();
                matches.set(true);
                if (((PestleAndMortarTile)blockEntity).getItemInSlot(5) == Items.f_41852_ && !this.crafting) {
                    this.crafting = true;
                    this.grindingTime = this.grindingTimeMax = iRecipe.getGrindingTime();
                    this.m_6596_();
                }
            });
        }
        if (!matches.get() && this.crafting) {
            this.crafting = false;
            this.m_6596_();
        }
    }

    private void craftTheItem(ItemStack output) {
        this.items.set(0, (Object)ItemStack.f_41583_);
        this.items.set(1, (Object)ItemStack.f_41583_);
        this.items.set(2, (Object)ItemStack.f_41583_);
        this.items.set(3, (Object)ItemStack.f_41583_);
        this.items.set(4, (Object)ItemStack.f_41583_);
        this.items.set(5, (Object)output);
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt.m_128469_("inv"));
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
        if (nbt.m_128425_("grindingTime", 3)) {
            this.grindingTime = nbt.m_128451_("grindingTime");
        }
        if (nbt.m_128425_("grindingTimeMax", 3)) {
            this.grindingTimeMax = nbt.m_128451_("grindingTimeMax");
        }
        if (nbt.m_128425_("crafting", 3)) {
            boolean bl = this.crafting = nbt.m_128451_("crafting") == 1;
        }
        if (nbt.m_128425_("crafted", 3)) {
            this.crafted = nbt.m_128451_("crafted") == 1;
        }
        super.m_142466_(nbt);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.hexerei.pestle_and_mortar");
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void m_183515_(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128405_("grindingTime", this.grindingTime);
        compound.m_128405_("grindingTimeMax", this.grindingTimeMax);
        compound.m_128405_("crafted", this.crafted ? 1 : 0);
        compound.m_128405_("crafting", this.crafting ? 1 : 0);
    }

    public CompoundTag save(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        compound.m_128405_("grindingTime", this.grindingTime);
        compound.m_128405_("grindingTimeMax", this.grindingTimeMax);
        compound.m_128405_("crafted", this.crafted ? 1 : 0);
        compound.m_128405_("crafting", this.crafting ? 1 : 0);
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().m_7096_() - (double)pos.m_123341_() - 0.5;
        double deltaY = entity.m_20182_().m_7098_() - (double)pos.m_123342_() - 0.5;
        double deltaZ = entity.m_20182_().m_7094_() - (double)pos.m_123343_() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
        return aabb;
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    private float moveToAngle(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (Math.abs(distance) < 180.0f ? (input += speed) : (input -= speed)) : (Math.abs(distance) < 180.0f ? (input -= speed) : (input += speed));
        if (input < -90.0f) {
            input += 360.0f;
        }
        if (input > 270.0f) {
            input -= 360.0f;
        }
        return input;
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)this.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)0.01f + (double)0.1f * (Math.abs(pos - posTo) / 3.0));
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.m_82546_(vector3dCenter);
        newVec = newVec.m_82524_(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.m_82549_(vector3dCenter);
        return newVec;
    }

    public int putItems(int slot, @Nonnull ItemStack stack) {
        ItemStack stack1 = stack.m_41777_();
        Random rand = new Random();
        if (((ItemStack)this.items.get(slot)).m_41619_()) {
            stack1.m_41764_(1);
            this.items.set(slot, (Object)stack1);
            this.grindingTime = this.grindingTimeMax;
            this.m_6596_();
            stack.m_41774_(1);
            this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
            return 1;
        }
        return 0;
    }

    public int interactPestleAndMortar(Player player, BlockHitResult hit) {
        if (!player.m_6144_()) {
            if (!this.f_58857_.f_46443_) {
                if (!((ItemStack)this.items.get(5)).m_41619_()) {
                    player.f_36093_.m_150079_(((ItemStack)this.items.get(5)).m_41777_());
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                    this.items.set(5, (Object)ItemStack.f_41583_);
                    this.m_6596_();
                } else if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.f_58857_.f_46443_) {
                    Random rand = new Random();
                    if (((ItemStack)this.items.get(0)).m_41619_()) {
                        this.putItems(0, player.m_21120_(InteractionHand.MAIN_HAND));
                        return 1;
                    }
                    if (((ItemStack)this.items.get(1)).m_41619_()) {
                        this.putItems(1, player.m_21120_(InteractionHand.MAIN_HAND));
                        return 1;
                    }
                    if (((ItemStack)this.items.get(2)).m_41619_()) {
                        this.putItems(2, player.m_21120_(InteractionHand.MAIN_HAND));
                        return 1;
                    }
                    if (((ItemStack)this.items.get(3)).m_41619_()) {
                        this.putItems(3, player.m_21120_(InteractionHand.MAIN_HAND));
                        return 1;
                    }
                    if (((ItemStack)this.items.get(4)).m_41619_()) {
                        this.putItems(4, player.m_21120_(InteractionHand.MAIN_HAND));
                        return 1;
                    }
                }
            }
        } else if (!this.f_58857_.f_46443_) {
            if (!((ItemStack)this.items.get(5)).m_41619_()) {
                player.f_36093_.m_150079_(((ItemStack)this.items.get(5)).m_41777_());
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                this.items.set(5, (Object)ItemStack.f_41583_);
            }
            if (!this.crafting) {
                if (!((ItemStack)this.items.get(0)).m_41619_()) {
                    player.f_36093_.m_150079_(((ItemStack)this.items.get(0)).m_41777_());
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                    this.items.set(0, (Object)ItemStack.f_41583_);
                    this.output = ItemStack.f_41583_;
                }
                if (!((ItemStack)this.items.get(1)).m_41619_()) {
                    player.f_36093_.m_150079_(((ItemStack)this.items.get(1)).m_41777_());
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                    this.items.set(1, (Object)ItemStack.f_41583_);
                    this.output = ItemStack.f_41583_;
                }
                if (!((ItemStack)this.items.get(2)).m_41619_()) {
                    player.f_36093_.m_150079_(((ItemStack)this.items.get(2)).m_41777_());
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                    this.items.set(2, (Object)ItemStack.f_41583_);
                    this.output = ItemStack.f_41583_;
                }
                if (!((ItemStack)this.items.get(3)).m_41619_()) {
                    player.f_36093_.m_150079_(((ItemStack)this.items.get(3)).m_41777_());
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                    this.items.set(3, (Object)ItemStack.f_41583_);
                    this.output = ItemStack.f_41583_;
                }
                if (!((ItemStack)this.items.get(4)).m_41619_()) {
                    player.f_36093_.m_150079_(((ItemStack)this.items.get(4)).m_41777_());
                    this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 1.0f);
                    this.items.set(4, (Object)ItemStack.f_41583_);
                    this.output = ItemStack.f_41583_;
                }
                this.m_6596_();
            }
        }
        return 0;
    }

    public void tick() {
        if (this.f_58857_ instanceof ServerLevel) {
            this.craft();
        }
        if (this.crafting) {
            if (this.grindingTime <= 0) {
                Random rand = new Random();
                if (this.f_58857_ instanceof ServerLevel) {
                    this.craftTheItem(this.output);
                }
                this.crafted = true;
                this.crafting = false;
                this.m_6596_();
            } else {
                --this.grindingTime;
                Random rand = new Random();
                float craftPercent2 = (float)(this.grindingTimeMax - this.grindingTime) / 100.0f;
                double pestleYOffset = Math.pow(Mth.m_14031_((float)(craftPercent2 * 3.14f * 5.0f - 1.2f)), 4.0) / 4.0;
                if (pestleYOffset < 0.1) {
                    if (!this.grindSoundPlayed) {
                        this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_11998_, SoundSource.BLOCKS, 0.1f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 2.1f);
                        this.grindSoundPlayed = true;
                    }
                    if (!((ItemStack)this.items.get(0)).m_41619_() && rand.nextInt(4) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)this.items.get(0)), (double)((float)this.f_58858_.m_123341_() + 0.45f + rand.nextFloat() * 0.1f), (double)this.f_58858_.m_123342_() + 0.2, (double)((float)this.f_58858_.m_123343_() + 0.45f + rand.nextFloat() * 0.1f), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.15, (rand.nextDouble() - 0.5) / 15.0);
                    }
                    if (!((ItemStack)this.items.get(1)).m_41619_() && rand.nextInt(4) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)this.items.get(1)), (double)((float)this.f_58858_.m_123341_() + 0.45f + rand.nextFloat() * 0.1f), (double)this.f_58858_.m_123342_() + 0.2, (double)((float)this.f_58858_.m_123343_() + 0.45f + rand.nextFloat() * 0.1f), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.15, (rand.nextDouble() - 0.5) / 15.0);
                    }
                    if (!((ItemStack)this.items.get(2)).m_41619_() && rand.nextInt(4) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)this.items.get(2)), (double)((float)this.f_58858_.m_123341_() + 0.45f + rand.nextFloat() * 0.1f), (double)this.f_58858_.m_123342_() + 0.2, (double)((float)this.f_58858_.m_123343_() + 0.45f + rand.nextFloat() * 0.1f), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.15, (rand.nextDouble() - 0.5) / 15.0);
                    }
                    if (!((ItemStack)this.items.get(3)).m_41619_() && rand.nextInt(4) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)this.items.get(3)), (double)((float)this.f_58858_.m_123341_() + 0.45f + rand.nextFloat() * 0.1f), (double)this.f_58858_.m_123342_() + 0.2, (double)((float)this.f_58858_.m_123343_() + 0.45f + rand.nextFloat() * 0.1f), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.15, (rand.nextDouble() - 0.5) / 15.0);
                    }
                    if (!((ItemStack)this.items.get(4)).m_41619_() && rand.nextInt(4) == 0) {
                        this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)this.items.get(4)), (double)((float)this.f_58858_.m_123341_() + 0.45f + rand.nextFloat() * 0.1f), (double)this.f_58858_.m_123342_() + 0.2, (double)((float)this.f_58858_.m_123343_() + 0.45f + rand.nextFloat() * 0.1f), (rand.nextDouble() - 0.5) / 15.0, (rand.nextDouble() + 0.5) * 0.15, (rand.nextDouble() - 0.5) / 15.0);
                    }
                } else {
                    this.grindSoundPlayed = false;
                }
            }
        }
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[]{5};
        }
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index != 5 && this.m_7013_(index, itemStackIn);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return ((ItemStack)this.items.get(index)).m_41619_();
    }

    public boolean m_7157_(int index, ItemStack p_19240_, Direction p_19241_) {
        return index == 5;
    }

    public int m_6643_() {
        return this.items.size();
    }
}

