/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.item.custom.HerbJarItem;
import net.joefoxe.hexerei.items.JarHandler;
import net.joefoxe.hexerei.screen.tooltip.HexereiBookTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientHerbJarToolTip
implements HexereiBookTooltip {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("hexerei", "textures/gui/herb_jar_tooltip_inventory.png");
    private final JarHandler items;
    public int width;
    public Font font;
    public MutableComponent shift_down;
    public MutableComponent shift_up;

    public ClientHerbJarToolTip(HerbJarItem.HerbJarToolTip tooltip) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.shift_down = new TranslatableComponent("<%s>", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
        this.shift_up = new TranslatableComponent("[%s]", new Object[]{new TranslatableComponent("tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
        this.items = tooltip.jarHandler();
    }

    public int m_142103_() {
        return this.gridSizeY() * 20 + 2 + 4 + 10 + this.getHeightOffset();
    }

    public int getHeightOffset() {
        Objects.requireNonNull(this.font);
        return (9 + 1) * (!Screen.m_96638_() ? 1 : (this.items.isEmpty() ? 1 : 1));
    }

    public int m_142069_(Font font) {
        return this.gridSizeX() * 18 + 2 + 10;
    }

    public void m_183452_(Font p_194042_, int xIn, int yIn, PoseStack matrixStack, ItemRenderer p_194046_, int z) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        this.drawBorder(xIn, yIn, i, j, matrixStack, z);
        this.renderSlot(xIn + 1 + 5, yIn + 1 + 5 + this.getHeightOffset(), 0, p_194042_, matrixStack, p_194046_, z);
    }

    @Override
    public void renderImage(Font p_194042_, MultiBufferSource bufferSource, int xIn, int yIn, PoseStack matrixStack, ItemRenderer p_194046_, int z, int overlay, int light) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE_LOCATION));
        this.drawBorder(buffer, xIn, yIn, i, j, matrixStack, z, overlay, light);
        this.renderSlot(bufferSource, buffer, xIn + 1 + 5, yIn + 1 + 5 + this.getHeightOffset(), 0, p_194042_, matrixStack, p_194046_, z, overlay, light);
        this.renderSlotItemDecorations(bufferSource, buffer, xIn + 1 + 5, yIn + this.getHeightOffset() + 1 + 5, 0, p_194042_, matrixStack, p_194046_, z, overlay, light);
        this.renderSlotItemCount(bufferSource, buffer, xIn + 1 + 5, yIn + this.getHeightOffset() + 1 + 5, 0, p_194042_, matrixStack, p_194046_, z, overlay, light);
        this.renderSlotItem(bufferSource, buffer, xIn + 1 + 5, yIn + this.getHeightOffset() + 1 + 5, 0, p_194042_, matrixStack, p_194046_, z, overlay, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_142440_(Font p_169953_, int mouseX, int mouseY, Matrix4f lastpose, MultiBufferSource.BufferSource buffer) {
        boolean k = false;
        if (Screen.m_96638_()) {
            this.drawInternal(this.shift_down.m_7532_(), mouseX, mouseY, 0xFFFFFF, true, lastpose, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        } else {
            this.drawInternal(this.shift_up.m_7532_(), mouseX, mouseY, 0xFFFFFF, true, lastpose, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderText(Font p_169953_, int mouseX, int mouseY, Matrix4f lastpose, MultiBufferSource.BufferSource buffer, int overlay, int light) {
        if (Screen.m_96638_()) {
            this.drawInternal(this.shift_down.m_7532_(), 0.0f, 0.0f, 0xFFFFFF, false, lastpose, (MultiBufferSource)buffer, false, 0, light);
        } else {
            this.drawInternal(this.shift_up.m_7532_(), 0.0f, 0.0f, 0xFFFFFF, false, lastpose, (MultiBufferSource)buffer, false, 0, light);
        }
    }

    private void renderSlot(int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z) {
        ItemStack itemstack = this.items.getStackInSlot(slot);
        if (itemstack.m_41619_()) {
            this.blit(matrixStack, xIn, yIn, z, Texture.BLOCKED_SLOT);
        } else {
            this.blit(matrixStack, xIn, yIn, z, Texture.SLOT);
        }
        p_194033_.m_174253_(itemstack, xIn + 1, yIn + 1, slot);
        p_194033_.m_115169_(p_194031_, itemstack, xIn + 1, yIn + 1);
    }

    private void renderSlot(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.items.getStackInSlot(slot);
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, 1.0f, 1.0E-4f);
        if (itemstack.m_41619_()) {
            this.blit(matrixStack, buffer, xIn, yIn, 0, Texture.BLOCKED_SLOT, overlay, light);
        } else {
            this.blit(matrixStack, buffer, xIn, yIn, 0, Texture.SLOT, overlay, light);
        }
        matrixStack.m_85849_();
        RenderSystem.m_69482_();
    }

    private void renderSlotItem(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.items.getStackInSlot(slot);
        PageDrawing.renderGuiItem(bufferSource, p_194031_, itemstack, matrixStack, xIn, yIn, overlay, light);
        RenderSystem.m_69482_();
    }

    private void renderSlotItemCount(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.items.getStackInSlot(slot);
        PageDrawing.renderGuiItemCount(bufferSource, p_194031_, itemstack, matrixStack, xIn, yIn, overlay, light);
        RenderSystem.m_69482_();
    }

    private void renderSlotItemDecorations(MultiBufferSource bufferSource, VertexConsumer buffer, int xIn, int yIn, int slot, Font p_194031_, PoseStack matrixStack, ItemRenderer p_194033_, int z, int overlay, int light) {
        ItemStack itemstack = this.items.getStackInSlot(slot);
        PageDrawing.renderGuiItemDecorations(bufferSource, p_194031_, itemstack, matrixStack, xIn, yIn, overlay, light);
        RenderSystem.m_69482_();
    }

    private static int adjustColor(int p_92720_) {
        return (p_92720_ & 0xFC000000) == 0 ? p_92720_ | 0xFF000000 : p_92720_;
    }

    private int drawInternal(FormattedCharSequence p_92867_, float p_92868_, float p_92869_, int p_92870_, boolean p_92871_, Matrix4f p_92872_, MultiBufferSource p_92873_, boolean p_92874_, int p_92875_, int light) {
        int guiOffsetY;
        p_92870_ = ClientHerbJarToolTip.adjustColor(p_92870_);
        Matrix4f matrix4f = p_92872_.m_27658_();
        int guiOffsetX = light == 0xF000F0 ? -1 : 12;
        int n = guiOffsetY = light == 0xF000F0 ? -1 : 0;
        if (p_92871_) {
            matrix4f.m_27648_(new Vector3f(0.6f, 0.0f, 0.0f));
            Minecraft.m_91087_().f_91062_.m_92926_(p_92867_, p_92868_, p_92869_, p_92870_, false, p_92872_, p_92873_, p_92874_, p_92875_, light);
            matrix4f.m_27648_(new Vector3f(-1.2f, 0.0f, 0.0f));
            Minecraft.m_91087_().f_91062_.m_92926_(p_92867_, p_92868_, p_92869_, p_92870_, false, p_92872_, p_92873_, p_92874_, p_92875_, light);
            matrix4f.m_27648_(new Vector3f(0.6f, 0.6f, 0.0f));
            Minecraft.m_91087_().f_91062_.m_92926_(p_92867_, p_92868_, p_92869_, p_92870_, false, p_92872_, p_92873_, p_92874_, p_92875_, light);
            matrix4f.m_27648_(new Vector3f(0.0f, -1.2f, 0.0f));
            Minecraft.m_91087_().f_91062_.m_92926_(p_92867_, p_92868_, p_92869_, p_92870_, false, p_92872_, p_92873_, p_92874_, p_92875_, light);
            matrix4f.m_27648_(new Vector3f(1.0f, 1.75f, 1.0f));
        }
        p_92868_ = Minecraft.m_91087_().f_91062_.m_92733_(p_92867_, p_92868_ + (float)guiOffsetX, p_92869_ + (float)guiOffsetY, 0x1000000, false, matrix4f, p_92873_, p_92874_, p_92875_, light);
        return (int)p_92868_ + (p_92871_ ? 1 : 0);
    }

    private void drawBorder(int p_194020_, int p_194021_, int p_194022_, int p_194023_, PoseStack p_194024_, int p_194025_) {
        this.blit(p_194024_, p_194020_ + 5, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_TOP);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1 + 5, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_TOP);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, p_194020_ + 1 + i * 18 + 5, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(p_194024_, p_194020_ + 1 + i * 18 + 5, p_194021_ + p_194023_ * 20 - 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, p_194020_ + 5, p_194021_ + j * 18 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_VERTICAL);
            this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1 + 5, p_194021_ + j * 20 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_VERTICAL);
        }
        this.blit(p_194024_, p_194020_ + 5, p_194021_ + p_194023_ * 18 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_BOTTOM);
        this.blit(p_194024_, p_194020_ + p_194022_ * 18 + 1 + 5, p_194021_ + p_194023_ * 18 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_BOTTOM);
        this.blit(p_194024_, p_194020_, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_VERTICAL);
        this.blit(p_194024_, p_194020_ + 25, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_VERTICAL);
        this.blit(p_194024_, p_194020_ + 5, p_194021_ + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_HORIZONTAL);
        this.blit(p_194024_, p_194020_ + 5, p_194021_ + 25 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_HORIZONTAL);
        this.blit(p_194024_, p_194020_, p_194021_ + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_TOP_LEFT);
        this.blit(p_194024_, p_194020_ + 18 + 7, p_194021_ + 18 + 7 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_BOTTOM_RIGHT);
        this.blit(p_194024_, p_194020_, p_194021_ + 18 + 7 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_BOTTOM_LEFT);
        this.blit(p_194024_, p_194020_ + 18 + 7, p_194021_ + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_TOP_RIGHT);
    }

    private void drawBorder(VertexConsumer buffer, int p_194020_, int p_194021_, int p_194022_, int p_194023_, PoseStack p_194024_, int p_194025_, int overlay, int light) {
        this.blit(p_194024_, buffer, p_194020_ + 5, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_TOP, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + p_194022_ * 18 + 1 + 5, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_TOP, overlay, light);
        for (int i = 0; i < p_194022_; ++i) {
            this.blit(p_194024_, buffer, p_194020_ + 1 + i * 18 + 5, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_HORIZONTAL_TOP, overlay, light);
            this.blit(p_194024_, buffer, p_194020_ + 1 + i * 18 + 5, p_194021_ + p_194023_ * 20 - 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_HORIZONTAL_BOTTOM, overlay, light);
        }
        for (int j = 0; j < p_194023_; ++j) {
            this.blit(p_194024_, buffer, p_194020_ + 5, p_194021_ + j * 18 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_VERTICAL, overlay, light);
            this.blit(p_194024_, buffer, p_194020_ + p_194022_ * 18 + 1 + 5, p_194021_ + j * 20 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_VERTICAL, overlay, light);
        }
        this.blit(p_194024_, buffer, p_194020_ + 5, p_194021_ + p_194023_ * 18 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_BOTTOM, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + p_194022_ * 18 + 1 + 5, p_194021_ + p_194023_ * 18 + 1 + 5 + this.getHeightOffset(), p_194025_, Texture.BORDER_CORNER_BOTTOM, overlay, light);
        this.blit(p_194024_, buffer, p_194020_, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_VERTICAL, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + 25, p_194021_ + 5 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_VERTICAL, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + 5, p_194021_ + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + 5, p_194021_ + 25 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_HORIZONTAL, overlay, light);
        this.blit(p_194024_, buffer, p_194020_, p_194021_ + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_TOP_LEFT, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + 18 + 7, p_194021_ + 18 + 7 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_BOTTOM_RIGHT, overlay, light);
        this.blit(p_194024_, buffer, p_194020_, p_194021_ + 18 + 7 + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_BOTTOM_LEFT, overlay, light);
        this.blit(p_194024_, buffer, p_194020_ + 18 + 7, p_194021_ + this.getHeightOffset(), p_194025_, Texture.THICK_BORDER_CORNER_TOP_RIGHT, overlay, light);
    }

    private void blit(PoseStack p_194036_, int p_194037_, int p_194038_, int z, Texture p_194040_) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93143_((PoseStack)p_194036_, (int)p_194037_, (int)p_194038_, (int)(z == -420 ? 1 : z), (float)p_194040_.x, (float)p_194040_.y, (int)p_194040_.w, (int)p_194040_.h, (int)128, (int)128);
    }

    private void blit(PoseStack poseStack, VertexConsumer buffer, int xIn, int yIn, int zIn, Texture texture, int overlay, int light) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        ClientHerbJarToolTip.blit(poseStack, buffer, xIn, yIn, zIn, texture.x, texture.y, texture.w, texture.h, 128, 128, overlay, light);
    }

    public static void blit(PoseStack poseStack, VertexConsumer buffer, int xIn, int yIn, int zIn, float p_93148_, float p_93149_, int p_93150_, int p_93151_, int p_93152_, int p_93153_, int overlay, int light) {
        ClientHerbJarToolTip.innerBlit(poseStack, buffer, xIn, xIn + p_93150_, yIn, yIn + p_93151_, zIn, p_93150_, p_93151_, p_93148_, p_93149_, p_93152_, p_93153_, overlay, light);
    }

    private static void innerBlit(PoseStack p_93188_, VertexConsumer buffer, int p_93189_, int p_93190_, int p_93191_, int p_93192_, int p_93193_, int p_93194_, int p_93195_, float p_93196_, float p_93197_, int p_93198_, int p_93199_, int overlay, int light) {
        ClientHerbJarToolTip.innerBlit(p_93188_, buffer, p_93189_, p_93190_, p_93191_, p_93192_, p_93193_, (p_93196_ + 0.0f) / (float)p_93198_, (p_93196_ + (float)p_93194_) / (float)p_93198_, (p_93197_ + 0.0f) / (float)p_93199_, (p_93197_ + (float)p_93195_) / (float)p_93199_, overlay, light);
    }

    private static void innerBlit(PoseStack poseStack, VertexConsumer buffer, int p_93114_, int p_93115_, int p_93116_, int p_93117_, int p_93118_, float p_93119_, float p_93120_, float p_93121_, float p_93122_, int overlay, int light) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)p_93118_);
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93114_, (float)p_93117_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93119_, p_93122_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93115_, (float)p_93117_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93120_, p_93122_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93115_, (float)p_93116_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93120_, p_93121_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(poseStack.m_85850_().m_85861_(), (float)p_93114_, (float)p_93116_, (float)p_93118_).m_6122_(255, 255, 255, 255).m_7421_(p_93119_, p_93121_).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    private void fillRect(BufferBuilder p_115153_, int p_115154_, int p_115155_, int p_115156_, int p_115157_, int p_115158_, int p_115159_, int p_115160_, int p_115161_) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        p_115153_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        p_115153_.m_5483_((double)(p_115154_ + 0), (double)(p_115155_ + 0), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_5483_((double)(p_115154_ + 0), (double)(p_115155_ + p_115157_), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_5483_((double)(p_115154_ + p_115156_), (double)(p_115155_ + p_115157_), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_5483_((double)(p_115154_ + p_115156_), (double)(p_115155_ + 0), 0.0).m_6122_(p_115158_, p_115159_, p_115160_, p_115161_).m_5752_();
        p_115153_.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)p_115153_);
    }

    private int gridSizeX() {
        return 1;
    }

    private int gridSizeY() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        SLOT(0, 0, 18, 18),
        BLOCKED_SLOT(0, 40, 18, 18),
        BORDER_VERTICAL(0, 18, 1, 18),
        BORDER_HORIZONTAL_TOP(0, 18, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 58, 18, 1),
        BORDER_CORNER_TOP(0, 18, 1, 1),
        BORDER_CORNER_BOTTOM(0, 58, 1, 1),
        THICK_BORDER_CORNER_TOP_LEFT(0, 60, 5, 5),
        THICK_BORDER_CORNER_TOP_RIGHT(5, 60, 5, 5),
        THICK_BORDER_CORNER_BOTTOM_LEFT(0, 65, 5, 5),
        THICK_BORDER_CORNER_BOTTOM_RIGHT(5, 65, 5, 5),
        THICK_BORDER_VERTICAL(0, 75, 5, 20),
        THICK_BORDER_HORIZONTAL(0, 70, 20, 5);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

