/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.item.custom.WitchArmorItem;
import net.joefoxe.hexerei.util.HexereiSupporterBenefits;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={HumanoidArmorLayer.class}, priority=999)
public abstract class HumanoidArmorLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @OnlyIn(value=Dist.CLIENT)
    public HumanoidArmorLayerMixin(RenderLayerParent<T, M> p_117346_) {
        super(p_117346_);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="HEAD")}, method={"renderArmorPiece"}, cancellable=true)
    public void renderArmorPiece(PoseStack p_117119_, MultiBufferSource p_117120_, T p_117121_, EquipmentSlot p_117122_, int p_117123_, A p_117124_, CallbackInfo ci) {
        ArmorItem armoritem;
        ItemStack itemstack = p_117121_.m_6844_(p_117122_);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).m_40402_() == p_117122_) {
            ((HumanoidModel)this.m_117386_()).m_102872_(p_117124_);
            this.setPartVisibility(p_117124_, p_117122_);
            Model model = this.getArmorModelHook(p_117121_, itemstack, p_117122_, p_117124_);
            boolean flag1 = itemstack.m_41790_();
            if (armoritem instanceof WitchArmorItem) {
                Player player;
                WitchArmorItem witchArmorItem = (WitchArmorItem)armoritem;
                int i = witchArmorItem.m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                if (p_117121_ instanceof Player && HexereiSupporterBenefits.matchesSupporterUUID((player = (Player)p_117121_).m_142081_())) {
                    this.renderModel(p_117119_, p_117120_, 0xF000F0, flag1, model, f, f1, f2, this.getArmorResource((Entity)p_117121_, itemstack, p_117122_, null));
                    this.renderModel(p_117119_, p_117120_, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_117121_, itemstack, p_117122_, "overlay"));
                    ci.cancel();
                }
                if (p_117121_ instanceof Player && !HexereiSupporterBenefits.matchesSupporterUUID((player = (Player)p_117121_).m_142081_())) {
                    this.renderModel(p_117119_, p_117120_, p_117123_, flag1, model, f, f1, f2, this.getArmorResource((Entity)p_117121_, itemstack, p_117122_, null));
                    this.renderModel(p_117119_, p_117120_, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_117121_, itemstack, p_117122_, "overlay"));
                    ci.cancel();
                }
                if (!(p_117121_ instanceof Player)) {
                    this.renderModel(p_117119_, p_117120_, p_117123_, flag1, model, f, f1, f2, this.getArmorResource((Entity)p_117121_, itemstack, p_117122_, null));
                    this.renderModel(p_117119_, p_117120_, p_117123_, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_117121_, itemstack, p_117122_, "overlay"));
                    ci.cancel();
                }
            }
        }
    }

    private boolean usesInnerModel(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlot)slot, model);
    }

    private void renderModel(PoseStack p_117107_, MultiBufferSource p_117108_, int p_117109_, boolean p_117111_, Model p_117112_, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)p_117108_, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        p_117112_.m_7695_(p_117107_, vertexconsumer, p_117109_, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = (ResourceLocation)HumanoidArmorLayer.f_117070_.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            HumanoidArmorLayer.f_117070_.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    protected void setPartVisibility(A p_117126_, EquipmentSlot p_117127_) {
        p_117126_.m_8009_(false);
        switch (p_117127_) {
            case HEAD: {
                ((HumanoidModel)p_117126_).f_102808_.f_104207_ = true;
                ((HumanoidModel)p_117126_).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)p_117126_).f_102810_.f_104207_ = true;
                ((HumanoidModel)p_117126_).f_102811_.f_104207_ = true;
                ((HumanoidModel)p_117126_).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)p_117126_).f_102810_.f_104207_ = true;
                ((HumanoidModel)p_117126_).f_102813_.f_104207_ = true;
                ((HumanoidModel)p_117126_).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)p_117126_).f_102813_.f_104207_ = true;
                ((HumanoidModel)p_117126_).f_102814_.f_104207_ = true;
            }
        }
    }
}

