/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItemRenderer;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.util.CachedMap;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.items.ItemStackHandler;

public class BroomItem
extends Item {
    private static final Predicate<Entity> field_219989_a = EntitySelector.f_20408_.and(Entity::m_5829_);
    private final BroomEntity.Type type;
    private final CachedMap<ItemStack, BroomEntity> cachedBroom;
    public static final Comparator<ItemStack> ITEM_COMPARATOR = (item1, item2) -> {
        int cmp = item2.m_41720_().hashCode() - item1.m_41720_().hashCode();
        if (cmp != 0) {
            return cmp;
        }
        cmp = item2.m_41773_() - item1.m_41773_();
        if (cmp != 0) {
            return cmp;
        }
        CompoundTag c1 = item1.m_41783_();
        CompoundTag c2 = item2.m_41783_();
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1.hashCode() - c2.hashCode();
    };

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(30){};
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        ItemStackHandler handler = this.createHandler();
        handler.deserializeNBT(stack.m_41784_().m_128469_("Inventory"));
        return Optional.of(new BroomItemToolTip(handler, stack));
    }

    public BroomItem(BroomEntity.Type broomType, Item.Properties properties) {
        super(properties);
        this.type = broomType;
        this.cachedBroom = new CachedMap(10000L, ITEM_COMPARATOR);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        final CustomItemRenderer renderer = this.createItemRenderer();
        if (renderer != null) {
            consumer.accept(new IItemRenderProperties(){

                public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                    return renderer.getRenderer();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public CustomItemRenderer createItemRenderer() {
        return new BroomItemRenderer();
    }

    public BroomEntity getBroom(Level world, ItemStack stack) {
        BroomEntity broom = new BroomEntity((EntityType<BroomEntity>)((EntityType)ModEntityTypes.BROOM.get()), world);
        if (stack.m_41784_().m_128441_("floatMode")) {
            broom.itemHandler.deserializeNBT(stack.m_41784_().m_128469_("Inventory"));
        } else {
            broom.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ModItems.BROOM_BRUSH.get()));
        }
        broom.setBroomType(this.type);
        broom.isItem = true;
        broom.selfItem = stack.m_41777_();
        if (stack.m_41788_()) {
            broom.m_6593_(stack.m_41786_());
        }
        return broom;
    }

    public BroomEntity getBroomFast(Level world, ItemStack stack) {
        return this.cachedBroom.get(stack, () -> this.getBroom(world, stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = BroomItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vector3d = playerIn.m_20154_();
        double d0 = 5.0;
        List list = worldIn.m_6249_((Entity)playerIn, playerIn.m_142469_().m_82369_(vector3d.m_82490_(5.0)).m_82400_(1.0), field_219989_a);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = playerIn.m_20299_(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!axisalignedbb.m_82390_(vector3d1)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            BroomEntity boatentity = new BroomEntity(worldIn, raytraceresult.m_82450_().f_82479_, raytraceresult.m_82450_().f_82480_, raytraceresult.m_82450_().f_82481_);
            boatentity.setBroomType(this.type);
            boatentity.m_146922_(playerIn.m_146908_());
            boatentity.itemHandler.deserializeNBT(itemstack.m_41784_().m_128469_("Inventory"));
            if (!itemstack.m_41784_().m_128441_("floatMode")) {
                boatentity.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ModItems.BROOM_BRUSH.get()));
                boatentity.sync();
            }
            boatentity.floatMode = itemstack.m_41784_().m_128471_("floatMode");
            boatentity.m_6593_(itemstack.m_41786_());
            if (!worldIn.m_45756_((Entity)boatentity, boatentity.m_142469_().m_82400_(-0.1))) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)boatentity);
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.broom_shift_2", new Object[]{new TranslatableComponent(ModKeyBindings.broomDescend.getKey().m_84874_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xCCCC00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.broom_shift_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.broom_shift_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            if (stack.m_150930_((Item)ModItems.MAHOGANY_BROOM.get())) {
                tooltip.add((Component)new TranslatableComponent(""));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.mahogany_broom_shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.mahogany_broom_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            } else {
                tooltip.add((Component)new TranslatableComponent(""));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.willow_broom_shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)new TranslatableComponent("tooltip.hexerei.willow_broom_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public record BroomItemToolTip(ItemStackHandler handler, ItemStack self) implements TooltipComponent
    {
    }
}

