/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.data.recipes.PestleAndMortarRecipe;
import net.joefoxe.hexerei.integration.jei.DipperRecipeCategory;
import net.joefoxe.hexerei.integration.jei.DryingRackRecipeCategory;
import net.joefoxe.hexerei.integration.jei.MixingCauldronRecipeCategory;
import net.joefoxe.hexerei.integration.jei.MixingCauldronTransferInfo;
import net.joefoxe.hexerei.integration.jei.PestleAndMortarRecipeCategory;
import net.joefoxe.hexerei.screen.BroomScreen;
import net.joefoxe.hexerei.screen.CofferScreen;
import net.joefoxe.hexerei.screen.MixingCauldronScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class HexereiJei
implements IModPlugin {
    public static IRecipesGui runtime;
    public static RecipeManager recipeManager;
    public static final ResourceLocation MIXING_CAULDRON_UID;
    public static final ResourceLocation DIPPER_UID;
    public static final ResourceLocation DRYING_RACK_UID;
    public static final ResourceLocation PESTLE_AND_MORTAR_UID;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("hexerei", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime.getRecipesGui();
        super.onRuntimeAvailable(jeiRuntime);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingCauldronRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DipperRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new PestleAndMortarRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DryingRackRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new ResourceLocation[]{MIXING_CAULDRON_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CANDLE_DIPPER.get()), new ResourceLocation[]{DIPPER_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get()), new ResourceLocation[]{DRYING_RACK_UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PESTLE_AND_MORTAR.get()), new ResourceLocation[]{PESTLE_AND_MORTAR_UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MixingCauldronScreen.class, 66, 30, 28, 26, new RecipeType[]{new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class)});
        registration.addGuiContainerHandler(CofferScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CofferScreen>(){

            public List<Rect2i> getGuiExtraAreas(CofferScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                Rect2i rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop(), 214, 157);
                ret.add(rect2i);
                return ret;
            }
        });
        registration.addGuiContainerHandler(BroomScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BroomScreen>(){

            public List<Rect2i> getGuiExtraAreas(BroomScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                Rect2i rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop(), 214, 82 + gui.offset);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop() + 79 + gui.offset, 214, 34);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft() + 184, gui.getGuiTop() + 55 + gui.offset + (int)gui.dropdownOffset, 26, 58);
                ret.add(rect2i);
                return ret;
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm;
        recipeManager = rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List mixing_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)MixingCauldronRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class), mixing_recipes);
        List pestle_and_mortar_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)PestleAndMortarRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(PestleAndMortarRecipeCategory.UID, PestleAndMortarRecipe.class), pestle_and_mortar_recipes);
        List dipper_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)DipperRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(DipperRecipeCategory.UID, DipperRecipe.class), dipper_recipes);
        List drying_rack_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)DryingRackRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(DryingRackRecipeCategory.UID, DryingRackRecipe.class), drying_rack_recipes);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MixingCauldronTransferInfo(), ModRecipeTypes.MIXING_SERIALIZER.getId());
    }

    public static void showUses(final FluidStack fluid) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<FluidStack>(){

            public ITypedIngredient<FluidStack> getTypedValue() {
                return new ITypedIngredient<FluidStack>(){

                    public IIngredientTypeWithSubtypes<Fluid, FluidStack> getType() {
                        return ForgeTypes.FLUID_STACK;
                    }

                    public FluidStack getIngredient() {
                        return fluid;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == ForgeTypes.FLUID_STACK) {
                            return Optional.of(fluid);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.CATALYST;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }

            public IFocus.Mode getMode() {
                return IFocus.Mode.INPUT;
            }
        });
        if (!(Minecraft.m_91087_().f_91080_ instanceof IRecipesGui)) {
            if (runtime == null) {
                return;
            }
            runtime.show((IFocus)new IFocus<FluidStack>(){

                public ITypedIngredient<FluidStack> getTypedValue() {
                    return new ITypedIngredient<FluidStack>(){

                        public IIngredientTypeWithSubtypes<Fluid, FluidStack> getType() {
                            return ForgeTypes.FLUID_STACK;
                        }

                        public FluidStack getIngredient() {
                            return fluid;
                        }

                        public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                            if (ingredientType == ForgeTypes.FLUID_STACK) {
                                return Optional.of(fluid);
                            }
                            return Optional.empty();
                        }
                    };
                }

                public RecipeIngredientRole getRole() {
                    return RecipeIngredientRole.INPUT;
                }

                public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                    return Optional.empty();
                }

                public IFocus.Mode getMode() {
                    return IFocus.Mode.INPUT;
                }
            });
        }
    }

    public static void showUses(final ItemStack item) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<ItemStack>(){

            public ITypedIngredient<ItemStack> getTypedValue() {
                return new ITypedIngredient<ItemStack>(){

                    public IIngredientType<ItemStack> getType() {
                        return VanillaTypes.ITEM_STACK;
                    }

                    public ItemStack getIngredient() {
                        return item;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == VanillaTypes.ITEM_STACK) {
                            return Optional.of(item);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.CATALYST;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }

            public IFocus.Mode getMode() {
                return IFocus.Mode.INPUT;
            }
        });
        if (!(Minecraft.m_91087_().f_91080_ instanceof IRecipesGui)) {
            if (runtime == null) {
                return;
            }
            runtime.show((IFocus)new IFocus<ItemStack>(){

                public ITypedIngredient<ItemStack> getTypedValue() {
                    return new ITypedIngredient<ItemStack>(){

                        public IIngredientType<ItemStack> getType() {
                            return VanillaTypes.ITEM_STACK;
                        }

                        public ItemStack getIngredient() {
                            return item;
                        }

                        public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                            if (ingredientType == VanillaTypes.ITEM_STACK) {
                                return Optional.of(item);
                            }
                            return Optional.empty();
                        }
                    };
                }

                public RecipeIngredientRole getRole() {
                    return RecipeIngredientRole.INPUT;
                }

                public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                    return Optional.empty();
                }

                public IFocus.Mode getMode() {
                    return IFocus.Mode.INPUT;
                }
            });
        }
    }

    public static void showRecipe(final ItemStack item) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<ItemStack>(){

            public ITypedIngredient<ItemStack> getTypedValue() {
                return new ITypedIngredient<ItemStack>(){

                    public IIngredientType<ItemStack> getType() {
                        return VanillaTypes.ITEM_STACK;
                    }

                    public ItemStack getIngredient() {
                        return item;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == VanillaTypes.ITEM_STACK) {
                            return Optional.of(item);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.OUTPUT;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }

            public IFocus.Mode getMode() {
                return IFocus.Mode.OUTPUT;
            }
        });
    }

    public static void showRecipe(final FluidStack fluid) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<FluidStack>(){

            public ITypedIngredient<FluidStack> getTypedValue() {
                return new ITypedIngredient<FluidStack>(){

                    public IIngredientType<FluidStack> getType() {
                        return ForgeTypes.FLUID_STACK;
                    }

                    public FluidStack getIngredient() {
                        return fluid;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == ForgeTypes.FLUID_STACK) {
                            return Optional.of(fluid);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.OUTPUT;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }

            public IFocus.Mode getMode() {
                return IFocus.Mode.OUTPUT;
            }
        });
    }

    static {
        MIXING_CAULDRON_UID = new ResourceLocation("hexerei", "mixingcauldron");
        DIPPER_UID = new ResourceLocation("hexerei", "dipper");
        DRYING_RACK_UID = new ResourceLocation("hexerei", "drying_rack");
        PESTLE_AND_MORTAR_UID = new ResourceLocation("hexerei", "pestle_and_mortar");
    }
}

