/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.HerbDryingRack;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DryingRackRecipeCategory
implements IRecipeCategory<DryingRackRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "drying_rack");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/drying_rack_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public DryingRackRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 100, 53);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DryingRackRecipe> getRecipeClass() {
        return DryingRackRecipe.class;
    }

    public Component getTitle() {
        return ((HerbDryingRack)ModBlocks.HERB_DRYING_RACK.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DryingRackRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, DryingRackRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 13, 15);
        recipeLayout.getItemStacks().init(1, false, 69, 15);
        recipeLayout.getItemStacks().set(ingredients);
    }

    public void draw(DryingRackRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        String dryingTimeString;
        int dryingTime = recipe.getDryingTime();
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        Object object = dryingTime < Integer.MAX_VALUE ? dryingTime / 20 + (String)(dryingTime % 20 == 0 ? "" : "." + Integer.toString(dryingTime % 20)) : (dryingTimeString = "?");
        if (dryingTimeString.charAt(dryingTimeString.length() - 1) == '0' && dryingTime != 0 && dryingTime % 20 != 0) {
            dryingTimeString = dryingTimeString.substring(0, dryingTimeString.length() - 1);
        }
        TranslatableComponent dip_time_1 = new TranslatableComponent("gui.jei.category.dipper.dry_time_1");
        TranslatableComponent dip_time_3 = new TranslatableComponent("gui.jei.category.dipper.resultSeconds", new Object[]{dryingTimeString});
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dip_time_1, 9.996f, 68.306f, -8355712);
        minecraft.f_91062_.m_92889_(matrixStack, (Component)dip_time_3, 91.63f, 68.306f, -8355712);
        String outputName = recipe.m_8043_().m_41786_().getString();
        minecraft.f_91062_.m_92883_(matrixStack, outputName, 8.33f, 6.664f, -12566464);
    }
}

