/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CrowModel<T extends CrowEntity>
extends ColorableAgeableListModel<T> {
    public final ModelPart body;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hexerei", "crow"), "main");
    public static final ModelLayerLocation POWER_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hexerei", "crow_power_layer"), "main");

    public CrowModel(ModelPart root) {
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayerNone() {
        return CrowModel.createBodyLayer(CubeDeformation.f_171458_);
    }

    public static LayerDefinition createBodyLayerEnlarge() {
        return CrowModel.createBodyLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition chest = body.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(1, 6).m_171488_(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, cube).m_171514_(0, 14).m_171488_(-1.5f, -2.308f, -0.4665f, 3.0f, 2.0f, 0.0f, cube), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bandana_r1 = chest.m_171599_("bandana_r1", CubeListBuilder.m_171558_().m_171514_(4, 16).m_171488_(-0.5f, -5.225f, -0.425f, 1.0f, 1.0f, 0.0f, cube), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)2.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(12, 7).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, cube), PartPose.m_171419_((float)-1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(12, 7).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, cube), PartPose.m_171419_((float)1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition rightWing_r1 = rightWing.m_171599_("rightWing_r1", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171480_().m_171488_(-11.0f, -5.5f, -2.5f, 10.0f, 0.0f, 6.0f, cube).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)5.5f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition leftWing_r1 = leftWing.m_171599_("leftWing_r1", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(1.0f, -5.5f, -2.5f, 10.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-1.0f, (float)5.5f, (float)-0.5f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition rightTail = body.m_171599_("rightTail", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftTail = body.m_171599_("leftTail", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, cube).m_171555_(false), PartPose.m_171423_((float)0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition tailMid = body.m_171599_("tailMid", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 7.0f, cube), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition wings = body.m_171599_("wings", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-2.0f, -3.5f, -0.5f, 4.0f, 4.0f, 7.0f, cube), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -3.0f, -3.0f, 3.0f, 3.0f, 3.0f, cube), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-1.5f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-0.5f, -0.0434f, -2.0f, 1.0f, 1.0f, 2.0f, cube), PartPose.m_171423_((float)0.0f, (float)-0.924f, (float)-2.7521f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-0.5f, -0.25f, -0.925f, 1.0f, 1.0f, 2.0f, cube), PartPose.m_171423_((float)0.0f, (float)-1.75f, (float)-4.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderOnShoulder(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float p_228284_5_, float p_228284_6_, float p_228284_7_, float p_228284_8_, int p_228284_9_) {
        this.body.m_171324_((String)"leftWing").f_104207_ = false;
        this.body.m_171324_((String)"rightWing").f_104207_ = false;
        this.body.m_171324_((String)"wings").f_104207_ = true;
        this.body.m_104301_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(CrowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart leftWing = this.body.m_171324_("leftWing");
        ModelPart rightWing = this.body.m_171324_("rightWing");
        ModelPart wings = this.body.m_171324_("wings");
        ModelPart rightLeg = this.body.m_171324_("rightLeg");
        ModelPart leftLeg = this.body.m_171324_("leftLeg");
        ModelPart head = this.body.m_171324_("head");
        ModelPart rightTail = this.body.m_171324_("rightTail");
        ModelPart leftTail = this.body.m_171324_("leftTail");
        ModelPart tailMid = this.body.m_171324_("tailMid");
        ModelPart head_r1 = head.m_171324_("head_r1");
        if (!entity.m_20096_() || !entity.m_21825_()) {
            this.body.f_104201_ = 24.0f;
        }
        if (entity.m_20096_()) {
            leftWing.f_104207_ = false;
            rightWing.f_104207_ = false;
            wings.f_104207_ = true;
            if (entity.m_21824_() && entity.m_21825_()) {
                rightLeg.f_104203_ = -0.5235988f;
                leftLeg.f_104203_ = -0.5235988f;
                rightLeg.f_104201_ = -4.0f;
                rightLeg.f_104202_ = 1.5f;
                leftLeg.f_104201_ = -4.0f;
                leftLeg.f_104202_ = 1.5f;
                this.body.f_104201_ = 25.5f;
            } else {
                rightLeg.f_104201_ = -3.0f;
                rightLeg.f_104202_ = 0.5f;
                leftLeg.f_104201_ = -3.0f;
                leftLeg.f_104202_ = 0.5f;
                rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
            }
            head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            rightTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            rightTail.f_104204_ = -Mth.m_14031_((float)0.05f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.05f);
            rightTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            tailMid.f_104204_ = Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            if (entity.tailWag) {
                rightTail.f_104204_ += Mth.m_14031_((float)0.15f) * 0.5f;
                leftTail.f_104204_ -= Mth.m_14031_((float)0.15f) * 0.5f;
            }
            rightTail.f_104204_ -= Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
        } else if (entity.m_20159_()) {
            leftWing.f_104207_ = false;
            rightWing.f_104207_ = false;
            wings.f_104207_ = true;
            rightLeg.f_104203_ = -0.5235988f;
            leftLeg.f_104203_ = -0.5235988f;
            rightLeg.f_104201_ = -4.0f;
            rightLeg.f_104202_ = 1.5f;
            leftLeg.f_104201_ = -4.0f;
            leftLeg.f_104202_ = 1.5f;
            this.body.f_104201_ = 25.5f;
            head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            rightTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)(Hexerei.getClientTicks() / 25.0f)) * 0.1f;
            rightTail.f_104204_ = -Mth.m_14031_((float)0.05f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.05f);
            rightTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            tailMid.f_104204_ = Mth.m_14031_((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            if (entity.tailWag) {
                rightTail.f_104204_ += Mth.m_14031_((float)0.15f) * 0.5f;
                leftTail.f_104204_ -= Mth.m_14031_((float)0.15f) * 0.5f;
            }
            rightTail.f_104204_ -= Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
        } else {
            leftWing.f_104207_ = true;
            rightWing.f_104207_ = true;
            wings.f_104207_ = false;
            rightLeg.f_104203_ = Mth.m_14031_((float)20.0f);
            leftLeg.f_104203_ = Mth.m_14031_((float)20.0f);
            rightWing.f_104205_ = entity.rightWingAngleActual;
            leftWing.f_104205_ = entity.leftWingAngleActual;
            head.f_104203_ = (float)Math.toRadians(headPitch);
            rightTail.f_104204_ = -Mth.m_14031_((float)0.15f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.15f);
        }
        this.body.f_104203_ = Mth.m_14031_((float)(entity.peckTiltAngleActual / 100.0f));
        head.f_104204_ = (float)Math.toRadians(netHeadYaw);
        head.f_104205_ = Mth.m_14031_((float)(entity.headZTiltAngleActual / 100.0f)) / 2.0f;
        head.f_104203_ += Mth.m_14031_((float)(entity.headXTiltAngleActual / 100.0f)) / 2.0f;
        if ((entity.m_20096_() || entity.m_20159_()) && entity.dance) {
            head.f_104205_ = 0.0f;
            head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)((float)entity.animationCounter / 1.5f)) / 12.0f;
            head.f_104204_ = (float)Math.toRadians(netHeadYaw) + Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) / 4.0f;
            rightTail.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            this.body.f_104204_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.2f;
            rightTail.f_104204_ = Mth.m_14031_((float)0.1f);
            leftTail.f_104204_ = -Mth.m_14031_((float)0.1f);
            this.body.f_104201_ = 24.0f + Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            rightTail.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            leftTail.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            tailMid.f_104204_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            rightLeg.f_104201_ = -3.0f - Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            rightLeg.f_104202_ = 0.5f;
            leftLeg.f_104201_ = -3.0f - Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            leftLeg.f_104202_ = 0.5f;
            rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
        } else {
            this.body.f_104204_ = 0.0f;
        }
        head_r1.f_104203_ = Mth.m_14031_((float)(entity.cawTiltAngleActual / 100.0f));
        if (entity.peckTiltAngleActual > 0.0f) {
            head_r1.f_104203_ = Mth.m_14031_((float)(entity.peckTiltAngleActual / 100.0f));
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return null;
    }

    protected Iterable<ModelPart> m_5608_() {
        return null;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }
}

