/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import net.minecraft.world.item.ItemStack;

public class RegexMatcher
implements IItemMatcher {
    private final List<Pattern> patterns;

    public RegexMatcher(List<String> regex) {
        this.patterns = Lists.newArrayListWithCapacity((int)regex.size());
        for (String r : regex) {
            try {
                Pattern pat = Pattern.compile(r, 2);
                this.patterns.add(pat);
            }
            catch (PatternSyntaxException e) {
                ModularRouters.LOGGER.warn("can't compile '" + r + "' - " + e.getMessage());
            }
        }
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        if (stack.m_41619_()) {
            return false;
        }
        String name = stack.m_41720_().getRegistryName().m_135815_();
        return this.patterns.stream().anyMatch(pat -> pat.matcher(name).find());
    }
}

