/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.AbstractModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.item.module.FluidModule1;
import me.desht.modularrouters.logic.compiled.CompiledFluidModule1;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.Range;

public class FluidModuleScreen
extends AbstractModuleScreen {
    private static final ItemStack bucketStack = new ItemStack((ItemLike)Items.f_42446_);
    private static final ItemStack routerStack = new ItemStack((ItemLike)ModBlocks.MODULAR_ROUTER.get());
    private static final ItemStack waterStack = new ItemStack((ItemLike)Items.f_42447_);
    private ForceEmptyButton forceEmptyButton;
    private RegulateAbsoluteButton regulationTypeButton;
    private FluidDirectionButton fluidDirButton;
    private IntegerTextField maxTransferField;

    public FluidModuleScreen(ContainerModule container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        CompiledFluidModule1 cfm = new CompiledFluidModule1(null, this.moduleItemStack);
        TextFieldManager manager = this.getOrCreateTextFieldManager();
        int max = (Integer)ConfigHolder.common.router.baseTickRate.get() * (Integer)ConfigHolder.common.router.fluidMaxTransferRate.get();
        this.maxTransferField = new IntegerTextField(manager, this.f_96547_, this.f_97735_ + 152, this.f_97736_ + 23, 34, 12, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(max)));
        this.maxTransferField.setValue(cfm.getMaxTransfer());
        this.maxTransferField.m_94151_(str -> this.sendModuleSettingsDelayed(5));
        this.maxTransferField.setIncr(100, 10, 10);
        this.maxTransferField.useGuiTextBackground();
        manager.focus(0);
        this.m_142416_((GuiEventListener)new TooltipButton(this.f_97735_ + 130, this.f_97736_ + 19, 16, 16, bucketStack));
        this.fluidDirButton = new FluidDirectionButton(this.f_97735_ + 148, this.f_97736_ + 44, cfm.getFluidDirection());
        this.m_142416_((GuiEventListener)this.fluidDirButton);
        this.forceEmptyButton = new ForceEmptyButton(this.f_97735_ + 168, this.f_97736_ + 69, cfm.isForceEmpty());
        this.m_142416_((GuiEventListener)this.forceEmptyButton);
        this.regulationTypeButton = new RegulateAbsoluteButton(this.regulatorTextField.f_93620_ + this.regulatorTextField.m_5711_() + 2, this.regulatorTextField.f_93621_ - 1, 18, 14, b -> this.toggleRegulationType(), cfm.isRegulateAbsolute());
        this.m_142416_((GuiEventListener)this.regulationTypeButton);
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 128, this.f_97736_ + 17, this.f_97735_ + 183, this.f_97736_ + 35, "modularrouters.guiText.popup.fluid.maxTransfer");
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 126, this.f_97736_ + 42, this.f_97735_ + 185, this.f_97736_ + 61, "modularrouters.guiText.popup.fluid.direction");
        this.getMouseOverHelp().addHelpRegion(this.f_97735_ + 128, this.f_97736_ + 67, this.f_97735_ + 185, this.f_97736_ + 86, "modularrouters.guiText.popup.fluid.forceEmpty");
    }

    @Override
    protected IntegerTextField buildRegulationTextField(TextFieldManager manager) {
        IntegerTextField tf = new IntegerTextField(manager, this.f_96547_, this.f_97735_ + 128, this.f_97736_ + 90, 40, 12, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        tf.setValue(this.getRegulatorAmount());
        tf.m_94151_(str -> {
            this.setRegulatorAmount(str.isEmpty() ? 0 : Integer.parseInt(str));
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.m_93228_(matrixStack, this.f_97735_ + 146, this.f_97736_ + 20, LARGE_TEXTFIELD_XY.x(), LARGE_TEXTFIELD_XY.y(), 35, 14);
        GuiUtil.renderItemStack(matrixStack, this.f_96541_, routerStack, this.f_97735_ + 128, this.f_97736_ + 44, "");
        GuiUtil.renderItemStack(matrixStack, this.f_96541_, waterStack, this.f_97735_ + 168, this.f_97736_ + 44, "");
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        if (this.forceEmptyButton.f_93624_) {
            MutableComponent c = ClientUtil.xlate("modularrouters.guiText.label.fluidForceEmpty", new Object[0]);
            this.f_96547_.m_92889_(matrixStack, (Component)c, (float)(165 - this.f_96547_.m_92852_((FormattedText)c)), 73.0f, 0x202040);
        }
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.regulationTypeButton.f_93624_ = this.regulatorTextField.f_93624_;
        this.regulationTypeButton.setText();
        this.regulatorTextField.setRange((Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.regulationTypeButton.regulateAbsolute ? Integer.MAX_VALUE : 100)));
        this.forceEmptyButton.f_93624_ = this.fluidDirButton.getState() == FluidModule1.FluidDirection.OUT;
    }

    @Override
    protected CompoundTag buildMessageData() {
        CompoundTag compound = super.buildMessageData();
        compound.m_128405_("MaxTransfer", this.maxTransferField.getIntValue());
        compound.m_128344_("FluidDir", (byte)((FluidModule1.FluidDirection)this.fluidDirButton.getState()).ordinal());
        compound.m_128379_("ForceEmpty", this.forceEmptyButton.isToggled());
        compound.m_128379_("RegulateAbsolute", this.regulationTypeButton.regulateAbsolute);
        return compound;
    }

    private void toggleRegulationType() {
        this.regulationTypeButton.toggle();
        this.regulatorTextField.setRange((Range<Integer>)(this.regulationTypeButton.regulateAbsolute ? Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100))));
        this.sendToServer();
    }

    private class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height, ItemStack renderStack) {
            super(x, y, width, height, renderStack, true, p -> {});
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.fluidTransferTooltip", new Object[0]);
            this.tooltip1.add(TextComponent.f_131282_.m_6879_());
            FluidModuleScreen.this.getItemRouter().ifPresent(router -> {
                int ftRate = router.getFluidTransferRate();
                int tickRate = router.getTickRate();
                this.tooltip1.add(ClientUtil.xlate("modularrouters.guiText.tooltip.maxFluidPerOp", ftRate * tickRate, tickRate, ftRate));
                this.tooltip1.add(TextComponent.f_131282_.m_6879_());
            });
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void m_7435_(SoundManager soundHandlerIn) {
        }
    }

    private class FluidDirectionButton
    extends TexturedCyclerButton<FluidModule1.FluidDirection> {
        private final List<List<Component>> tooltips;

        FluidDirectionButton(int x, int y, FluidModule1.FluidDirection initialVal) {
            super(x, y, 16, 16, initialVal, FluidModuleScreen.this);
            this.tooltips = Lists.newArrayList();
            for (FluidModule1.FluidDirection dir : FluidModule1.FluidDirection.values()) {
                this.tooltips.add(Collections.singletonList(ClientUtil.xlate(dir.getTranslationKey(), new Object[0])));
            }
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(160 + ((FluidModule1.FluidDirection)this.getState()).ordinal() * 16, 16);
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltips.get(((FluidModule1.FluidDirection)this.getState()).ordinal());
        }
    }

    private class ForceEmptyButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(192, 16);

        ForceEmptyButton(int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, FluidModuleScreen.this);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.fluidForceEmpty.false", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.fluidForceEmpty.true", new Object[0]);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private static class RegulateAbsoluteButton
    extends ExtendedButton {
        private boolean regulateAbsolute;

        public RegulateAbsoluteButton(int xPos, int yPos, int width, int height, Button.OnPress pressable, boolean regulateAbsolute) {
            super(xPos, yPos, width, height, TextComponent.f_131282_, pressable);
            this.regulateAbsolute = regulateAbsolute;
        }

        private void toggle() {
            this.regulateAbsolute = !this.regulateAbsolute;
        }

        void setText() {
            this.m_93666_((Component)new TextComponent(this.regulateAbsolute ? "mB" : "%"));
        }
    }
}

