/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.AbstractMRContainerScreen;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.RadioButton;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.ModuleSettingsMessage;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.Range;

public class AbstractModuleScreen
extends AbstractMRContainerScreen<ContainerModule>
implements ContainerListener,
IMouseOverHelpProvider,
ISendToServer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("modularrouters", "textures/gui/module.png");
    static final XYPoint SMALL_TEXTFIELD_XY = new XYPoint(0, 198);
    static final XYPoint LARGE_TEXTFIELD_XY = new XYPoint(0, 212);
    static final XYPoint BUTTON_XY = new XYPoint(0, 226);
    private static final int GUI_HEIGHT = 198;
    private static final int GUI_WIDTH = 192;
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    final ItemStack moduleItemStack;
    private final ModuleItem module;
    private final BlockPos routerPos;
    private final int moduleSlotIndex;
    private final InteractionHand hand;
    private ModuleItem.RelativeDirection facing;
    private int sendDelay;
    private int regulatorAmount;
    private final MouseOverHelp mouseOverHelp;
    final AugmentItem.AugmentCounter augmentCounter;
    private final boolean matchAll;
    private RedstoneBehaviourButton redstoneButton;
    private RegulatorTooltipButton regulatorTooltipButton;
    private final EnumMap<ModuleItem.RelativeDirection, DirectionButton> directionButtons = new EnumMap(ModuleItem.RelativeDirection.class);
    private final EnumMap<ModuleItem.ModuleFlags, ModuleToggleButton> toggleButtons = new EnumMap(ModuleItem.ModuleFlags.class);
    private MouseOverHelp.Button mouseOverHelpButton;
    private TexturedToggleButton matchAllButton;
    IntegerTextField regulatorTextField;
    private TerminationButton terminationButton;
    private static final int THRESHOLD = 129;

    public AbstractModuleScreen(ContainerModule container, Inventory inventory, Component displayName) {
        super(container, inventory, displayName);
        MFLocator locator = container.getLocator();
        this.moduleSlotIndex = locator.routerSlot;
        this.hand = locator.hand;
        this.routerPos = locator.routerPos;
        this.moduleItemStack = locator.getModuleStack(inventory.f_35978_);
        this.module = (ModuleItem)this.moduleItemStack.m_41720_();
        this.facing = ModuleHelper.getRelativeDirection(this.moduleItemStack);
        this.regulatorAmount = ModuleHelper.getRegulatorAmount(this.moduleItemStack);
        this.augmentCounter = new AugmentItem.AugmentCounter(this.moduleItemStack);
        this.matchAll = ModuleHelper.isMatchAll(this.moduleItemStack);
        this.f_97726_ = 192;
        this.f_97727_ = 198;
        this.mouseOverHelp = new MouseOverHelp(this);
        this.f_96546_ = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void m_7856_() {
        super.m_7856_();
        this.addToggleButton(ModuleItem.ModuleFlags.BLACKLIST, 7, 75);
        this.addToggleButton(ModuleItem.ModuleFlags.IGNORE_DAMAGE, 7, 93);
        this.addToggleButton(ModuleItem.ModuleFlags.IGNORE_NBT, 25, 75);
        this.addToggleButton(ModuleItem.ModuleFlags.IGNORE_TAGS, 25, 93);
        this.terminationButton = (TerminationButton)this.m_142416_((GuiEventListener)new TerminationButton(this.f_97735_ + 45, this.f_97736_ + 93, ModuleHelper.getTermination(this.moduleItemStack)));
        this.matchAllButton = (TexturedToggleButton)this.m_142416_((GuiEventListener)new MatchAllButton(this.f_97735_ + 45, this.f_97736_ + 75, this.matchAll));
        if (this.module.isDirectional()) {
            this.addDirectionButton(ModuleItem.RelativeDirection.NONE, 70, 18);
            this.addDirectionButton(ModuleItem.RelativeDirection.UP, 87, 18);
            this.addDirectionButton(ModuleItem.RelativeDirection.LEFT, 70, 35);
            this.addDirectionButton(ModuleItem.RelativeDirection.FRONT, 87, 35);
            this.addDirectionButton(ModuleItem.RelativeDirection.RIGHT, 104, 35);
            this.addDirectionButton(ModuleItem.RelativeDirection.DOWN, 87, 52);
            this.addDirectionButton(ModuleItem.RelativeDirection.BACK, 104, 52);
        }
        this.mouseOverHelpButton = (MouseOverHelp.Button)this.m_142416_((GuiEventListener)new MouseOverHelp.Button(this.f_97735_ + 175, this.f_97736_ + 1));
        this.redstoneButton = (RedstoneBehaviourButton)this.m_142416_((GuiEventListener)new RedstoneBehaviourButton(this.f_97735_ + 170, this.f_97736_ + 93, 16, 16, ModuleHelper.getRedstoneBehaviour(this.moduleItemStack), (ISendToServer)this));
        this.regulatorTextField = (IntegerTextField)this.m_142416_((GuiEventListener)this.buildRegulationTextField(this.getOrCreateTextFieldManager()));
        this.regulatorTooltipButton = (RegulatorTooltipButton)this.m_142416_((GuiEventListener)new RegulatorTooltipButton(this.regulatorTextField.f_93620_ - 16, this.regulatorTextField.f_93621_ - 2, this.module.isFluidModule()));
        if (this.routerPos != null) {
            this.m_142416_((GuiEventListener)new BackButton(this.f_97735_ + 2, this.f_97736_ + 1, p -> PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openRouter(((ContainerModule)this.f_97732_).getLocator()))));
        }
        this.mouseOverHelp.addHelpRegion(this.f_97735_ + 7, this.f_97736_ + 16, this.f_97735_ + 60, this.f_97736_ + 69, "modularrouters.guiText.popup.filter");
        this.mouseOverHelp.addHelpRegion(this.f_97735_ + 5, this.f_97736_ + 73, this.f_97735_ + 62, this.f_97736_ + 110, "modularrouters.guiText.popup.filterControl");
        this.mouseOverHelp.addHelpRegion(this.f_97735_ + 68, this.f_97736_ + 16, this.f_97735_ + 121, this.f_97736_ + 69, this.module.isDirectional() ? "modularrouters.guiText.popup.direction" : "modularrouters.guiText.popup.noDirection");
        this.mouseOverHelp.addHelpRegion(this.f_97735_ + 77, this.f_97736_ + 74, this.f_97735_ + 112, this.f_97736_ + 109, "modularrouters.guiText.popup.augments");
    }

    protected IntegerTextField buildRegulationTextField(TextFieldManager manager) {
        IntegerTextField tf = new IntegerTextField(manager, this.f_96547_, this.f_97735_ + 166, this.f_97736_ + 75, 20, 12, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(64)));
        tf.setValue(this.regulatorAmount);
        tf.m_94151_(str -> {
            this.regulatorAmount = str.isEmpty() ? 0 : Integer.parseInt(str);
            this.sendModuleSettingsDelayed(5);
        });
        return tf;
    }

    @SubscribeEvent
    public void onInitGui(ScreenEvent.InitScreenEvent.Post event) {
        ((ContainerModule)this.m_6262_()).m_38943_(this);
        ((ContainerModule)this.m_6262_()).m_38893_(this);
        this.setupButtonVisibility();
    }

    public int getRegulatorAmount() {
        return this.regulatorAmount;
    }

    public void setRegulatorAmount(int regulatorAmount) {
        this.regulatorAmount = regulatorAmount;
    }

    protected void setupButtonVisibility() {
        this.redstoneButton.f_93624_ = this.augmentCounter.getAugmentCount((Item)ModItems.REDSTONE_AUGMENT.get()) > 0;
        this.regulatorTooltipButton.f_93624_ = this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0;
        this.regulatorTextField.m_94194_(this.regulatorTooltipButton.f_93624_);
    }

    private void addToggleButton(ModuleItem.ModuleFlags flag, int x, int y) {
        this.toggleButtons.put(flag, new ModuleToggleButton(flag, this.f_97735_ + x, this.f_97736_ + y, ModuleHelper.checkFlag(this.moduleItemStack, flag)));
        this.m_142416_((GuiEventListener)this.toggleButtons.get((Object)flag));
    }

    private void addDirectionButton(ModuleItem.RelativeDirection dir, int x, int y) {
        this.directionButtons.put(dir, new DirectionButton(dir, this.module, this.f_97735_ + x, this.f_97736_ + y, dir == this.facing));
        this.m_142416_((GuiEventListener)this.directionButtons.get((Object)dir));
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.mouseOverHelp.setActive(this.mouseOverHelpButton.isToggled());
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.sendToServer();
        }
    }

    void sendModuleSettingsDelayed(int delay) {
        this.sendDelay = delay;
    }

    @Override
    public void sendToServer() {
        PacketHandler.NETWORK.sendToServer((Object)new ModuleSettingsMessage(((ContainerModule)this.f_97732_).getLocator(), this.buildMessageData()));
    }

    protected CompoundTag buildMessageData() {
        RouterRedstoneBehaviour behaviour = this.redstoneButton == null ? RouterRedstoneBehaviour.ALWAYS : (RouterRedstoneBehaviour)this.redstoneButton.getState();
        CompoundTag compound = new CompoundTag();
        for (ModuleItem.ModuleFlags flag : ModuleItem.ModuleFlags.values()) {
            compound.m_128379_(flag.getName(), this.toggleButtons.get((Object)flag).isToggled());
        }
        compound.m_128359_("Termination", ((ModuleItem.Termination)this.terminationButton.getState()).toString());
        compound.m_128359_("Direction", this.facing.toString());
        compound.m_128344_("RedstoneMode", (byte)behaviour.ordinal());
        compound.m_128405_("RegulatorAmount", this.regulatorAmount);
        compound.m_128379_("MatchAll", this.matchAllButton.isToggled());
        return compound;
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        MutableComponent title = this.moduleItemStack.m_41786_().m_6881_().m_130946_((String)(this.routerPos != null ? " " + I18n.m_118938_((String)"modularrouters.guiText.label.installed", (Object[])new Object[0]) : ""));
        this.f_96547_.m_92889_(matrixStack, (Component)title, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)title) / 2.0f, 5.0f, this.getFgColor(this.module.getItemTint()));
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        TintColor c = this.getGuiBackgroundTint();
        GuiUtil.bindTexture(GUI_TEXTURE, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.module.isDirectional()) {
            this.m_93228_(matrixStack, this.f_97735_ + 69, this.f_97736_ + 17, 204, 0, 52, 52);
        }
    }

    private TintColor getGuiBackgroundTint() {
        if (((Boolean)ConfigHolder.client.misc.moduleGuiBackgroundTint.get()).booleanValue()) {
            TintColor c = this.module.getItemTint();
            float[] hsb = TintColor.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            return TintColor.getHSBColor(hsb[0], hsb[1] * 0.7f, hsb[2]);
        }
        return TintColor.WHITE;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || ClientUtil.isInvKey(keyCode) && !this.isFocused()) && this.routerPos != null) {
            PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openRouter(((ContainerModule)this.f_97732_).getLocator()));
            return true;
        }
        if (ClientSetup.keybindConfigure.getKey().m_84873_() == keyCode) {
            return this.handleFilterConfig();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6375_(double x, double y, int button) {
        return button == 2 ? this.handleFilterConfig() : super.m_6375_(x, y, button);
    }

    private boolean handleFilterConfig() {
        SmartFilterItem filter;
        Slot slot;
        block11: {
            block10: {
                Item item;
                slot = this.getSlotUnderMouse();
                if (slot == null || !((item = slot.m_7993_().m_41720_()) instanceof SmartFilterItem)) break block10;
                filter = (SmartFilterItem)item;
                if (slot.f_40219_ >= 0 && slot.f_40219_ < 9) break block11;
            }
            return false;
        }
        int filterSlotIndex = slot.f_40219_;
        if (this.routerPos != null) {
            MFLocator locator = MFLocator.filterInInstalledModule(this.routerPos, this.moduleSlotIndex, filterSlotIndex);
            if (filter.hasContainer()) {
                PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openFilterInInstalledModule(locator));
            } else {
                FilterScreenFactory.openFilterGui(locator);
            }
        } else if (this.hand != null) {
            MFLocator locator = MFLocator.filterInHeldModule(this.hand, filterSlotIndex);
            if (filter.hasContainer()) {
                PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openFilterInHeldModule(locator));
            } else {
                FilterScreenFactory.openFilterGui(locator);
            }
        }
        return true;
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.sendDelay > 0) {
            this.sendToServer();
        }
    }

    Optional<ModularRouterBlockEntity> getItemRouter() {
        return this.routerPos != null ? Minecraft.m_91087_().f_91073_.m_141902_(this.routerPos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()) : Optional.empty();
    }

    public void m_7934_(AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
        if (slotInd >= 9 && slotInd < 13) {
            this.augmentCounter.refresh(this.moduleItemStack);
            this.setupButtonVisibility();
        }
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int i1) {
    }

    private int getFgColor(TintColor bg) {
        int luminance = (int)Math.sqrt((double)(bg.getRed() * bg.getRed()) * 0.241 + (double)(bg.getGreen() * bg.getGreen()) * 0.691 + (double)(bg.getBlue() * bg.getBlue()) * 0.068);
        return luminance > 129 ? 0x404040 : 0xFFFFFF;
    }

    @Override
    public MouseOverHelp getMouseOverHelp() {
        return this.mouseOverHelp;
    }

    private class TerminationButton
    extends TexturedCyclerButton<ModuleItem.Termination> {
        private final List<List<Component>> tooltips;

        public TerminationButton(int x, int y, ModuleItem.Termination initialVal) {
            super(x, y, 16, 16, initialVal, AbstractModuleScreen.this);
            this.tooltips = Lists.newArrayList();
            for (ModuleItem.Termination termination : ModuleItem.Termination.values()) {
                ArrayList<Component> l = new ArrayList<Component>();
                l.add((Component)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]));
                MiscUtil.appendMultilineText(l, ChatFormatting.GRAY, termination.getTranslationKey(), new Object[0]);
                this.tooltips.add(l);
            }
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltips.get(((ModuleItem.Termination)this.getState()).ordinal());
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((ModuleItem.Termination)this.getState()) {
                default -> throw new IncompatibleClassChangeError();
                case ModuleItem.Termination.NONE -> 128;
                case ModuleItem.Termination.NOT_RAN -> 224;
                case ModuleItem.Termination.RAN -> 144;
            };
            return new XYPoint(x, 32);
        }
    }

    private class MatchAllButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(208, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(224, 16);

        MatchAllButton(int x, int y, boolean toggled) {
            super(x, y, 16, 16, toggled, AbstractModuleScreen.this);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.matchAll.false", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.matchAll.true", new Object[0]);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private static class RegulatorTooltipButton
    extends TexturedButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 0);

        RegulatorTooltipButton(int x, int y, boolean isFluid) {
            super(x, y, 16, 16, p -> {});
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, isFluid ? "modularrouters.guiText.tooltip.fluidRegulatorTooltip" : "modularrouters.guiText.tooltip.regulatorTooltip", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void m_7435_(SoundManager soundHandlerIn) {
        }
    }

    private class ModuleToggleButton
    extends TexturedToggleButton {
        private final ModuleItem.ModuleFlags flag;

        ModuleToggleButton(ModuleItem.ModuleFlags flag, int x, int y, boolean toggled) {
            super(x, y, 16, 16, toggled, AbstractModuleScreen.this);
            this.flag = flag;
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip." + flag + ".1", new Object[0]);
            MiscUtil.appendMultilineText(this.tooltip2, ChatFormatting.WHITE, "modularrouters.guiText.tooltip." + flag + ".2", new Object[0]);
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(this.flag.ordinal() * 16 * 2 + (this.isToggled() ? 16 : 0), this.flag.getTextureY());
        }
    }

    private class DirectionButton
    extends RadioButton {
        private static final int DIRECTION_GROUP = 1;
        private final ModuleItem.RelativeDirection direction;

        DirectionButton(ModuleItem.RelativeDirection dir, ModuleItem module, int x, int y, boolean toggled) {
            super(1, x, y, 16, 16, toggled, AbstractModuleScreen.this);
            this.direction = dir;
            this.tooltip1.add(module.getDirectionString(dir).m_130940_(ChatFormatting.GRAY));
            this.tooltip2.add(module.getDirectionString(dir).m_130940_(ChatFormatting.YELLOW));
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(this.direction.getTextureX(this.isToggled()), this.direction.getTextureY());
        }

        public ModuleItem.RelativeDirection getDirection() {
            return this.direction;
        }

        public void m_5691_() {
            for (ModuleItem.RelativeDirection dir : ModuleItem.RelativeDirection.values()) {
                DirectionButton db = AbstractModuleScreen.this.directionButtons.get((Object)dir);
                db.setToggled(false);
                if (db != this) continue;
                AbstractModuleScreen.this.facing = db.getDirection();
            }
            super.m_5691_();
        }
    }
}

