/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineGasTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TurbineMultiblockData
extends MultiblockData {
    public static final long GAS_PER_TANK = 64000L;
    public static final float ROTATION_THRESHOLD = 0.001f;
    public static final Object2FloatMap<UUID> clientRotationMap = new Object2FloatOpenHashMap();
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"})
    public IGasTank gasTank;
    @ContainerSync
    public IExtendedFluidTank ventTank;
    public final List<IExtendedFluidTank> ventTanks;
    @ContainerSync
    public IEnergyContainer energyContainer;
    @ContainerSync
    @SyntheticComputerMethod(getter="getDumpingMode")
    public TileEntityChemicalTank.GasMode dumpMode = TileEntityChemicalTank.GasMode.IDLE;
    private FloatingLong energyCapacity = FloatingLong.ZERO;
    @ContainerSync
    @SyntheticComputerMethod(getter="getBlades")
    public int blades;
    @ContainerSync
    @SyntheticComputerMethod(getter="getVents")
    public int vents;
    @ContainerSync
    @SyntheticComputerMethod(getter="getCoils")
    public int coils;
    @ContainerSync
    @SyntheticComputerMethod(getter="getCondensers")
    public int condensers;
    @ContainerSync
    public int lowerVolume;
    public BlockPos complex;
    @ContainerSync
    @SyntheticComputerMethod(getter="getLastSteamInputRate")
    public long lastSteamInput;
    public long newSteamInput;
    @ContainerSync
    @SyntheticComputerMethod(getter="getFlowRate")
    public long clientFlow;
    public float clientRotation;
    public float prevSteamScale;

    public TurbineMultiblockData(TileEntityTurbineCasing tile) {
        super((BlockEntity)tile);
        this.gasTank = new TurbineGasTank(this, tile);
        this.gasTanks.add(this.gasTank);
        this.ventTank = VariableCapacityFluidTank.create(() -> this.isFormed() ? this.condensers * MekanismGeneratorsConfig.generators.condenserRate.get() : 1000, (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isFormed(), (BiPredicate)BasicFluidTank.internalOnly, fluid -> MekanismTags.Fluids.WATER_LOOKUP.contains((IForgeRegistryEntry)fluid.getFluid()), null);
        this.ventTanks = Collections.singletonList(this.ventTank);
        this.energyContainer = VariableCapacityEnergyContainer.create(this::getEnergyCapacity, automationType -> automationType != AutomationType.EXTERNAL || this.isFormed(), (Predicate)BasicEnergyContainer.internalOnly, null);
        this.energyContainers.add(this.energyContainer);
    }

    public boolean tick(Level world) {
        float scale;
        float newRotation;
        boolean needsPacket = super.tick(world);
        this.lastSteamInput = this.newSteamInput;
        this.newSteamInput = 0L;
        long stored = this.gasTank.getStored();
        double flowRate = 0.0;
        FloatingLong energyNeeded = this.energyContainer.getNeeded();
        if (stored > 0L && !energyNeeded.isZero()) {
            FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
            if (energyMultiplier.isZero()) {
                this.clientFlow = 0L;
            } else {
                double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
                rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
                double proportion = (double)stored / (double)this.getSteamCapacity();
                double origRate = rate;
                rate = Math.min(Math.min((double)stored, rate), energyNeeded.divide(energyMultiplier).doubleValue()) * proportion;
                this.clientFlow = MathUtils.clampToLong((double)rate);
                if (this.clientFlow > 0L) {
                    flowRate = rate / origRate;
                    this.energyContainer.insert(energyMultiplier.multiply(rate), Action.EXECUTE, AutomationType.INTERNAL);
                    this.gasTank.shrinkStack(this.clientFlow, Action.EXECUTE);
                    this.ventTank.setStack(new FluidStack((Fluid)Fluids.f_76193_, Math.min(MathUtils.clampToInt((double)rate), this.condensers * MekanismGeneratorsConfig.generators.condenserRate.get())));
                }
            }
        } else {
            this.clientFlow = 0L;
        }
        if (this.dumpMode != TileEntityChemicalTank.GasMode.IDLE && !this.gasTank.isEmpty()) {
            long amount = this.gasTank.getStored();
            if (this.dumpMode == TileEntityChemicalTank.GasMode.DUMPING) {
                this.gasTank.shrinkStack(this.getDumpingAmount(amount), Action.EXECUTE);
            } else {
                long targetLevel = MathUtils.clampToLong((double)((double)this.gasTank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
                if (targetLevel < amount) {
                    this.gasTank.shrinkStack(Math.min(amount - targetLevel, this.getDumpingAmount(amount)), Action.EXECUTE);
                }
            }
        }
        if (Math.abs((newRotation = (float)flowRate) - this.clientRotation) > 0.001f) {
            this.clientRotation = newRotation;
            needsPacket = true;
        }
        if ((scale = MekanismUtils.getScale((float)this.prevSteamScale, (IChemicalTank)this.gasTank)) != this.prevSteamScale) {
            needsPacket = true;
            this.prevSteamScale = scale;
        }
        return needsPacket;
    }

    private long getDumpingAmount(long stored) {
        return Math.min(stored, Math.max(stored / 50L, this.lastSteamInput * 2L));
    }

    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            this.prevSteamScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"volume", this::setVolume);
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"lowerVolume", value -> {
            this.lowerVolume = value;
        });
        NBTUtils.setGasStackIfPresent((CompoundTag)tag, (String)"gas", value -> this.gasTank.setStack((ChemicalStack)value));
        NBTUtils.setBlockPosIfPresent((CompoundTag)tag, (String)"complex", value -> {
            this.complex = value;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"rotation", value -> {
            this.clientRotation = value;
        });
        clientRotationMap.put((Object)this.inventoryID, this.clientRotation);
    }

    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128350_("scale", this.prevSteamScale);
        tag.m_128405_("volume", this.getVolume());
        tag.m_128405_("lowerVolume", this.lowerVolume);
        tag.m_128365_("gas", (Tag)((GasStack)this.gasTank.getStack()).write(new CompoundTag()));
        tag.m_128365_("complex", (Tag)NbtUtils.m_129224_((BlockPos)this.complex));
        tag.m_128350_("rotation", this.clientRotation);
    }

    @ComputerMethod
    public int getDispersers() {
        return (this.length() - 2) * (this.width() - 2) - 1;
    }

    public long getSteamCapacity() {
        return (long)this.lowerVolume * 64000L;
    }

    @Nonnull
    public FloatingLong getEnergyCapacity() {
        return this.energyCapacity;
    }

    public void setVolume(int volume) {
        super.setVolume(volume);
        this.energyCapacity = FloatingLong.createConst((long)((long)this.getVolume() * 16000000L));
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.gasTank.getStored(), (long)this.gasTank.getCapacity());
    }

    @ComputerMethod
    public FloatingLong getProductionRate() {
        FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
        return energyMultiplier.multiply(this.clientFlow);
    }

    @ComputerMethod
    public FloatingLong getMaxProduction() {
        FloatingLong energyMultiplier = ((FloatingLong)MekanismConfig.general.maxEnergyPerSteam.get()).divide(28L).multiply((long)Math.min(this.blades, this.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get()));
        double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
        rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
        return energyMultiplier.multiply(rate);
    }

    @ComputerMethod
    public long getMaxFlowRate() {
        double rate = (double)this.lowerVolume * ((double)this.getDispersers() * MekanismGeneratorsConfig.generators.turbineDisperserGasFlow.get());
        rate = Math.min(rate, (double)this.vents * MekanismGeneratorsConfig.generators.turbineVentGasFlow.get());
        return MathUtils.clampToLong((double)rate);
    }

    @ComputerMethod
    public long getMaxWaterOutput() {
        return (long)this.condensers * (long)MekanismGeneratorsConfig.generators.condenserRate.get();
    }

    @ComputerMethod(nameOverride="setDumpingMode")
    public void setDumpMode(TileEntityChemicalTank.GasMode mode) {
        if (this.dumpMode != mode) {
            this.dumpMode = mode;
            this.markDirty();
        }
    }

    @ComputerMethod
    private void incrementDumpingMode() {
        this.setDumpMode((TileEntityChemicalTank.GasMode)this.dumpMode.getNext());
    }

    @ComputerMethod
    private void decrementDumpingMode() {
        this.setDumpMode((TileEntityChemicalTank.GasMode)this.dumpMode.getPrevious());
    }
}

