/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.ClientMessages;
import sonar.fluxnetworks.register.Messages;

public class FMLChannel
extends Channel {
    private static final ResourceLocation LOCATION = new ResourceLocation("modernui", "fluxnetworks");

    FMLChannel() {
        NetworkRegistry.newEventChannel((ResourceLocation)LOCATION, () -> "707", "707"::equals, "707"::equals).registerObject((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    void onCustomPayload(@Nonnull NetworkEvent.ServerCustomPayloadEvent e) {
        FriendlyByteBuf payload = e.getPayload();
        ClientMessages.msg(payload.readShort(), payload, () -> ((NetworkEvent.Context)e.getSource().get()).getNetworkManager().m_129536_() ? Minecraft.m_91087_().f_91074_ : null);
        ((NetworkEvent.Context)e.getSource().get()).setPacketHandled(true);
    }

    @SubscribeEvent
    void onCustomPayload(@Nonnull NetworkEvent.ClientCustomPayloadEvent e) {
        FriendlyByteBuf payload = e.getPayload();
        Messages.msg(payload.readShort(), payload, () -> ((NetworkEvent.Context)e.getSource().get()).getNetworkManager().m_129536_() ? ((NetworkEvent.Context)e.getSource().get()).getSender() : null);
        ((NetworkEvent.Context)e.getSource().get()).setPacketHandled(true);
    }

    @Override
    public void sendToServer(@Nonnull FriendlyByteBuf payload) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(LOCATION, payload));
        } else {
            payload.release();
        }
    }

    @Override
    public void sendToPlayer(@Nonnull FriendlyByteBuf payload, @Nonnull ServerPlayer player) {
        player.f_8906_.m_141995_((Packet)new ClientboundCustomPayloadPacket(LOCATION, payload));
    }

    @Override
    public void sendToAll(@Nonnull FriendlyByteBuf payload) {
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11268_((Packet)new ClientboundCustomPayloadPacket(LOCATION, payload));
    }

    @Override
    public void sendToTrackingChunk(@Nonnull FriendlyByteBuf payload, @Nonnull LevelChunk chunk) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(LOCATION, payload);
        ((ServerLevel)chunk.m_62953_()).m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false).forEach(p -> p.f_8906_.m_141995_((Packet)packet));
    }

    static {
        FluxNetworks.LOGGER.warn("Use FML network channel (low performance)");
    }
}

