/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.energy.IItemEnergyBridge;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.common.capability.FluxPlayer;
import sonar.fluxnetworks.common.connection.TransferHandler;
import sonar.fluxnetworks.common.device.TileFluxController;
import sonar.fluxnetworks.common.integration.CuriosIntegration;
import sonar.fluxnetworks.common.util.EnergyUtils;
import sonar.fluxnetworks.common.util.FluxUtils;

public class FluxControllerHandler
extends TransferHandler {
    private static final Predicate<ItemStack> NOT_EMPTY = s -> !s.m_41619_();
    private final Map<ServerPlayer, Iterable<WirelessHandler>> mPlayers = new HashMap<ServerPlayer, Iterable<WirelessHandler>>();
    private int mTimer;
    private long mDesired;
    final TileFluxController mDevice;

    public FluxControllerHandler(TileFluxController fluxController) {
        super(FluxConfig.defaultLimit);
        this.mDevice = fluxController;
    }

    @Override
    public void onCycleStart() {
        if (this.mTimer == 0) {
            this.updatePlayers();
        }
        if ((this.mTimer & 3) == 2) {
            this.mDesired = this.chargeAllItems(this.getLimit(), true);
        }
    }

    @Override
    public void onCycleEnd() {
        this.mChange = -this.sendToConsumers(Math.min(this.mBuffer, this.getLimit()));
        this.mBuffer += this.mChange;
        ++this.mTimer;
        this.mTimer &= 0x3F;
    }

    @Override
    public void addToBuffer(long energy) {
        this.mBuffer += energy;
    }

    @Override
    public long getRequest() {
        return Math.max(this.mDesired - this.mBuffer, 0L);
    }

    @Override
    public void onNetworkChanged() {
        super.onNetworkChanged();
        this.mPlayers.clear();
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        super.writeCustomTag(tag, type);
        tag.m_128356_("buffer", this.mBuffer);
    }

    private long sendToConsumers(long energy) {
        if ((this.mTimer & 3) > 0) {
            return 0L;
        }
        return this.chargeAllItems(energy, false);
    }

    private long chargeAllItems(long energy, boolean simulate) {
        long leftover = energy;
        for (Map.Entry<ServerPlayer, Iterable<WirelessHandler>> player : this.mPlayers.entrySet()) {
            if (!player.getKey().m_6084_()) continue;
            for (WirelessHandler handler : player.getValue()) {
                leftover = handler.chargeItems(leftover, simulate);
                if (leftover > 0L) continue;
                return energy;
            }
        }
        return energy - leftover;
    }

    private void updatePlayers() {
        this.mPlayers.clear();
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (NetworkMember p : this.mDevice.getNetwork().getAllMembers()) {
            int wireless;
            FluxPlayer fluxPlayer;
            ServerPlayer player = playerList.m_11259_(p.getPlayerUUID());
            if (player == null || (fluxPlayer = FluxUtils.get((ICapabilityProvider)player, FluxPlayer.FLUX_PLAYER)) == null || fluxPlayer.getWirelessNetwork() != this.mDevice.getNetworkID() || !WirelessType.ENABLE_WIRELESS.isActivated(wireless = fluxPlayer.getWirelessMode()) || (wireless & ~(1 << WirelessType.ENABLE_WIRELESS.ordinal())) == 0) continue;
            final Inventory inventory = player.m_150109_();
            ArrayList<WirelessHandler> handlers = new ArrayList<WirelessHandler>();
            if (WirelessType.MAIN_HAND.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> new Iterator<ItemStack>(){
                    private int mCount;

                    @Override
                    public boolean hasNext() {
                        return this.mCount < 1;
                    }

                    @Override
                    public ItemStack next() {
                        ++this.mCount;
                        return inventory.m_36056_();
                    }
                }, NOT_EMPTY));
            }
            if (WirelessType.OFF_HAND.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> inventory.f_35976_.iterator(), NOT_EMPTY));
            }
            if (WirelessType.HOT_BAR.isActivated(wireless)) {
                List bar = inventory.f_35974_.subList(0, Inventory.m_36059_());
                handlers.add(new WirelessHandler(bar::iterator, stack -> {
                    ItemStack heldItem = inventory.m_36056_();
                    return !stack.m_41619_() && (heldItem.m_41619_() || heldItem != stack);
                }));
            }
            if (WirelessType.ARMOR.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> inventory.f_35975_.iterator(), NOT_EMPTY));
            }
            if (WirelessType.CURIOS.isActivated(wireless) && FluxNetworks.isCuriosLoaded()) {
                final LazyOptional<IItemHandlerModifiable> curios = CuriosIntegration.getEquippedCurios(player);
                handlers.add(new WirelessHandler(() -> {
                    if (curios.isPresent()) {
                        return new Iterator<ItemStack>(){
                            private final IItemHandler mItemHandler;
                            private int mCount;
                            {
                                this.mItemHandler = (IItemHandler)curios.orElseThrow(IllegalStateException::new);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.mCount < this.mItemHandler.getSlots();
                            }

                            @Override
                            public ItemStack next() {
                                ItemStack next = this.mItemHandler.getStackInSlot(this.mCount);
                                ++this.mCount;
                                return next;
                            }
                        };
                    }
                    return null;
                }, NOT_EMPTY));
            }
            if (handlers.isEmpty()) continue;
            this.mPlayers.put(player, handlers);
        }
    }

    private record WirelessHandler(Supplier<Iterator<ItemStack>> stacks, Predicate<ItemStack> validator) {
        private long chargeItems(long leftover, boolean simulate) {
            Iterator<ItemStack> it = this.stacks.get();
            while (it != null && it.hasNext()) {
                IItemEnergyBridge handler;
                ItemStack stack = it.next();
                if (!this.validator.test(stack) || (handler = EnergyUtils.getBridge(stack)) == null || !handler.canAddEnergy(stack) || (leftover -= handler.addEnergy(leftover, stack, simulate)) > 0L) continue;
                return 0L;
            }
            return leftover;
        }
    }
}

