/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.widget;

import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.InputFilter;
import icyllis.modernui.text.TextWatcher;
import icyllis.modernui.text.method.DigitsInputFilter;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.EditText;
import icyllis.modernui.widget.LinearLayout;
import java.util.Locale;
import javax.annotation.Nullable;
import sonar.fluxnetworks.client.design.FluxDesign;
import sonar.fluxnetworks.client.design.RoundRectDrawable;

public class ColorPicker
extends LinearLayout {
    private static final InputFilter.LengthFilter sLengthFilter = new InputFilter.LengthFilter(3);
    private final EditText mRedField = FluxDesign.createTextField();
    private final EditText mGreenField;
    private final EditText mBlueField;
    private OnColorChangeListener mOnColorChangeListener;
    private boolean mPreventUpdateColor;
    private int mColor;

    public ColorPicker() {
        RoundRectDrawable bg;
        this.mRedField.setTextAlignment(4);
        this.mRedField.setHint((CharSequence)"R");
        this.mRedField.setHintTextColor(-8355712);
        Drawable drawable = this.mRedField.getBackground();
        if (drawable instanceof RoundRectDrawable) {
            RoundRectDrawable bg2 = (RoundRectDrawable)drawable;
            bg2.setColor(12533824);
        }
        this.mRedField.setFilters(new InputFilter[]{DigitsInputFilter.getInstance((Locale)this.mRedField.getTextLocale()), sLengthFilter});
        this.mRedField.setMinWidth(ColorPicker.dp((float)72.0f));
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ColorPicker.this.updateColor();
            }
        };
        this.mRedField.addTextChangedListener(textWatcher);
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    int r = ColorPicker.this.mRedField.getText().isEmpty() ? 0 : Integer.parseInt(ColorPicker.this.mRedField.getText().toString());
                    int g = ColorPicker.this.mGreenField.getText().isEmpty() ? 0 : Integer.parseInt(ColorPicker.this.mGreenField.getText().toString());
                    int b = ColorPicker.this.mBlueField.getText().isEmpty() ? 0 : Integer.parseInt(ColorPicker.this.mBlueField.getText().toString());
                    int color = (r = Math.min(r, 255)) << 16 | (g = Math.min(g, 255)) << 8 | (b = Math.min(b, 255));
                    if (color != ColorPicker.this.mColor) {
                        ColorPicker.this.mColor = color;
                    }
                    ColorPicker.this.updateRgbText();
                    if (ColorPicker.this.mOnColorChangeListener != null) {
                        ColorPicker.this.mOnColorChangeListener.onFocusLost(ColorPicker.this, ColorPicker.this.mColor);
                    }
                }
            }
        };
        this.mRedField.setOnFocusChangeListener(onFocusChangeListener);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        params.setMargins(ColorPicker.dp((float)4.0f), ColorPicker.dp((float)4.0f), ColorPicker.dp((float)4.0f), ColorPicker.dp((float)4.0f));
        this.addView((View)this.mRedField, (ViewGroup.LayoutParams)params);
        this.mGreenField = FluxDesign.createTextField();
        this.mGreenField.setTextAlignment(4);
        this.mGreenField.setHint((CharSequence)"G");
        this.mGreenField.setHintTextColor(-8355712);
        Drawable drawable2 = this.mGreenField.getBackground();
        if (drawable2 instanceof RoundRectDrawable) {
            bg = (RoundRectDrawable)drawable2;
            bg.setColor(4243264);
        }
        this.mGreenField.setFilters(new InputFilter[]{DigitsInputFilter.getInstance((Locale)this.mGreenField.getTextLocale()), sLengthFilter});
        this.mGreenField.setMinWidth(ColorPicker.dp((float)72.0f));
        this.mGreenField.addTextChangedListener(textWatcher);
        this.mGreenField.setOnFocusChangeListener(onFocusChangeListener);
        this.addView((View)this.mGreenField, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(params));
        this.mBlueField = FluxDesign.createTextField();
        this.mBlueField.setTextAlignment(4);
        this.mBlueField.setHint((CharSequence)"B");
        this.mBlueField.setHintTextColor(-8355712);
        drawable2 = this.mBlueField.getBackground();
        if (drawable2 instanceof RoundRectDrawable) {
            bg = (RoundRectDrawable)drawable2;
            bg.setColor(4210879);
        }
        this.mBlueField.setFilters(new InputFilter[]{DigitsInputFilter.getInstance((Locale)this.mBlueField.getTextLocale()), sLengthFilter});
        this.mBlueField.setMinWidth(ColorPicker.dp((float)72.0f));
        this.mBlueField.addTextChangedListener(textWatcher);
        this.mBlueField.setOnFocusChangeListener(onFocusChangeListener);
        this.addView((View)this.mBlueField, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(params));
    }

    public void setColor(int color) {
        if (color != this.mColor) {
            this.mColor = color;
            this.updateRgbText();
            this.invokeListener();
        }
    }

    public void setOnColorChangeListener(@Nullable OnColorChangeListener onColorChangeListener) {
        this.mOnColorChangeListener = onColorChangeListener;
    }

    private void updateColor() {
        if (this.mPreventUpdateColor) {
            return;
        }
        if (this.mRedField.getText().isEmpty() || this.mGreenField.getText().isEmpty() || this.mBlueField.getText().isEmpty()) {
            return;
        }
        int r = Integer.parseInt(this.mRedField.getText().toString());
        int g = Integer.parseInt(this.mGreenField.getText().toString());
        int b = Integer.parseInt(this.mBlueField.getText().toString());
        int color = (r = Math.min(r, 255)) << 16 | (g = Math.min(g, 255)) << 8 | (b = Math.min(b, 255));
        if (color != this.mColor) {
            this.mColor = color;
            this.updateRgbText();
            this.invokeListener();
        }
    }

    private void updateRgbText() {
        int r = this.mColor >> 16 & 0xFF;
        int g = this.mColor >> 8 & 0xFF;
        int b = this.mColor & 0xFF;
        this.mPreventUpdateColor = true;
        this.mRedField.setTextKeepState((CharSequence)Integer.toString(r));
        this.mGreenField.setTextKeepState((CharSequence)Integer.toString(g));
        this.mBlueField.setTextKeepState((CharSequence)Integer.toString(b));
        this.mPreventUpdateColor = false;
    }

    private void invokeListener() {
        if (this.mOnColorChangeListener != null) {
            this.mOnColorChangeListener.onColorChanged(this, this.mColor);
        }
    }

    public static interface OnColorChangeListener {
        public void onColorChanged(ColorPicker var1, int var2);

        public void onFocusLost(ColorPicker var1, int var2);
    }
}

