/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiTabPages;
import sonar.fluxnetworks.client.gui.popup.PopupMemberEdit;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabMembers
extends GuiTabPages<NetworkMember> {
    public NetworkMember mSelectedMember;

    public GuiTabMembers(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mGridHeight = 13;
        this.mGridPerPage = 9;
        this.mElementWidth = 146;
        this.mElementHeight = 12;
        if (this.getNetwork().isValid()) {
            ClientMessages.updateNetwork(this.getToken(), this.getNetwork(), (byte)22);
        }
    }

    @Override
    @Nonnull
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_MEMBER;
    }

    @Override
    protected void drawBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        if (this.getNetwork().isValid()) {
            String access = this.getAccessLevel().getFormattedName();
            this.f_96547_.m_92883_(poseStack, access, (float)(this.f_97735_ + 158 - this.f_96547_.m_92895_(access)), (float)(this.f_97736_ + 24), 0xFFFFFF);
            String sortBy = FluxTranslate.SORT_BY.get() + ": " + ChatFormatting.AQUA + this.mSortType.getTranslatedName();
            this.f_96547_.m_92883_(poseStack, sortBy, (float)(this.f_97735_ + 19), (float)(this.f_97736_ + 24), 0xFFFFFF);
            this.renderNetwork(poseStack, this.getNetwork().getNetworkName(), this.getNetwork().getNetworkColor(), this.f_97736_ + 8);
        } else {
            this.renderNavigationPrompt(poseStack, FluxTranslate.ERROR_NO_SELECTED, EnumNavigationTab.TAB_SELECTION);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mGridStartX = this.f_97735_ + 15;
        this.mGridStartY = this.f_97736_ + 36;
        this.refreshPages(this.getNetwork().getAllMembers());
    }

    @Override
    protected void onElementClicked(NetworkMember element, int mouseButton) {
        if (mouseButton == 0) {
            this.mSelectedMember = element;
            this.openPopup(new PopupMemberEdit(this));
        }
    }

    @Override
    public void renderElement(PoseStack poseStack, NetworkMember element, int x, int y) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        int color = element.getAccessLevel().getColor();
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON);
        this.blitF(poseStack, x, y, this.mElementWidth, this.mElementHeight, 0.0f, 352.0f, this.mElementWidth * 2, this.mElementHeight * 2);
        if (element.getPlayerUUID().equals(this.mPlayer.m_142081_())) {
            GuiTabMembers.m_93172_((PoseStack)poseStack, (int)(x - 2), (int)y, (int)(x - 1), (int)(y + this.mElementHeight), (int)-1);
            GuiTabMembers.m_93172_((PoseStack)poseStack, (int)(x + this.mElementWidth + 1), (int)y, (int)(x + this.mElementWidth + 2), (int)(y + this.mElementHeight), (int)-1);
        }
        this.f_96547_.m_92883_(poseStack, ChatFormatting.WHITE + element.getCachedName(), (float)(x + 4), (float)(y + 2), 0xFFFFFF);
        String access = element.getAccessLevel().getFormattedName();
        this.f_96547_.m_92883_(poseStack, access, (float)(x + this.mElementWidth - 4 - this.f_96547_.m_92895_(access)), (float)(y + 2), 0xFFFFFF);
    }

    @Override
    public void renderElementTooltip(PoseStack poseStack, NetworkMember element, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        components.add(FluxTranslate.USERNAME.makeComponent().m_130946_(": " + ChatFormatting.AQUA + element.getCachedName()));
        components.add(FluxTranslate.ACCESS.makeComponent().m_130946_(": " + element.getAccessLevel().getFormattedName()));
        this.m_96597_(poseStack, components, mouseX, mouseY);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0) {
            if (mouseX >= (double)(this.f_97735_ + 45) && mouseX < (double)(this.f_97735_ + 75) && mouseY >= (double)(this.f_97736_ + 24) && mouseY < (double)(this.f_97736_ + 32)) {
                this.mSortType = (GuiTabPages.SortType)FluxUtils.cycle((Enum)this.mSortType, (Enum[])GuiTabPages.SortType.values());
                this.sortGrids(this.mSortType);
                this.refreshCurrentPage();
                return true;
            }
            if (!this.getNetwork().isValid()) {
                return this.redirectNavigationPrompt(mouseX, mouseY, mouseButton, EnumNavigationTab.TAB_SELECTION);
            }
        }
        return false;
    }

    @Override
    protected void onResponseAction(int key, int code) {
        super.onResponseAction(key, code);
        if (code == 1) {
            this.switchTab(EnumNavigationTab.TAB_HOME, false);
            return;
        }
        if (key == 8) {
            this.refreshPages(this.getNetwork().getAllMembers());
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.mElements.sort(Comparator.comparing(NetworkMember::getAccessLevel).thenComparing(NetworkMember::getPlayerUUID));
                break;
            }
            case NAME: {
                this.mElements.sort(Comparator.comparing(NetworkMember::getAccessLevel).thenComparing(NetworkMember::getCachedName));
            }
        }
    }
}

