/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.design;

import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.math.Rect;
import icyllis.modernui.view.View;
import javax.annotation.Nonnull;

public class RoundRectDrawable
extends Drawable {
    private final float mRadius = View.dp((float)3.0f);
    private int mColor;

    public RoundRectDrawable() {
        this(-4934476);
    }

    public RoundRectDrawable(int color) {
        this.setColor(color);
    }

    public void setColor(int color) {
        this.mColor = 0xFF000000 | color;
    }

    public void draw(@Nonnull Canvas canvas) {
        Rect b = this.getBounds();
        float inner = this.mRadius * 0.5f;
        Paint paint = Paint.take();
        paint.setStyle(1);
        paint.setStrokeWidth(this.mRadius);
        paint.setColor(this.mColor);
        canvas.drawRoundRect((float)b.left + inner, (float)b.top + inner, (float)b.right - inner, (float)b.bottom - inner, this.mRadius, paint);
    }

    public boolean getPadding(@Nonnull Rect padding) {
        int r = (int)Math.ceil(this.mRadius / 2.0f);
        padding.set(r, r, r, r);
        return true;
    }
}

