/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.phosphophyllite.data.DataLoader;

public class TurbineCoilRegistry {
    private static final HashMap<Block, CoilData> registry = new HashMap();
    private static final DataLoader<TurbineCoilJsonData> dataLoader = new DataLoader(TurbineCoilJsonData.class);

    public static Map<Block, CoilData> getImmutableRegistry() {
        return Collections.unmodifiableMap(registry);
    }

    public static synchronized boolean isBlockAllowed(Block block) {
        return registry.containsKey(block);
    }

    public static synchronized CoilData getCoilData(Block block) {
        return registry.get(block);
    }

    public static void loadRegistry() {
        BiggerReactors.LOGGER.info("Loading turbine coils");
        registry.clear();
        List data = dataLoader.loadAll(new ResourceLocation("biggerreactors:ebest/coils"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " coil data entries");
        for (TurbineCoilJsonData coilData : data) {
            CoilData properties = new CoilData(coilData.efficiency, coilData.bonus, coilData.extractionRate);
            if (coilData.type.equals("tag")) {
                Optional blockTagOptional = Registry.f_122824_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)coilData.location));
                blockTagOptional.ifPresent(holders -> holders.forEach(blockHolder -> {
                    Block element = (Block)blockHolder.m_203334_();
                    registry.put(element, properties);
                    BiggerReactors.LOGGER.debug("Loaded moderator " + element.getRegistryName());
                }));
                continue;
            }
            if (!ForgeRegistries.BLOCKS.containsKey(coilData.location)) continue;
            registry.put((Block)ForgeRegistries.BLOCKS.getValue(coilData.location), properties);
            BiggerReactors.LOGGER.debug("Loaded coil " + coilData.location);
        }
        BiggerReactors.LOGGER.info("Loaded " + registry.size() + " coil entries");
    }

    public static class CoilData {
        public final double efficiency;
        public final double bonus;
        public final double extractionRate;

        public CoilData(double efficiency, double bonus, double extractionRate) {
            this.efficiency = efficiency;
            this.bonus = bonus;
            this.extractionRate = extractionRate;
        }
    }

    private static class TurbineCoilJsonData {
        @DataLoader.Values(value={"tag", "registry"})
        String type;
        ResourceLocation location;
        @DataLoader.Range(value="(0,)")
        double efficiency;
        @DataLoader.Range(value="(0,)")
        double extractionRate;
        @DataLoader.Range(value="[1,)")
        double bonus;

        private TurbineCoilJsonData() {
        }
    }
}

