/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.roguelogix.biggerreactors.multiblocks.turbine.TurbineMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbinePowerTap;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.phosphophyllite.energy.EnergyStorageWrapper;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyStorage;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.registry.RegisterTile;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TurbinePowerTapTile
extends TurbineBaseTile
implements IPhosphophylliteEnergyStorage {
    @RegisterTile(value="turbine_power_tap")
    public static final BlockEntityType.BlockEntitySupplier<TurbinePowerTapTile> SUPPLIER = new RegisterTile.Producer(TurbinePowerTapTile::new);
    private boolean connected = false;
    Direction powerOutputDirection = null;
    private static final EnergyStorage ENERGY_ZERO = new EnergyStorage(0);
    LazyOptional<?> outputOptional = LazyOptional.empty();
    IPhosphophylliteEnergyStorage output;

    public TurbinePowerTapTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.capability(cap, side);
    }

    private void setConnected(boolean newState) {
        if (newState != this.connected) {
            this.connected = newState;
            assert (this.f_58857_ != null);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(TurbinePowerTap.ConnectionState.CONNECTION_STATE_ENUM_PROPERTY, (Comparable)((Object)(this.connected ? TurbinePowerTap.ConnectionState.CONNECTED : TurbinePowerTap.ConnectionState.DISCONNECTED))));
        }
    }

    public long distributePower(long toDistribute, boolean simulate) {
        if (this.outputOptional.isPresent()) {
            return Math.max(0L, this.output.insertEnergy(toDistribute, simulate));
        }
        return 0L;
    }

    public long insertEnergy(long maxInsert, boolean simulate) {
        return 0L;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (maxExtract <= 0L || this.nullableController() == null || ((TurbineMultiblockController)this.controller()).assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            return 0L;
        }
        long toExtract = ((TurbineMultiblockController)this.controller()).simulation().battery().stored();
        toExtract = Math.min(maxExtract, toExtract);
        if (!simulate) {
            toExtract = ((TurbineMultiblockController)this.controller()).simulation().battery().extract(toExtract);
        }
        return toExtract;
    }

    public long energyStored() {
        if (this.nullableController() != null) {
            return Math.max(0L, ((TurbineMultiblockController)this.controller()).simulation().battery().stored());
        }
        return 0L;
    }

    public long maxEnergyStored() {
        if (this.nullableController() != null) {
            return Math.max(0L, ((TurbineMultiblockController)this.controller()).simulation().battery().capacity());
        }
        return 0L;
    }

    public boolean canInsert() {
        return false;
    }

    public boolean canExtract() {
        return true;
    }

    public void updateOutputDirection() {
        if (((TurbineMultiblockController)this.controller()).assemblyState() == MultiblockController.AssemblyState.DISASSEMBLED) {
            this.powerOutputDirection = null;
        } else if (this.f_58858_.m_123341_() == ((TurbineMultiblockController)this.controller()).minCoord().x()) {
            this.powerOutputDirection = Direction.WEST;
        } else if (this.f_58858_.m_123341_() == ((TurbineMultiblockController)this.controller()).maxCoord().x()) {
            this.powerOutputDirection = Direction.EAST;
        } else if (this.f_58858_.m_123342_() == ((TurbineMultiblockController)this.controller()).minCoord().y()) {
            this.powerOutputDirection = Direction.DOWN;
        } else if (this.f_58858_.m_123342_() == ((TurbineMultiblockController)this.controller()).maxCoord().y()) {
            this.powerOutputDirection = Direction.UP;
        } else if (this.f_58858_.m_123343_() == ((TurbineMultiblockController)this.controller()).minCoord().z()) {
            this.powerOutputDirection = Direction.NORTH;
        } else if (this.f_58858_.m_123343_() == ((TurbineMultiblockController)this.controller()).maxCoord().z()) {
            this.powerOutputDirection = Direction.SOUTH;
        }
        this.neighborChanged();
    }

    public void neighborChanged() {
        this.outputOptional = LazyOptional.empty();
        this.output = null;
        if (this.powerOutputDirection == null) {
            this.setConnected(false);
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.powerOutputDirection));
        if (te == null) {
            this.setConnected(false);
            return;
        }
        LazyOptional energyOptional = te.getCapability(CapabilityEnergy.ENERGY, this.powerOutputDirection.m_122424_());
        this.setConnected(energyOptional.isPresent());
        if (this.connected) {
            this.outputOptional = energyOptional;
            this.output = EnergyStorageWrapper.wrap((IEnergyStorage)((IEnergyStorage)energyOptional.orElse((Object)ENERGY_ZERO)));
        }
    }
}

