/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.registries.FluidTransitionRegistry;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;
import net.roguelogix.phosphophyllite.util.HeatBody;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;
import org.apache.commons.lang3.NotImplementedException;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReactorTransitionTank
extends FluidTransitionTank {
    private final IReactorSimulation.ICoolantTank internalTank;

    @Override
    public long transitionedLastTick() {
        return this.internalTank.transitionedLastTick();
    }

    @Override
    public long maxTransitionedLastTick() {
        return this.internalTank.maxTransitionedLastTick();
    }

    @Override
    public double transferWith(HeatBody body, double rfkt) {
        throw new NotImplementedException("");
    }

    @Override
    public double absorbRF(double rf) {
        throw new NotImplementedException("");
    }

    public ReactorTransitionTank(IReactorSimulation.ICoolantTank internalTank) {
        super(false);
        this.internalTank = internalTank;
        this.perSideCapacity = internalTank.perSideCapacity();
        this.inAmount = internalTank.liquidAmount();
        this.outAmount = internalTank.vaporAmount();
    }

    public long perSideCapacity() {
        return this.getTankCapacity(0);
    }

    public long liquidAmount() {
        return this.fluidAmountInTank(0);
    }

    public Fluid liquidType() {
        return this.fluidTypeInTank(0);
    }

    public long vaporAmount() {
        return this.fluidAmountInTank(1);
    }

    public Fluid vaporType() {
        return this.fluidTypeInTank(1);
    }

    public void dumpLiquid() {
        this.dumpTank(0);
    }

    public void dumpVapor() {
        this.dumpTank(1);
    }

    @Override
    public void dumpTank(int tank) {
        super.dumpTank(tank);
        this.pushUpdate();
    }

    private void pushUpdate() {
        this.internalTank.insertLiquid(this.liquidAmount() - this.internalTank.liquidAmount());
        this.internalTank.insertVapor(this.vaporAmount() - this.internalTank.vaporAmount());
    }

    private void pullUpdate() {
        this.inAmount = this.internalTank.liquidAmount();
        this.outAmount = this.internalTank.vaporAmount();
    }

    @Override
    public long fill(@Nonnull Fluid fluid, long amount, boolean simulate, @Nullable FluidTransitionRegistry.FluidTransition transition) {
        long filled = super.fill(fluid, amount, simulate, transition);
        if (!simulate) {
            this.pushUpdate();
        }
        return filled;
    }

    @Override
    public long drain(@Nonnull Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        this.pullUpdate();
        long drained = super.drain(fluid, tag, amount, simulate);
        if (!simulate) {
            this.pushUpdate();
        }
        return drained;
    }

    @Override
    protected void transitionUpdate() {
        ReactorModeratorRegistry.ModeratorProperties airProperties = ReactorModeratorRegistry.blockModeratorProperties(Blocks.f_50016_);
        if (airProperties == null) {
            airProperties = ReactorModeratorRegistry.ModeratorProperties.EMPTY_MODERATOR;
        }
        ReactorModeratorRegistry.ModeratorProperties liquidProperties = airProperties;
        Fluid liquid = this.inFluid;
        if (liquid != null && (liquidProperties = ReactorModeratorRegistry.blockModeratorProperties(liquid.m_76145_().m_76188_().m_60734_())) == null) {
            liquidProperties = airProperties;
        }
        this.internalTank.setTransitionProperties(this.activeTransition);
        this.internalTank.setModeratorProperties(liquidProperties);
    }
}

