/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorAccessPort;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorCoolantPort;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorCoolantPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorCoolantPortState;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.biggerreactors.multiblocks.reactor.util.ReactorTransitionTank;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.fluids.FluidHandlerWrapper;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.fluids.MekanismGasWrappers;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyAttemptedTile;
import net.roguelogix.phosphophyllite.multiblock.IOnAssemblyTile;
import net.roguelogix.phosphophyllite.multiblock.IOnDisassemblyTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorCoolantPortTile
extends ReactorBaseTile
implements IPhosphophylliteFluidHandler,
MenuProvider,
IHasUpdatableState<ReactorCoolantPortState>,
IAssemblyAttemptedTile,
IOnAssemblyTile,
IOnDisassemblyTile {
    @RegisterTile(value="reactor_coolant_port")
    public static final BlockEntityType.BlockEntitySupplier<ReactorCoolantPortTile> SUPPLIER = new RegisterTile.Producer(ReactorCoolantPortTile::new);
    private static final Capability<IGasHandler> GAS_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGasHandler>(){});
    @Nullable
    private ReactorTransitionTank transitionTank;
    private boolean connected = false;
    Direction steamOutputDirection = null;
    LazyOptional<?> handlerOptional = LazyOptional.empty();
    IPhosphophylliteFluidHandler handler = null;
    FluidTank EMPTY_TANK = new FluidTank(0);
    private ReactorAccessPort.PortDirection direction = ReactorAccessPort.PortDirection.INLET;
    public final ReactorCoolantPortState reactorCoolantPortState = new ReactorCoolantPortState(this);

    public ReactorCoolantPortTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        if (cap == GAS_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> MekanismGasWrappers.wrap((IPhosphophylliteFluidHandler)this)).cast();
        }
        return super.capability(cap, side);
    }

    public int tankCount() {
        if (this.transitionTank == null) {
            return 0;
        }
        return this.transitionTank.tankCount();
    }

    public long tankCapacity(int tank) {
        if (this.transitionTank == null) {
            return 0L;
        }
        return this.transitionTank.tankCapacity(tank);
    }

    public Fluid fluidTypeInTank(int tank) {
        if (this.transitionTank == null) {
            return Fluids.f_76191_;
        }
        return this.transitionTank.fluidTypeInTank(tank);
    }

    @Nullable
    public CompoundTag fluidTagInTank(int tank) {
        if (this.transitionTank == null) {
            return null;
        }
        return this.transitionTank.fluidTagInTank(tank);
    }

    public long fluidAmountInTank(int tank) {
        if (this.transitionTank == null) {
            return 0L;
        }
        return this.transitionTank.fluidAmountInTank(tank);
    }

    public boolean fluidValidForTank(int tank, Fluid fluid) {
        if (this.transitionTank == null) {
            return false;
        }
        return this.transitionTank.fluidValidForTank(tank, fluid);
    }

    public long fill(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.transitionTank == null || this.direction != ReactorAccessPort.PortDirection.INLET) {
            return 0L;
        }
        return this.transitionTank.fill(fluid, tag, amount, simulate);
    }

    public long drain(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.transitionTank == null || this.direction == ReactorAccessPort.PortDirection.INLET) {
            return 0L;
        }
        return this.transitionTank.drain(fluid, tag, amount, simulate);
    }

    public long pushFluid() {
        if (!this.connected || this.direction == ReactorAccessPort.PortDirection.INLET) {
            return 0L;
        }
        if (this.handlerOptional.isPresent() && this.transitionTank != null) {
            Fluid fluid = this.transitionTank.vaporType();
            long amount = this.transitionTank.vaporAmount();
            amount = this.transitionTank.drain(fluid, null, amount, true);
            amount = this.handler.fill(fluid, null, amount, false);
            amount = this.transitionTank.drain(fluid, null, amount, false);
            return amount;
        }
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        this.connected = false;
        return 0L;
    }

    public void neighborChanged() {
        LazyOptional gasOptional;
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        if (this.steamOutputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(this.steamOutputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.connected = false;
        LazyOptional fluidOptional = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.steamOutputDirection.m_122424_());
        if (fluidOptional.isPresent()) {
            this.connected = true;
            this.handlerOptional = fluidOptional;
            this.handler = FluidHandlerWrapper.wrap((IFluidHandler)((IFluidHandler)fluidOptional.orElse((Object)this.EMPTY_TANK)));
        } else if (GAS_HANDLER_CAPABILITY != null && (gasOptional = te.getCapability(GAS_HANDLER_CAPABILITY, this.steamOutputDirection.m_122424_())).isPresent()) {
            IGasHandler gasHandler = (IGasHandler)gasOptional.orElse((Object)MekanismGasWrappers.EMPTY_TANK);
            this.connected = true;
            this.handlerOptional = gasOptional;
            this.handler = MekanismGasWrappers.wrap((IGasHandler)gasHandler);
        }
    }

    public void setDirection(ReactorAccessPort.PortDirection direction) {
        this.direction = direction;
        this.m_6596_();
    }

    protected void readNBT(CompoundTag compound) {
        if (compound.m_128441_("direction")) {
            this.direction = ReactorAccessPort.PortDirection.valueOf(compound.m_128461_("direction"));
        }
    }

    protected CompoundTag writeNBT() {
        CompoundTag NBT = new CompoundTag();
        NBT.m_128359_("direction", String.valueOf((Object)this.direction));
        return NBT;
    }

    public void onAssemblyAttempted() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)), 3);
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (requestName.equals("setDirection")) {
            this.setDirection((Integer)requestData != 0 ? ReactorAccessPort.PortDirection.OUTLET : ReactorAccessPort.PortDirection.INLET);
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ReactorAccessPort.PortDirection.PORT_DIRECTION_ENUM_PROPERTY, (Comparable)((Object)this.direction)), 3);
        }
        super.runRequest(requestName, requestData);
    }

    public Component m_5446_() {
        return new TranslatableComponent(ReactorCoolantPort.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ReactorCoolantPortContainer(windowId, this.f_58858_, player);
    }

    public ReactorCoolantPortState getState() {
        this.updateState();
        return this.reactorCoolantPortState;
    }

    public void updateState() {
        this.reactorCoolantPortState.direction = this.direction == ReactorAccessPort.PortDirection.INLET;
    }

    public void onAssembly() {
        this.transitionTank = ((ReactorMultiblockController)this.controller()).coolantTank();
        this.steamOutputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.steamOutputDirection = null;
        this.transitionTank = null;
        this.neighborChanged();
    }
}

