/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.tiles;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.biggerreactors.multiblocks.reactor.ReactorMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.reactor.blocks.ReactorControlRod;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorControlRodState;
import net.roguelogix.biggerreactors.multiblocks.reactor.tiles.ReactorBaseTile;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.registry.RegisterTile;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ReactorControlRodTile
extends ReactorBaseTile
implements MenuProvider,
IHasUpdatableState<ReactorControlRodState> {
    @RegisterTile(value="reactor_control_rod")
    public static final BlockEntityType.BlockEntitySupplier<ReactorControlRodTile> SUPPLIER = new RegisterTile.Producer(ReactorControlRodTile::new);
    public final ReactorControlRodState reactorControlRodState = new ReactorControlRodState(this);
    private double insertion = 0.0;
    private String name = "";

    public ReactorControlRodTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public ReactorControlRodState getState() {
        this.updateState();
        return this.reactorControlRodState;
    }

    public void updateState() {
        this.reactorControlRodState.name = this.name;
        this.reactorControlRodState.insertionLevel = this.insertion;
    }

    public Component m_5446_() {
        return new TranslatableComponent(ReactorControlRod.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ReactorControlRodContainer(windowId, this.f_58858_, player);
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (this.nullableController() == null) {
            return;
        }
        if (requestName.equals("changeInsertionLevel")) {
            Pair dataPair = (Pair)requestData;
            double newLevel = this.insertion + (Double)dataPair.getFirst();
            newLevel = Math.max(0.0, Math.min(100.0, newLevel));
            if (((Boolean)dataPair.getSecond()).booleanValue()) {
                ((ReactorMultiblockController)this.controller()).setAllControlRodLevels(newLevel);
            } else {
                this.insertion = newLevel;
                ((ReactorMultiblockController)this.controller()).updateControlRodLevels();
            }
        }
        if (requestName.equals("setName")) {
            this.setName((String)requestData);
        }
        super.runRequest(requestName, requestData);
    }

    public void setInsertion(double newLevel) {
        if (Double.isNaN(newLevel)) {
            return;
        }
        if (newLevel < 0.0) {
            newLevel = 0.0;
        }
        if (newLevel > 100.0) {
            newLevel = 100.0;
        }
        this.insertion = newLevel;
    }

    public double getInsertion() {
        return this.insertion;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected CompoundTag writeNBT() {
        CompoundTag compound = super.writeNBT();
        compound.m_128347_("insertion", this.insertion);
        compound.m_128359_("name", this.name);
        return compound;
    }

    protected void readNBT(CompoundTag compound) {
        super.readNBT(compound);
        if (compound.m_128441_("insertion")) {
            this.insertion = compound.m_128459_("insertion");
        }
        if (compound.m_128441_("name")) {
            this.name = compound.m_128461_("name");
        }
    }
}

