/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.accellerated.ocl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimulationDescription;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.accellerated.ocl.CLUtil;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.ModeratorCache;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.SimUtil;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.cpu.FullPassReactorSimulation;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL12;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class SingleQueueOpenCL12Simulation
extends FullPassReactorSimulation {
    private boolean dispatchedLastTick = false;
    private final CLUtil clUtil = new CLUtil();
    private final long queue;
    private final int totalRayCount;
    private final int raysPerBatch;
    private final int batches;
    private final long simKernel;
    private final long reductionKernel;
    private final long reactorInfoBuffer;
    private final IntBuffer reactorInfoIB;
    private final FloatBuffer reactorInfoFB;
    private final long moderatorBuffer;
    private final FloatBuffer moderatorFB;
    private final long controlRodInsertionsBuffer;
    private final FloatBuffer controlRodInsertions;
    private final long rodRayInfoBuffer;
    private final FloatBuffer rodRayInfoFB;
    private final long rayResultsBuffer;
    private final FloatBuffer rayResultsFB;
    private final PointerBuffer rayGlobalWorkSize = this.clUtil.allocPointer(3);
    private final PointerBuffer rayLocalWorkSize = this.clUtil.allocPointer(3);
    private final PointerBuffer rayReductionGlobalWorkSize = this.clUtil.allocPointer(3);

    public SingleQueueOpenCL12Simulation(SimulationDescription simulationDescription) {
        super(simulationDescription);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer returnCode = stack.mallocInt(1);
            IntBuffer argIntBuffer = stack.mallocInt(1);
            LongBuffer argLongBuffer = stack.mallocLong(1);
            this.queue = this.clUtil.createCommandQueue(CLUtil.nextDevice(), returnCode);
            this.totalRayCount = SimUtil.rays.size();
            this.raysPerBatch = this.totalRayCount / 8;
            this.batches = this.totalRayCount / this.raysPerBatch;
            long rayBuffer = this.clUtil.createCLBuffer(132L, (long)this.totalRayCount * 8L, returnCode);
            ByteBuffer mappedRayBuffer = CL12.clEnqueueMapBuffer((long)this.queue, (long)rayBuffer, (boolean)true, (long)4L, (long)0L, (long)((long)this.totalRayCount * 2L * 4L), null, null, (IntBuffer)returnCode, null);
            CLUtil.checkReturnCode(returnCode.get(0));
            if (mappedRayBuffer == null) {
                throw new IllegalStateException("Memory map failed");
            }
            IntBuffer mappedRayIntBuffer = mappedRayBuffer.asIntBuffer();
            ArrayList<SimUtil.RayStep> raySteps = new ArrayList<SimUtil.RayStep>();
            for (int i = 0; i < this.totalRayCount; ++i) {
                ArrayList<SimUtil.RayStep> ray = SimUtil.rays.get(i);
                mappedRayIntBuffer.put(i * 2, raySteps.size());
                mappedRayIntBuffer.put(i * 2 + 1, ray.size());
                raySteps.addAll(ray);
            }
            CL12.clEnqueueUnmapMemObject((long)this.queue, (long)rayBuffer, (ByteBuffer)mappedRayBuffer, null, null);
            long rayStepBuffer = this.clUtil.createCLBuffer(132L, (long)raySteps.size() * 16L, returnCode);
            ByteBuffer mappedRayStepBuffer = CL12.clEnqueueMapBuffer((long)this.queue, (long)rayStepBuffer, (boolean)true, (long)4L, (long)0L, (long)((long)raySteps.size() * 4L * 4L), null, null, (IntBuffer)returnCode, null);
            CLUtil.checkReturnCode(returnCode.get(0));
            if (mappedRayStepBuffer == null) {
                throw new IllegalStateException("Memory map failed");
            }
            FloatBuffer mappedRayStepFloatBuffer = mappedRayStepBuffer.asFloatBuffer();
            IntBuffer mappedRayStepIntBuffer = mappedRayStepBuffer.asIntBuffer();
            for (int i = 0; i < raySteps.size(); ++i) {
                SimUtil.RayStep step = (SimUtil.RayStep)raySteps.get(i);
                mappedRayStepFloatBuffer.put(i * 4, (float)step.length);
                mappedRayStepIntBuffer.put(i * 4 + 1, step.offset.x);
                mappedRayStepIntBuffer.put(i * 4 + 2, step.offset.y);
                mappedRayStepIntBuffer.put(i * 4 + 3, step.offset.z);
            }
            CL12.clEnqueueUnmapMemObject((long)this.queue, (long)rayStepBuffer, (ByteBuffer)mappedRayStepBuffer, null, null);
            this.simKernel = this.clUtil.createCLKernel("raySim", returnCode);
            this.reductionKernel = this.clUtil.createCLKernel("rayReduction", returnCode);
            this.reactorInfoBuffer = this.clUtil.createCLBuffer(132L, 36L, returnCode);
            this.reactorInfoIB = this.clUtil.allocInt(9);
            this.reactorInfoFB = MemoryUtil.memFloatBuffer((long)MemoryUtil.memAddress((IntBuffer)this.reactorInfoIB), (int)this.reactorInfoIB.capacity());
            long moderatorIndexBuffer = this.clUtil.createCLBuffer(132L, (long)this.x * (long)this.y * (long)this.z, returnCode);
            this.moderatorBuffer = this.clUtil.createCLBuffer(132L, (long)this.moderatorCaches.size() * 12L, returnCode);
            this.moderatorFB = this.clUtil.allocFloat(this.moderatorCaches.size() * 3);
            long controlRodPositionsBuffer = this.clUtil.createCLBuffer(132L, (long)this.controlRods.length * 2L * 2L, returnCode);
            this.controlRodInsertionsBuffer = this.clUtil.createCLBuffer(132L, (long)this.x * (long)this.z * 4L, returnCode);
            this.controlRodInsertions = this.clUtil.allocFloat(this.x * this.z);
            for (int i = 0; i < this.x * this.z; ++i) {
                this.controlRodInsertions.put(i, -1.0f);
            }
            this.rodRayInfoBuffer = this.clUtil.createCLBuffer(132L, (long)this.controlRods.length * (long)this.y * (long)this.batches * 4L, returnCode);
            this.rodRayInfoFB = this.clUtil.allocFloat(this.controlRods.length * this.y * this.batches);
            long rayResultsIntermediateBuffer = this.clUtil.createCLBuffer(513L, (long)this.controlRods.length * (long)this.y * (long)this.batches * 12L, returnCode);
            this.rayResultsBuffer = this.clUtil.createCLBuffer(258L, (long)this.controlRods.length * 12L, returnCode);
            this.rayResultsFB = this.clUtil.allocFloat((int)((long)this.controlRods.length * 3L));
            ByteBuffer mappedModeratorIndexBuffer = CL12.clEnqueueMapBuffer((long)this.queue, (long)moderatorIndexBuffer, (boolean)true, (long)4L, (long)0L, (long)((long)this.x * (long)this.y * (long)this.z), null, null, (IntBuffer)returnCode, null);
            CLUtil.checkReturnCode(returnCode.get(0));
            if (mappedModeratorIndexBuffer == null) {
                throw new IllegalStateException("Memory map failed");
            }
            for (int i = 0; i < this.x; ++i) {
                for (int j = 0; j < this.z; ++j) {
                    for (int k = 0; k < this.y; ++k) {
                        int moderatorIndexIndex = (i * this.z + j) * this.y + k;
                        mappedModeratorIndexBuffer.put(moderatorIndexIndex, this.getModeratorIndex(moderatorIndexIndex));
                    }
                }
            }
            CL12.clEnqueueUnmapMemObject((long)this.queue, (long)moderatorIndexBuffer, (ByteBuffer)mappedModeratorIndexBuffer, null, null);
            ByteBuffer mappedControlRodPositionBuffer = CL12.clEnqueueMapBuffer((long)this.queue, (long)controlRodPositionsBuffer, (boolean)true, (long)4L, (long)0L, (long)((long)this.controlRods.length * 2L * 2L), null, null, (IntBuffer)returnCode, null);
            CLUtil.checkReturnCode(returnCode.get(0));
            if (mappedControlRodPositionBuffer == null) {
                throw new IllegalStateException("Memory map failed");
            }
            ShortBuffer mappedControlRodPositionSB = mappedControlRodPositionBuffer.asShortBuffer();
            for (int i = 0; i < this.controlRods.length; ++i) {
                mappedControlRodPositionSB.put(i * 2, (short)this.controlRods[i].x);
                mappedControlRodPositionSB.put(i * 2 + 1, (short)this.controlRods[i].z);
            }
            CL12.clEnqueueUnmapMemObject((long)this.queue, (long)controlRodPositionsBuffer, (ByteBuffer)mappedControlRodPositionBuffer, null, null);
            this.rayGlobalWorkSize.put(0, (long)this.controlRods.length);
            this.rayGlobalWorkSize.put(1, (long)this.y);
            this.rayGlobalWorkSize.put(2, (long)this.batches);
            this.rayLocalWorkSize.put(0, 1L);
            this.rayLocalWorkSize.put(1, (long)this.y);
            this.rayLocalWorkSize.put(2, 1L);
            this.rayReductionGlobalWorkSize.put(0, (long)this.controlRods.length);
            argIntBuffer.put(0, 0);
            CL12.clSetKernelArg((long)this.simKernel, (int)0, (IntBuffer)argIntBuffer);
            argIntBuffer.put(0, this.raysPerBatch);
            CL12.clSetKernelArg((long)this.simKernel, (int)1, (IntBuffer)argIntBuffer);
            argLongBuffer.put(0, moderatorIndexBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)2, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, this.moderatorBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)3, (LongBuffer)argLongBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)4, (long)((long)this.moderatorCaches.size() * 12L));
            argIntBuffer.put(0, this.moderatorCaches.size());
            CL12.clSetKernelArg((long)this.simKernel, (int)5, (IntBuffer)argIntBuffer);
            argLongBuffer.put(0, controlRodPositionsBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)6, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, this.controlRodInsertionsBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)7, (LongBuffer)argLongBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)8, (long)((long)(Math.pow(Config.CONFIG.Reactor.IrradiationDistance * 2L + 1L, 2.0) * 4.0)));
            argLongBuffer.put(0, this.rodRayInfoBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)9, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, this.reactorInfoBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)10, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, rayBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)11, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, rayStepBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)12, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, rayResultsIntermediateBuffer);
            CL12.clSetKernelArg((long)this.simKernel, (int)13, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, rayResultsIntermediateBuffer);
            CL12.clSetKernelArg((long)this.reductionKernel, (int)0, (LongBuffer)argLongBuffer);
            argLongBuffer.put(0, this.rayResultsBuffer);
            CL12.clSetKernelArg((long)this.reductionKernel, (int)1, (LongBuffer)argLongBuffer);
            argIntBuffer.put(0, this.y * this.batches);
            CL12.clSetKernelArg((long)this.reductionKernel, (int)2, (IntBuffer)argIntBuffer);
            CL12.clFlush((long)this.queue);
        }
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    protected void startNextRadiate() {
        if (this.fuelTank.fuel() <= 0L) {
            return;
        }
        this.setupIrradiationTick();
        this.fullPassIrradiationRequest.updateCache();
        for (int i = 0; i < this.moderatorCaches.size(); ++i) {
            ModeratorCache cache = (ModeratorCache)this.moderatorCaches.get(i);
            this.moderatorFB.put(i * 3, (float)cache.absorption);
            this.moderatorFB.put(i * 3 + 1, (float)cache.heatEfficiency);
            this.moderatorFB.put(i * 3 + 2, (float)cache.moderation);
        }
        CLUtil.checkReturnCode(CL12.clEnqueueWriteBuffer((long)this.queue, (long)this.moderatorBuffer, (boolean)false, (long)0L, (FloatBuffer)this.moderatorFB, null, null));
        for (SimUtil.ControlRod controlRod : this.controlRods) {
            int linearIndex = controlRod.x * this.z + controlRod.z;
            this.controlRodInsertions.put(linearIndex, (float)(controlRod.insertion * 0.01));
        }
        CLUtil.checkReturnCode(CL12.clEnqueueWriteBuffer((long)this.queue, (long)this.controlRodInsertionsBuffer, (boolean)false, (long)0L, (FloatBuffer)this.controlRodInsertions, null, null));
        for (int i = 0; i < this.controlRods.length; ++i) {
            this.rodRayInfoFB.put(i, (float)this.initialIntensties[i]);
        }
        CLUtil.checkReturnCode(CL12.clEnqueueWriteBuffer((long)this.queue, (long)this.rodRayInfoBuffer, (boolean)false, (long)0L, (FloatBuffer)this.rodRayInfoFB, null, null));
        this.reactorInfoIB.put(0, this.x);
        this.reactorInfoIB.put(1, this.y);
        this.reactorInfoIB.put(2, this.z);
        this.reactorInfoFB.put(3, (float)this.fuelAbsorptionTemperatureCoefficient);
        this.reactorInfoFB.put(4, (float)this.initialHardness);
        this.reactorInfoFB.put(5, (float)Config.CONFIG.Reactor.FEPerRadiationUnit);
        this.reactorInfoFB.put(6, (float)this.FuelAbsorptionCoefficient);
        this.reactorInfoFB.put(7, (float)this.FuelModerationFactor);
        this.reactorInfoFB.put(8, (float)this.fuelHardnessMultiplier);
        CLUtil.checkReturnCode(CL12.clEnqueueWriteBuffer((long)this.queue, (long)this.reactorInfoBuffer, (boolean)false, (long)0L, (FloatBuffer)this.reactorInfoFB, null, null));
        CLUtil.checkReturnCode(CL12.clEnqueueNDRangeKernel((long)this.queue, (long)this.simKernel, (int)3, null, (PointerBuffer)this.rayGlobalWorkSize, (PointerBuffer)this.rayLocalWorkSize, null, null));
        CLUtil.checkReturnCode(CL12.clEnqueueNDRangeKernel((long)this.queue, (long)this.reductionKernel, (int)1, null, (PointerBuffer)this.rayReductionGlobalWorkSize, null, null, null));
        this.dispatchedLastTick = true;
    }

    @Override
    protected double radiate() {
        if (this.dispatchedLastTick) {
            this.dispatchedLastTick = false;
            CLUtil.checkReturnCode(CL12.clEnqueueReadBuffer((long)this.queue, (long)this.rayResultsBuffer, (boolean)true, (long)0L, (FloatBuffer)this.rayResultsFB, null, null));
            this.fuelRFAdded *= Config.CONFIG.Reactor.FEPerRadiationUnit;
            this.collectResults();
            this.fuelRFAdded /= (double)this.controlRods.length;
            this.fuelRadAdded /= (double)this.controlRods.length;
            this.caseRFAdded /= (double)this.controlRods.length;
            if (!Double.isNaN(this.fuelRadAdded)) {
                this.fuelFertility += this.fuelRadAdded;
            }
            if (!Double.isNaN(this.fuelRFAdded)) {
                this.fuelHeat.absorbRF(this.fuelRFAdded);
            }
            if (!Double.isNaN(this.caseRFAdded)) {
                this.stackHeat.absorbRF(this.caseRFAdded);
            }
            this.fuelRFAdded = 0.0;
            this.fuelRadAdded = 0.0;
            this.caseRFAdded = 0.0;
        }
        return this.rawFuelUsage;
    }

    private void collectResults() {
        for (int i = 0; i < this.controlRods.length; ++i) {
            this.fuelRFAdded += (double)this.rayResultsFB.get(i * 3) * this.rayMultiplier;
            this.fuelRadAdded += (double)this.rayResultsFB.get(i * 3 + 1) * this.rayMultiplier;
            this.caseRFAdded += (double)this.rayResultsFB.get(i * 3 + 2) * this.rayMultiplier;
        }
    }
}

