/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.accellerated.ocl.CLUtil;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.accellerated.ocl.SingleQueueOpenCL12Simulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.cpu.FullPassReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.cpu.TimeSlicedReactorSimulation;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;
import net.roguelogix.phosphophyllite.serialization.IPhosphophylliteSerializable;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimulationDescription
implements IPhosphophylliteSerializable {
    int x = 0;
    int y = 0;
    int z = 0;
    @Nonnull
    ReactorModeratorRegistry.IModeratorProperties defaultModeratorProperties = ReactorModeratorRegistry.ModeratorProperties.EMPTY_MODERATOR;
    @Nullable
    ReactorModeratorRegistry.IModeratorProperties[][][] moderatorProperties = null;
    @Nullable
    boolean[][][] manifoldLocations = null;
    int manifoldCount = 0;
    @Nullable
    boolean[][] controlRodLocations = null;
    int controlRodCount = 0;
    boolean passivelyCooled = false;
    double ambientTemperature = 273.15;

    public SimulationDescription() {
    }

    public SimulationDescription(@Nonnull PhosphophylliteCompound compound) {
        this.load(compound);
    }

    public void setSize(int x, int y, int z) {
        if (x <= 0 || y <= 0 || z <= 0) {
            throw new IllegalArgumentException("all sizes must be greater than zero");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        if (this.moderatorProperties == null || this.moderatorProperties.length < x || this.moderatorProperties[0].length < y || this.moderatorProperties[0][0].length < z) {
            this.moderatorProperties = new ReactorModeratorRegistry.IModeratorProperties[x][y][z];
        }
        if (this.manifoldLocations == null || this.manifoldLocations.length < x || this.manifoldLocations[0].length < y || this.manifoldLocations[0][0].length < z) {
            this.manifoldLocations = new boolean[x][y][z];
        }
        if (this.controlRodLocations == null || this.controlRodLocations.length < x || this.controlRodLocations[0].length < z) {
            this.controlRodLocations = new boolean[x][z];
        }
    }

    public void setDefaultIModeratorProperties(ReactorModeratorRegistry.IModeratorProperties properties) {
        this.defaultModeratorProperties = properties;
    }

    public void setModeratorProperties(int x, int y, int z, @Nullable ReactorModeratorRegistry.IModeratorProperties properties) {
        if (this.moderatorProperties == null) {
            if (properties == null) {
                return;
            }
            throw new IllegalStateException("Size must be set before adding moderators");
        }
        if (x < 0 || x >= this.moderatorProperties.length || y < 0 || y >= this.moderatorProperties[0].length || z < 0 || z >= this.moderatorProperties[0][0].length) {
            if (properties == null) {
                return;
            }
            throw new IndexOutOfBoundsException("Attempt to add moderator outside of reactor bounds");
        }
        this.moderatorProperties[x][y][z] = properties;
    }

    public void setControlRod(int x, int z, boolean isControlRod) {
        if (this.controlRodLocations == null) {
            if (!isControlRod) {
                return;
            }
            throw new IllegalStateException("Size must be set before adding control rods");
        }
        if (x < 0 || x >= this.controlRodLocations.length || z < 0 || z >= this.controlRodLocations[0].length) {
            if (!isControlRod) {
                return;
            }
            throw new IndexOutOfBoundsException("Attempt to add control rod outside of reactor bounds");
        }
        if (this.controlRodLocations[x][z] != isControlRod) {
            this.controlRodCount += isControlRod ? 1 : -1;
        }
        this.controlRodLocations[x][z] = isControlRod;
    }

    public void setManifold(int x, int y, int z, boolean manifold) {
        if (this.manifoldLocations == null) {
            if (!manifold) {
                return;
            }
            throw new IllegalStateException("Size must be set before adding manifolds");
        }
        if (x < 0 || x >= this.manifoldLocations.length || y < 0 || y >= this.manifoldLocations[0].length || z < 0 || z >= this.manifoldLocations[0][0].length) {
            if (!manifold) {
                return;
            }
            throw new IndexOutOfBoundsException("Attempt to add manifold outside of reactor bounds");
        }
        if (this.manifoldLocations[x][y][z] != manifold) {
            this.manifoldCount += manifold ? 1 : -1;
        }
        this.manifoldLocations[x][y][z] = manifold;
    }

    public void setPassivelyCooled(boolean passivelyCooled) {
        this.passivelyCooled = passivelyCooled;
    }

    public void setAmbientTemperature(double ambientTemperature) {
        this.ambientTemperature = ambientTemperature;
    }

    public void ensureValid() {
        if (this.controlRodLocations == null) {
            throw new IllegalArgumentException();
        }
        if (this.moderatorProperties == null) {
            throw new IllegalArgumentException();
        }
        if (this.manifoldLocations == null) {
            throw new IllegalArgumentException();
        }
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public ReactorModeratorRegistry.IModeratorProperties defaultModeratorProperties() {
        return this.defaultModeratorProperties;
    }

    public int controlRodCount() {
        return this.controlRodCount;
    }

    public boolean isControlRodAt(int x, int z) {
        assert (this.controlRodLocations != null);
        return this.controlRodLocations[x][z];
    }

    public boolean passivelyCooled() {
        return this.passivelyCooled;
    }

    public int manifoldCount() {
        return this.manifoldCount;
    }

    public ReactorModeratorRegistry.IModeratorProperties moderatorPropertiesAt(int x, int y, int z) {
        assert (this.moderatorProperties != null);
        return this.moderatorProperties[x][y][z];
    }

    public boolean isManifoldAt(int x, int y, int z) {
        assert (this.manifoldLocations != null);
        return this.manifoldLocations[x][y][z];
    }

    public double ambientTemperature() {
        return this.ambientTemperature;
    }

    @Nullable
    public PhosphophylliteCompound save() {
        PhosphophylliteCompound compound = new PhosphophylliteCompound();
        if (this.moderatorProperties == null || this.manifoldLocations == null || this.controlRodLocations == null) {
            return null;
        }
        ArrayList<ReactorModeratorRegistry.IModeratorProperties> moderatorProperties = new ArrayList<ReactorModeratorRegistry.IModeratorProperties>();
        ArrayList moderatorIndexes = new ArrayList();
        ArrayList manifoldLocations = new ArrayList();
        ArrayList controlRodLocations = new ArrayList();
        for (int i = 0; i < this.x; ++i) {
            int j;
            ArrayList moderatorIndexesX = new ArrayList();
            ArrayList manifoldLocationsX = new ArrayList();
            ArrayList<Boolean> controlRodLocationsX = new ArrayList<Boolean>();
            for (j = 0; j < this.y; ++j) {
                ArrayList<Integer> moderatorIndexesXY = new ArrayList<Integer>();
                ArrayList<Boolean> manifoldLocationsXY = new ArrayList<Boolean>();
                for (int k = 0; k < this.z; ++k) {
                    ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[i][j][k];
                    if (properties == null) {
                        moderatorIndexesXY.add(-1);
                    } else {
                        int index = moderatorProperties.indexOf(properties);
                        if (index == -1) {
                            index = moderatorProperties.size();
                            moderatorProperties.add(properties);
                        }
                        moderatorIndexesXY.add(index);
                    }
                    manifoldLocationsXY.add(this.manifoldLocations[i][j][k]);
                }
                moderatorIndexesX.add(moderatorIndexesXY);
                manifoldLocationsX.add(manifoldLocationsXY);
            }
            for (j = 0; j < this.z; ++j) {
                controlRodLocationsX.add(this.controlRodLocations[i][j]);
            }
            moderatorIndexes.add(moderatorIndexesX);
            manifoldLocations.add(manifoldLocationsX);
            controlRodLocations.add(controlRodLocationsX);
        }
        compound.put("x", this.x);
        compound.put("y", this.y);
        compound.put("z", this.z);
        compound.put("moderatorProperties", moderatorProperties);
        compound.put("moderatorIndices", moderatorIndexes);
        compound.put("manifoldLocations", manifoldLocations);
        compound.put("controlRodLocations", controlRodLocations);
        compound.put("defaultModeratorProperties", this.defaultModeratorProperties.toROBNMap());
        compound.put("passivelyCooled", this.passivelyCooled);
        compound.put("ambientTemperature", this.ambientTemperature);
        return compound;
    }

    public void load(@Nonnull PhosphophylliteCompound compound) {
        Number num;
        Object v;
        Object object;
        this.setSize(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
        ArrayList<ReactorModeratorRegistry.ModeratorProperties> moderatorProperties = new ArrayList<ReactorModeratorRegistry.ModeratorProperties>();
        List moderatorROBN = compound.getList("moderatorProperties");
        for (Object o : moderatorROBN) {
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            Map map = (Map)o;
            double absorption = 0.0;
            Object v2 = map.get("absorption");
            if (v2 instanceof Number) {
                Number num2 = (Number)v2;
                absorption = num2.doubleValue();
            }
            double heatEfficiency = 0.0;
            object = map.get("heatEfficiency");
            if (object instanceof Number) {
                Number num3 = (Number)object;
                heatEfficiency = num3.doubleValue();
            }
            double moderation = 1.0;
            v = map.get("moderation");
            if (v instanceof Number) {
                Number num4 = (Number)v;
                moderation = num4.doubleValue();
            }
            double heatConductivity = 0.0;
            Object v3 = map.get("heatConductivity");
            if (v3 instanceof Number) {
                num = (Number)v3;
                heatConductivity = num.doubleValue();
            }
            moderatorProperties.add(new ReactorModeratorRegistry.ModeratorProperties(absorption, heatEfficiency, moderation, heatConductivity));
        }
        List moderatorIndices = compound.getList("moderatorIndices");
        List manifoldLocations = compound.getList("manifoldLocations");
        List controlRodLocations = compound.getList("controlRodLocations");
        if (moderatorIndices.size() != this.x || manifoldLocations.size() != this.x || controlRodLocations.size() != this.x) {
            throw new IllegalArgumentException("Malformed Binary");
        }
        for (int i = 0; i < this.x; ++i) {
            int j;
            Object e = moderatorIndices.get(i);
            if (!(e instanceof List)) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            List moderatorIndicesX = (List)e;
            Object heatEfficiency = manifoldLocations.get(i);
            if (!(heatEfficiency instanceof List)) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            List manifoldLocationsX = (List)heatEfficiency;
            Object e2 = controlRodLocations.get(i);
            if (!(e2 instanceof List)) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            List controlRodLocationsX = (List)e2;
            if (moderatorIndicesX.size() != this.y || manifoldLocationsX.size() != this.y || controlRodLocations.size() != this.z) {
                throw new IllegalArgumentException("Malformed Binary");
            }
            for (j = 0; j < this.y; ++j) {
                object = moderatorIndicesX.get(j);
                if (!(object instanceof List)) {
                    throw new IllegalArgumentException("Malformed Binary");
                }
                List moderatorIndicesXY = (List)object;
                Object heatConductivity = manifoldLocationsX.get(j);
                if (!(heatConductivity instanceof List)) {
                    throw new IllegalArgumentException("Malformed Binary");
                }
                List manifoldLocationsXY = (List)heatConductivity;
                if (moderatorIndicesXY.size() != this.z || manifoldLocationsXY.size() != this.z) {
                    throw new IllegalArgumentException("Malformed Binary");
                }
                for (int k = 0; k < this.z; ++k) {
                    num = moderatorIndicesXY.get(k);
                    if (!(num instanceof Number)) {
                        throw new IllegalArgumentException("Malformed Binary");
                    }
                    Number moderatorIndex = num;
                    Object e3 = manifoldLocationsXY.get(k);
                    if (!(e3 instanceof Boolean)) {
                        throw new IllegalArgumentException("Malformed Binary");
                    }
                    Boolean isManifold = (Boolean)e3;
                    int index = moderatorIndex.intValue();
                    this.setModeratorProperties(i, j, k, index != -1 ? (ReactorModeratorRegistry.IModeratorProperties)moderatorProperties.get(index) : null);
                    this.setManifold(i, j, k, isManifold);
                }
            }
            for (j = 0; j < this.z; ++j) {
                object = controlRodLocationsX.get(j);
                if (!(object instanceof Boolean)) {
                    throw new IllegalArgumentException("Malformed Binary");
                }
                Boolean isControlRod = (Boolean)object;
                this.setControlRod(i, j, isControlRod);
            }
        }
        Map map = compound.getMap("defaultModeratorProperties");
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Malformed Binary");
        }
        double absorption = 0.0;
        Object v4 = map.get("absorption");
        if (v4 instanceof Number) {
            Number num5 = (Number)v4;
            absorption = num5.doubleValue();
        }
        double heatEfficiency = 0.0;
        object = map.get("heatEfficiency");
        if (object instanceof Number) {
            Number num6 = (Number)object;
            heatEfficiency = num6.doubleValue();
        }
        double moderation = 1.0;
        v = map.get("moderation");
        if (v instanceof Number) {
            Number num7 = (Number)v;
            moderation = num7.doubleValue();
        }
        double heatConductivity = 0.0;
        Object v5 = map.get("heatConductivity");
        if (v5 instanceof Number) {
            num = (Number)v5;
            heatConductivity = num.doubleValue();
        }
        this.setDefaultIModeratorProperties(new ReactorModeratorRegistry.ModeratorProperties(absorption, heatEfficiency, moderation, heatConductivity));
        this.setPassivelyCooled(compound.getBoolean("passivelyCooled"));
        this.setAmbientTemperature(compound.getDouble("ambientTemperature"));
    }

    public record Builder(boolean experimental, boolean fullPass, boolean allowOffThread, boolean allowMultiThread, boolean allowAccelerated) {
        public IReactorSimulation build(SimulationDescription description) {
            description.ensureValid();
            if (this.experimental) {
                return new SingleQueueOpenCL12Simulation(description);
            }
            if (!this.fullPass) {
                return new TimeSlicedReactorSimulation(description);
            }
            int rodMultiple = description.controlRodCount / Config.CONFIG.Reactor.ModeSpecific.ControlRodBatchSize;
            if (this.allowAccelerated && rodMultiple >= 16 && CLUtil.available) {
                return new SingleQueueOpenCL12Simulation(description);
            }
            if (this.allowMultiThread && rodMultiple >= 2) {
                return new FullPassReactorSimulation.MultiThreaded(description, false);
            }
            if (this.allowOffThread) {
                return new FullPassReactorSimulation.MultiThreaded(description, true);
            }
            return new FullPassReactorSimulation(description);
        }
    }
}

