/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorAccessPortContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorAccessPortState;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class ReactorAccessPortScreen
extends PhosphophylliteScreen<ReactorAccessPortContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_access_port.png");
    private ReactorAccessPortState reactorAccessPortState = (ReactorAccessPortState)((ReactorAccessPortContainer)this.m_6262_()).getGuiPacket();

    public ReactorAccessPortScreen(ReactorAccessPortContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 142, 72);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2;
        this.initControls();
    }

    public void initControls() {
        Biselector<ReactorAccessPortContainer> directionToggle = new Biselector<ReactorAccessPortContainer>(this, 8, 18, (Component)new TranslatableComponent("screen.biggerreactors.reactor_access_port.direction_toggle.tooltip"), () -> this.reactorAccessPortState.direction ? 0 : 1, SelectorColors.YELLOW, SelectorColors.BLUE);
        directionToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorAccessPortContainer)this.m_6262_()).executeRequest("setDirection", directionToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        this.addScreenElement((AbstractElement)directionToggle);
        Biselector<ReactorAccessPortContainer> fuelModeToggle = new Biselector<ReactorAccessPortContainer>(this, 8, 34, (Component)new TranslatableComponent("screen.biggerreactors.reactor_access_port.fuel_mode_toggle.tooltip"), () -> this.reactorAccessPortState.fuelMode ? 1 : 0, SelectorColors.CYAN, SelectorColors.YELLOW);
        fuelModeToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorAccessPortContainer)this.m_6262_()).executeRequest("setFuelMode", fuelModeToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        fuelModeToggle.onTick = () -> {
            fuelModeToggle.actionEnable = directionToggle.getState() != 0;
        };
        this.addScreenElement((AbstractElement)fuelModeToggle);
        InteractiveElement manualEjectButton = new InteractiveElement((PhosphophylliteScreen)this, 8, 50, 15, 15, 226, 0, (Component)new TranslatableComponent("screen.biggerreactors.reactor_access_port.manual_eject.tooltip"));
        manualEjectButton.onMouseReleased = (mX, mY, btn) -> {
            if (manualEjectButton.m_5953_(mX, mY)) {
                ((ReactorAccessPortContainer)this.m_6262_()).executeRequest("ejectWaste", true);
                manualEjectButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        manualEjectButton.onRender = (mS, mX, mY) -> {
            if (manualEjectButton.m_5953_((double)mX, (double)mY)) {
                manualEjectButton.blit(mS, 241, 0);
            } else {
                manualEjectButton.blit(mS, 226, 0);
            }
        };
        this.addScreenElement((AbstractElement)manualEjectButton);
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.reactorAccessPortState.direction) {
            this.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_access_port.direction_toggle.input").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 22), 0x404040);
        } else {
            this.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_access_port.direction_toggle.output").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 22), 0x404040);
        }
        if (!this.reactorAccessPortState.direction) {
            if (this.reactorAccessPortState.fuelMode) {
                this.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_access_port.fuel_mode_toggle.fuel").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 38), 0x404040);
            } else {
                this.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_access_port.fuel_mode_toggle.waste").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 38), 0x404040);
            }
        } else {
            this.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_access_port.fuel_mode_toggle.nope").getString(), (float)(this.getGuiLeft() + 42), (float)(this.getGuiTop() + 38), 0x404040);
        }
        this.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_access_port.manual_eject").getString(), (float)(this.getGuiLeft() + 26), (float)(this.getGuiTop() + 54), 0x404040);
    }
}

