/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.client.Biselector;
import net.roguelogix.biggerreactors.client.SelectorColors;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.ActiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.PassiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class CommonReactorTerminalScreen
extends PhosphophylliteScreen<ReactorTerminalContainer> {
    private final ReactorState initialState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();

    public CommonReactorTerminalScreen(ReactorTerminalContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal"), RenderHelper.getBlankTextureResource(), 176, 152);
    }

    public void m_7856_() {
        if (this.initialState.reactorType == ReactorType.ACTIVE) {
            this.getMinecraft().m_91152_((Screen)new ActiveReactorTerminalScreen((ReactorTerminalContainer)this.f_97732_, this.inventory, this.f_96539_));
        } else {
            this.getMinecraft().m_91152_((Screen)new PassiveReactorTerminalScreen((ReactorTerminalContainer)this.f_97732_, this.inventory, this.f_96539_));
        }
    }

    public static void initTooltips(@Nonnull PhosphophylliteScreen<ReactorTerminalContainer> screen, ReactorState reactorState) {
        screen.addScreenElement((AbstractElement)new TooltipElement(screen, 8, 19, 16, 16, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.temperature.tooltip")));
        TooltipElement temperatureReadoutTooltip = new TooltipElement(screen, 26, 19, 53, 16, TextComponent.f_131282_);
        temperatureReadoutTooltip.onTick = () -> {
            temperatureReadoutTooltip.tooltip = new TextComponent(String.format("%.3f K", reactorState.fuelHeatStored));
        };
        screen.addScreenElement((AbstractElement)temperatureReadoutTooltip);
        screen.addScreenElement((AbstractElement)new TooltipElement(screen, 8, 57, 16, 16, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.fuel_usage_rate.tooltip")));
        TooltipElement fuelConsumptionReadoutTooltip = new TooltipElement(screen, 26, 57, 53, 16, TextComponent.f_131282_);
        fuelConsumptionReadoutTooltip.onTick = () -> {
            fuelConsumptionReadoutTooltip.tooltip = new TextComponent(String.format("%.3f mB/t", reactorState.fuelUsageRate));
        };
        screen.addScreenElement((AbstractElement)fuelConsumptionReadoutTooltip);
        screen.addScreenElement((AbstractElement)new TooltipElement(screen, 8, 76, 16, 16, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.reactivity_rate.tooltip")));
        TooltipElement reactivityRateTooltip = new TooltipElement(screen, 26, 76, 53, 16, TextComponent.f_131282_);
        reactivityRateTooltip.onTick = () -> {
            reactivityRateTooltip.tooltip = new TextComponent(String.format("%.1f%%", reactorState.reactivityRate * 100.0));
        };
        screen.addScreenElement((AbstractElement)reactivityRateTooltip);
        screen.addScreenElement((AbstractElement)new TooltipElement(screen, 86, 6, 16, 16, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.fuel_mix.tooltip")));
        screen.addScreenElement((AbstractElement)new TooltipElement(screen, 108, 6, 16, 16, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.case_heat.tooltip")));
        screen.addScreenElement((AbstractElement)new TooltipElement(screen, 130, 6, 16, 16, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.fuel_heat.tooltip")));
    }

    public static void initControls(@Nonnull PhosphophylliteScreen<ReactorTerminalContainer> screen, ReactorState reactorState) {
        Biselector<ReactorTerminalContainer> activityToggle = new Biselector<ReactorTerminalContainer>(screen, 8, 98, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.activity_toggle.tooltip"), () -> reactorState.reactorActivity.toInt(), SelectorColors.RED, SelectorColors.GREEN);
        activityToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorTerminalContainer)screen.m_6262_()).executeRequest("setActive", activityToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        screen.addScreenElement(activityToggle);
        Biselector<ReactorTerminalContainer> autoEjectToggle = new Biselector<ReactorTerminalContainer>(screen, 8, 114, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.tooltip"), () -> reactorState.doAutoEject ? 1 : 0, SelectorColors.RED, SelectorColors.CYAN);
        autoEjectToggle.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorTerminalContainer)screen.m_6262_()).executeRequest("setAutoEject", autoEjectToggle.getState() == 0 ? 1 : 0);
            return true;
        };
        screen.addScreenElement(autoEjectToggle);
        InteractiveElement manualEjectButton = new InteractiveElement(screen, 8, 130, 15, 15, 226, 0, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.manual_eject.tooltip"));
        manualEjectButton.onMouseReleased = (mX, mY, btn) -> {
            if (manualEjectButton.m_5953_(mX, mY)) {
                Minecraft.m_91087_().f_91074_.m_108739_("No effect. This button will be removed in the future.");
                Minecraft.m_91087_().f_91074_.m_108739_("Use the access ports to eject waste!");
                manualEjectButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        manualEjectButton.onRender = (mS, mX, mY) -> {
            if (manualEjectButton.m_5953_((double)mX, (double)mY)) {
                manualEjectButton.blit(mS, 241, 0);
            } else {
                manualEjectButton.blit(mS, 226, 0);
            }
        };
    }

    public static void initGauges(@Nonnull PhosphophylliteScreen<ReactorTerminalContainer> screen, ReactorState reactorState) {
        RenderedElement fuelMixGauge = new RenderedElement(screen, 85, 25, 18, 64, 0, 152, TextComponent.f_131282_);
        fuelMixGauge.onRender = (mS, mX, mY) -> CommonReactorTerminalScreen.renderFuelMixGauge(mS, (RenderedElement<ReactorTerminalContainer>)fuelMixGauge, reactorState.wasteStored, reactorState.fuelStored, reactorState.fuelCapacity);
        screen.addScreenElement((AbstractElement)fuelMixGauge);
        RenderedElement caseHeatGauge = new RenderedElement(screen, 107, 25, 18, 64, 0, 152, TextComponent.f_131282_);
        caseHeatGauge.onRender = (mS, mX, mY) -> CommonReactorTerminalScreen.renderHeatGauge(mS, (RenderedElement<ReactorTerminalContainer>)caseHeatGauge, reactorState.caseHeatStored, Config.CONFIG.Reactor.GUI.HeatDisplayMax);
        screen.addScreenElement((AbstractElement)caseHeatGauge);
        RenderedElement fuelHeatGauge = new RenderedElement(screen, 129, 25, 18, 64, 0, 152, TextComponent.f_131282_);
        fuelHeatGauge.onRender = (mS, mX, mY) -> CommonReactorTerminalScreen.renderHeatGauge(mS, (RenderedElement<ReactorTerminalContainer>)fuelHeatGauge, reactorState.fuelHeatStored, Config.CONFIG.Reactor.GUI.HeatDisplayMax);
        screen.addScreenElement((AbstractElement)fuelHeatGauge);
    }

    public static void initSymbols(@Nonnull PhosphophylliteScreen<ReactorTerminalContainer> screen, ReactorState reactorState) {
    }

    public static void renderHeatGauge(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<ReactorTerminalContainer> symbol, double heatStored, double heatCapacity) {
        if (heatStored > 0.0 && heatCapacity > 0.0) {
            int renderSize = (int)((double)symbol.height * heatStored / heatCapacity);
            symbol.blit(poseStack, symbol.u + 72, symbol.v);
            symbol.blit(poseStack, symbol.width, symbol.height - renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(poseStack);
        symbol.tooltip = new TextComponent(String.format("%.1f/%.1f K", heatStored, heatCapacity));
    }

    public static void renderFuelMixGauge(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<ReactorTerminalContainer> symbol, double wasteStored, double fuelStored, double fuelCapacity) {
        if ((wasteStored > 0.0 || fuelStored > 0.0) && fuelCapacity > 0.0) {
            int wasteRenderSize = (int)((double)symbol.height * wasteStored / fuelCapacity);
            int fuelRenderSize = (int)((double)symbol.height * fuelStored / fuelCapacity);
            symbol.blit(poseStack, symbol.u + 54, symbol.v);
            symbol.blit(poseStack, symbol.width, symbol.height - wasteRenderSize, symbol.u + 36, symbol.v);
            symbol.blit(poseStack, symbol.width, symbol.height - (wasteRenderSize + fuelRenderSize), symbol.u + 18, symbol.v);
        }
        symbol.blit(poseStack);
        symbol.tooltip = new TextComponent(String.format(new TranslatableComponent("screen.biggerreactors.reactor_terminal.fuel_mix_gauge.tooltip").getString(), RenderHelper.formatValue((double)((fuelStored + wasteStored) / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)(fuelCapacity / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)(fuelStored / 1000.0), (String)"B", (boolean)true), RenderHelper.formatValue((double)(wasteStored / 1000.0), (String)"B", (boolean)true)));
    }

    public static void renderStatusText(@Nonnull PoseStack poseStack, @Nonnull PhosphophylliteScreen<ReactorTerminalContainer> screen, ReactorActivity reactorActivity, boolean doAutoEject, double heatStored, double fuelUsageRate, double reactivityRate) {
        screen.getFont().m_92883_(poseStack, String.format("%.0f K", heatStored), (float)(screen.getGuiLeft() + 27), (float)(screen.getGuiTop() + 23), 0x404040);
        screen.getFont().m_92883_(poseStack, RenderHelper.formatValue((double)(fuelUsageRate / 1000.0), (int)3, (String)"B/t", (boolean)true), (float)(screen.getGuiLeft() + 27), (float)(screen.getGuiTop() + 61), 0x404040);
        screen.getFont().m_92883_(poseStack, String.format("%.1f%%", reactivityRate * 100.0), (float)(screen.getGuiLeft() + 27), (float)(screen.getGuiTop() + 80), 0x404040);
        if (reactorActivity == ReactorActivity.ACTIVE) {
            screen.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_terminal.activity_toggle.online").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 102), 0x404040);
        } else {
            screen.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_terminal.activity_toggle.offline").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 102), 0x404040);
        }
        if (doAutoEject) {
            screen.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.enabled").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 118), 0x404040);
        } else {
            screen.getFont().m_92883_(poseStack, new TranslatableComponent("screen.biggerreactors.reactor_terminal.auto_eject_toggle.disabled").getString(), (float)(screen.getGuiLeft() + 42), (float)(screen.getGuiTop() + 118), 0x404040);
        }
    }
}

