/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.CommonReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.client.PassiveReactorTerminalScreen;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorActivity;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorState;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorType;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class ActiveReactorTerminalScreen
extends PhosphophylliteScreen<ReactorTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_terminal_active.png");
    private ReactorState reactorState;
    private final int screenWorkTimeTotal = 400;
    private int screenWorkTime = 0;
    private Fluid coolantFluid = Fluids.f_76191_;
    private Fluid exhaustFluid = Fluids.f_76191_;

    public ActiveReactorTerminalScreen(ReactorTerminalContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 198, 152);
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();
        this.coolantFluid = (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(this.reactorState.coolantResourceLocation));
        this.exhaustFluid = (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(this.reactorState.exhaustResourceLocation));
    }

    public void m_7856_() {
        super.m_7856_();
        CommonReactorTerminalScreen.initTooltips(this, this.reactorState);
        this.initTooltips();
        CommonReactorTerminalScreen.initControls(this, this.reactorState);
        CommonReactorTerminalScreen.initGauges(this, this.reactorState);
        this.initGauges();
        CommonReactorTerminalScreen.initSymbols(this, this.reactorState);
        this.initSymbols();
    }

    private void initTooltips() {
        TooltipElement generationRateReadoutTooltip = new TooltipElement((PhosphophylliteScreen)this, 26, 38, 53, 16, TextComponent.f_131282_);
        generationRateReadoutTooltip.onTick = () -> {
            generationRateReadoutTooltip.tooltip = new TextComponent(String.format("%.3f mB/t", this.reactorState.reactorOutputRate));
        };
        this.addScreenElement((AbstractElement)generationRateReadoutTooltip);
    }

    private void initGauges() {
        RenderedElement coolantIntakeTank = new RenderedElement((PhosphophylliteScreen)this, 151, 25, 18, 64, 0, 152, TextComponent.f_131282_);
        coolantIntakeTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, coolantIntakeTank, this.reactorState.coolantStored, this.reactorState.coolantCapacity, this.coolantFluid);
        this.addScreenElement((AbstractElement)coolantIntakeTank);
        RenderedElement hotExhaustTank = new RenderedElement((PhosphophylliteScreen)this, 173, 25, 18, 64, 0, 152, TextComponent.f_131282_);
        hotExhaustTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, hotExhaustTank, this.reactorState.exhaustStored, this.reactorState.exhaustCapacity, this.exhaustFluid);
        this.addScreenElement((AbstractElement)hotExhaustTank);
        RenderedElement progressBar = new RenderedElement((PhosphophylliteScreen)this, 173, 90, 18, 26, 90, 152, null);
        progressBar.onRender = (mS, mX, mY) -> {
            if (this.reactorState.coolantStored > 0L) {
                ActiveReactorTerminalScreen.renderProgressBar(mS, (RenderedElement<ReactorTerminalContainer>)progressBar, this.reactorState.reactorActivity, this.screenWorkTime++, 400, this.coolantFluid);
                if (this.screenWorkTime >= 400) {
                    this.screenWorkTime = 0;
                }
            }
        };
        this.addScreenElement((AbstractElement)progressBar);
    }

    private void initSymbols() {
        RenderedElement coolantIntakeTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 152, 6, 16, 16, 174, 152, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.coolant_intake_tank.tooltip"));
        coolantIntakeTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((PoseStack)mS, (int)coolantIntakeTankSymbol.x, (int)coolantIntakeTankSymbol.y, (int)this.m_93252_(), (int)coolantIntakeTankSymbol.width, (int)coolantIntakeTankSymbol.height, (int)coolantIntakeTankSymbol.u, (int)coolantIntakeTankSymbol.v, (Fluid)this.coolantFluid);
        this.addScreenElement((AbstractElement)coolantIntakeTankSymbol);
        RenderedElement hotExhaustTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 174, 6, 16, 16, 158, 152, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.exhaust_tank.tooltip"));
        hotExhaustTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((PoseStack)mS, (int)hotExhaustTankSymbol.x, (int)hotExhaustTankSymbol.y, (int)this.m_93252_(), (int)hotExhaustTankSymbol.width, (int)hotExhaustTankSymbol.height, (int)hotExhaustTankSymbol.u, (int)hotExhaustTankSymbol.v, (Fluid)this.exhaustFluid);
        this.addScreenElement((AbstractElement)hotExhaustTankSymbol);
        RenderedElement exhaustGenerationRateSymbol = new RenderedElement((PhosphophylliteScreen)this, 8, 38, 16, 16, 142, 152, (Component)new TranslatableComponent("screen.biggerreactors.reactor_terminal.exhaust_generation_rate.tooltip"));
        exhaustGenerationRateSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((PoseStack)mS, (int)exhaustGenerationRateSymbol.x, (int)exhaustGenerationRateSymbol.y, (int)this.m_93252_(), (int)exhaustGenerationRateSymbol.width, (int)exhaustGenerationRateSymbol.height, (int)exhaustGenerationRateSymbol.u, (int)exhaustGenerationRateSymbol.v, (Fluid)this.exhaustFluid);
        this.addScreenElement((AbstractElement)exhaustGenerationRateSymbol);
    }

    public void m_181908_() {
        this.reactorState = (ReactorState)((ReactorTerminalContainer)this.m_6262_()).getGuiPacket();
        super.m_181908_();
        if (this.reactorState.reactorType != ReactorType.ACTIVE) {
            this.getMinecraft().m_91152_((Screen)new PassiveReactorTerminalScreen((ReactorTerminalContainer)this.f_97732_, this.inventory, this.f_96539_));
        }
        if (!this.reactorState.coolantResourceLocation.equals(Objects.requireNonNull(this.coolantFluid.getRegistryName()).toString())) {
            this.coolantFluid = (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(this.reactorState.coolantResourceLocation));
        }
        if (!this.reactorState.exhaustResourceLocation.equals(Objects.requireNonNull(this.exhaustFluid.getRegistryName()).toString())) {
            this.exhaustFluid = (Fluid)Registry.f_122822_.m_7745_(new ResourceLocation(this.reactorState.exhaustResourceLocation));
        }
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        CommonReactorTerminalScreen.renderStatusText(poseStack, this, this.reactorState.reactorActivity, this.reactorState.doAutoEject, this.reactorState.fuelHeatStored, this.reactorState.fuelUsageRate, this.reactorState.reactivityRate);
        this.getFont().m_92883_(poseStack, RenderHelper.formatValue((double)(this.reactorState.reactorOutputRate / 1000.0), (String)"B/t"), (float)(this.getGuiLeft() + 27), (float)(this.getGuiTop() + 42), 0x404040);
    }

    private static void renderProgressBar(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<ReactorTerminalContainer> symbol, ReactorActivity reactorActivity, int workTime, int workTimeTotal, Fluid coolant) {
        if (reactorActivity != ReactorActivity.ACTIVE) {
            workTime = 0;
        }
        if (workTime > 0 && workTimeTotal > 0) {
            int renderSize = symbol.height * workTime / workTimeTotal;
            symbol.blit(poseStack, symbol.u + 18, symbol.v);
            symbol.blit(poseStack, symbol.width, symbol.height - renderSize, symbol.u, symbol.v);
        }
        RenderHelper.drawMaskedFluid((PoseStack)poseStack, (int)(symbol.x + 1), (int)(symbol.y + 26), (int)0, (int)16, (int)16, (int)(symbol.u + 36), (int)symbol.v, (Fluid)coolant);
    }
}

