/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.deps;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.HeatExchangerMultiblockController;
import net.roguelogix.biggerreactors.util.FluidTransitionTank;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.util.HeatBody;

public class HeatExchangerPeripheral
implements IPeripheral {
    final Supplier<HeatExchangerMultiblockController> rawControllerSupplier;
    final LamdbaExceptionUtils.Supplier_WithExceptions<HeatExchangerMultiblockController, LuaException> controllerSupplier;
    final LamdbaExceptionUtils.Supplier_WithExceptions<Lock, LuaException> lockSupplier;
    final Channel condenser;
    final Channel evaporator;
    final InternalEnvironment internalEnvironment;

    public static LazyOptional<Object> create(@Nonnull Supplier<HeatExchangerMultiblockController> controllerSupplier) {
        return LazyOptional.of(() -> new HeatExchangerPeripheral(controllerSupplier));
    }

    public HeatExchangerPeripheral(Supplier<HeatExchangerMultiblockController> rawControllerSupplier) {
        this.rawControllerSupplier = rawControllerSupplier;
        this.controllerSupplier = this::getController;
        this.lockSupplier = () -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).locks.readLock();
        this.condenser = new Channel((LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).condenserHeatBody), (LamdbaExceptionUtils.Supplier_WithExceptions<FluidTransitionTank, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).condenserTank), (LamdbaExceptionUtils.Supplier_WithExceptions<Integer, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).condenserChannels.size()), this.lockSupplier);
        this.evaporator = new Channel((LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).evaporatorHeatBody), (LamdbaExceptionUtils.Supplier_WithExceptions<FluidTransitionTank, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).evaporatorTank), (LamdbaExceptionUtils.Supplier_WithExceptions<Integer, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).evaporatorChannels.size()), this.lockSupplier);
        this.internalEnvironment = new InternalEnvironment((LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException>)((LamdbaExceptionUtils.Supplier_WithExceptions)() -> ((HeatExchangerMultiblockController)((Object)((Object)this.controllerSupplier.get()))).airHeatBody));
    }

    @LuaFunction
    public String apiVersion() {
        return BiggerReactors.modVersion();
    }

    @LuaFunction
    public boolean connected() {
        HeatExchangerMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null) {
            return false;
        }
        return controller.assemblyState() == MultiblockController.AssemblyState.ASSEMBLED;
    }

    @Nonnull
    private HeatExchangerMultiblockController getController() throws LuaException {
        HeatExchangerMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null || controller.assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            throw new LuaException("Invalid multiblock controller");
        }
        return controller;
    }

    @LuaFunction
    public Channel condenser() {
        return this.condenser;
    }

    @LuaFunction
    public Channel evaporator() {
        return this.evaporator;
    }

    @LuaFunction
    public InternalEnvironment internalEnvironment() {
        return this.internalEnvironment;
    }

    @LuaFunction
    public double ambientTemperature() throws LuaException {
        return ((HeatExchangerMultiblockController)((Object)this.controllerSupplier.get())).ambientHeatBody.temperature();
    }

    @LuaFunction
    public double ambientInternalRFKT() throws LuaException {
        return ((HeatExchangerMultiblockController)((Object)this.controllerSupplier.get())).airAmbientRFKT;
    }

    @LuaFunction
    public double condenserInternalRFKT() throws LuaException {
        return ((HeatExchangerMultiblockController)((Object)this.controllerSupplier.get())).condenserAirRFKT;
    }

    @LuaFunction
    public double evaporatorInternalRFKT() throws LuaException {
        return ((HeatExchangerMultiblockController)((Object)this.controllerSupplier.get())).evaporatorAirRFKT;
    }

    @LuaFunction
    public double condenserEvaporatorRFKT() throws LuaException {
        return ((HeatExchangerMultiblockController)((Object)this.controllerSupplier.get())).channelRFKT;
    }

    @Nonnull
    public String getType() {
        return "BiggerReactors_Heat-Exchanger";
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (other instanceof HeatExchangerPeripheral) {
            if (this.rawControllerSupplier.get() == null) {
                return false;
            }
            return ((HeatExchangerPeripheral)other).rawControllerSupplier.get() == this.rawControllerSupplier.get();
        }
        return false;
    }

    public static class Channel {
        final LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException> heatBodySupplier;
        final LamdbaExceptionUtils.Supplier_WithExceptions<FluidTransitionTank, LuaException> transitionTankSupplier;
        final LamdbaExceptionUtils.Supplier_WithExceptions<Integer, LuaException> countSupplier;
        final LamdbaExceptionUtils.Supplier_WithExceptions<Lock, LuaException> lockSupplier;
        final ChannelFluid inputFluid;
        final ChannelFluid outputFluid;

        Channel(LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException> heatBodySupplier, LamdbaExceptionUtils.Supplier_WithExceptions<FluidTransitionTank, LuaException> transitionTankSupplier, LamdbaExceptionUtils.Supplier_WithExceptions<Integer, LuaException> countSupplier, LamdbaExceptionUtils.Supplier_WithExceptions<Lock, LuaException> lockSupplier) {
            this.heatBodySupplier = heatBodySupplier;
            this.transitionTankSupplier = transitionTankSupplier;
            this.countSupplier = countSupplier;
            this.lockSupplier = lockSupplier;
            this.inputFluid = new ChannelFluid(transitionTankSupplier, 0);
            this.outputFluid = new ChannelFluid(transitionTankSupplier, 1);
        }

        @LuaFunction
        public double temperature() throws LuaException {
            return ((HeatBody)this.heatBodySupplier.get()).temperature();
        }

        @LuaFunction
        public double rfPerKelvin() throws LuaException {
            return ((HeatBody)this.heatBodySupplier.get()).rfPerKelvin();
        }

        @LuaFunction
        public ChannelFluid input() {
            return this.inputFluid;
        }

        @LuaFunction
        public ChannelFluid output() {
            return this.outputFluid;
        }

        @LuaFunction
        public long transitionedLastTick() throws LuaException {
            return ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).transitionedLastTick();
        }

        @LuaFunction
        public long maxTransitionedLastTick() throws LuaException {
            return ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).maxTransitionedLastTick();
        }

        @LuaFunction
        public double transitionEnergy() throws LuaException {
            return ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).activeTransition().latentHeat;
        }

        @LuaFunction
        public void dump() throws LuaException {
            ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).dumpTank(0);
            ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).dumpTank(1);
        }

        public static class ChannelFluid {
            final LamdbaExceptionUtils.Supplier_WithExceptions<FluidTransitionTank, LuaException> transitionTankSupplier;
            final int tankNum;

            public ChannelFluid(LamdbaExceptionUtils.Supplier_WithExceptions<FluidTransitionTank, LuaException> transitionTankSupplier, int tankNum) {
                this.transitionTankSupplier = transitionTankSupplier;
                this.tankNum = tankNum;
            }

            @LuaFunction
            public String name() throws LuaException {
                return ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).fluidTypeInTank(this.tankNum).getRegistryName().toString();
            }

            @LuaFunction
            public long amount() throws LuaException {
                return ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).fluidAmountInTank(this.tankNum);
            }

            @LuaFunction
            public long maxAmount() throws LuaException {
                return ((FluidTransitionTank)((Object)this.transitionTankSupplier.get())).perSideCapacity;
            }
        }
    }

    public static class InternalEnvironment {
        final LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException> heatBodySupplier;

        public InternalEnvironment(LamdbaExceptionUtils.Supplier_WithExceptions<HeatBody, LuaException> heatBodySupplier) {
            this.heatBodySupplier = heatBodySupplier;
        }

        @LuaFunction
        public double temperature() throws LuaException {
            return ((HeatBody)this.heatBodySupplier.get()).temperature();
        }

        @LuaFunction
        public double rfPerKelvin() throws LuaException {
            return ((HeatBody)this.heatBodySupplier.get()).rfPerKelvin();
        }
    }
}

