/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.machine.tiles;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.api.IWorkHandler;
import net.roguelogix.biggerreactors.api.WorkHandler;
import net.roguelogix.biggerreactors.items.ingots.BlutoniumIngot;
import net.roguelogix.biggerreactors.machine.blocks.CyaniteReprocessor;
import net.roguelogix.biggerreactors.machine.containers.CyaniteReprocessorContainer;
import net.roguelogix.biggerreactors.machine.state.CyaniteReprocessorState;
import net.roguelogix.biggerreactors.machine.tiles.impl.CyaniteReprocessorItemHandler;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.debug.DebugTool;
import net.roguelogix.phosphophyllite.registry.RegisterTile;

public class CyaniteReprocessorTile
extends BaseContainerBlockEntity
implements MenuProvider,
IHasUpdatableState<CyaniteReprocessorState> {
    @RegisterTile(value="cyanite_reprocessor")
    public static final BlockEntityType.BlockEntitySupplier<CyaniteReprocessorTile> SUPPLIER = new RegisterTile.Producer(CyaniteReprocessorTile::new);
    public final CyaniteReprocessorState cyaniteReprocessorState = new CyaniteReprocessorState(this);
    private WorkHandler workHandler;
    private final LazyOptional<IWorkHandler> WORK_HANDLER_CAPABILITY = LazyOptional.of(() -> this.workHandler);
    private CyaniteReprocessorItemHandler itemHandler;
    private final LazyOptional<IItemHandler> ITEM_HANDLER_CAPABILITY = LazyOptional.of(() -> this.itemHandler.pipeHandler());
    private EnergyStorage energyStorage;
    private final LazyOptional<IEnergyStorage> ENERGY_STORAGE_CAPABILITY = LazyOptional.of(() -> this.energyStorage);
    private FluidTank fluidTank;
    private final LazyOptional<IFluidTank> FLUID_TANK_CAPABILITY = LazyOptional.of(() -> this.fluidTank);
    private ItemStack itemPresentLastTick = ItemStack.f_41583_;

    public CyaniteReprocessorTile(BlockEntityType<CyaniteReprocessorTile> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.m_6211_();
        this.updateState();
    }

    @Nonnull
    public InteractionResult onBlockActivated(@Nonnull BlockState blockState, Level world, @Nonnull BlockPos blockPos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult trace) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (ItemStack.m_41746_((ItemStack)player.m_21205_(), (ItemStack)new ItemStack((ItemLike)DebugTool.INSTANCE))) {
            player.m_6352_((Component)new TextComponent(String.format("[%s] Progress: %s/%s", "biggerreactors", this.cyaniteReprocessorState.workTime, this.cyaniteReprocessorState.workTimeTotal)), player.m_142081_());
            player.m_6352_((Component)new TextComponent(String.format("[%s] Energy: %s/%s RF", "biggerreactors", this.cyaniteReprocessorState.energyStored, this.cyaniteReprocessorState.energyCapacity)), player.m_142081_());
            player.m_6352_((Component)new TextComponent(String.format("[%s] Fluid Tank: %s/%s mB", "biggerreactors", this.cyaniteReprocessorState.waterStored, this.cyaniteReprocessorState.waterCapacity)), player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        if (ItemStack.m_41746_((ItemStack)player.m_21205_(), (ItemStack)new ItemStack((ItemLike)Items.f_42447_))) {
            if (this.fluidTank.getFluidAmount() <= Config.CONFIG.CyaniteReprocessor.WaterTankCapacity - 1000) {
                this.fluidTank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_));
            }
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)blockPos);
        return InteractionResult.SUCCESS;
    }

    public void onReplaced(BlockState blockState, Level world, BlockPos blockPos, BlockState newBlockState, boolean isMoving) {
        ItemStack outputStack;
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (!inputStack.m_41619_()) {
            Containers.m_19002_((Level)world, (BlockPos)blockPos, (Container)new SimpleContainer(new ItemStack[]{inputStack}));
        }
        if (!(outputStack = this.itemHandler.getStackInSlot(1)).m_41619_()) {
            Containers.m_19002_((Level)world, (BlockPos)blockPos, (Container)new SimpleContainer(new ItemStack[]{outputStack}));
        }
    }

    public Component m_5446_() {
        return this.m_6820_();
    }

    protected Component m_6820_() {
        return new TranslatableComponent("block.biggerreactors.cyanite_reprocessor");
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new CyaniteReprocessorContainer(windowId, this.m_58899_(), playerInventory.f_35978_);
    }

    @Nonnull
    public CyaniteReprocessorState getState() {
        this.updateState();
        return this.cyaniteReprocessorState;
    }

    public void updateState() {
        this.cyaniteReprocessorState.workTime = this.workHandler.getProgress();
        this.cyaniteReprocessorState.workTimeTotal = this.workHandler.getGoal();
        this.cyaniteReprocessorState.energyStored = this.energyStorage.getEnergyStored();
        this.cyaniteReprocessorState.energyCapacity = this.energyStorage.getMaxEnergyStored();
        this.cyaniteReprocessorState.waterStored = this.fluidTank.getFluidAmount();
        this.cyaniteReprocessorState.waterCapacity = this.fluidTank.getCapacity();
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int index = 0; index < this.itemHandler.getSlots(); ++index) {
            if (this.itemHandler.getStackInSlot(index).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.itemHandler.getStackInSlot(index).m_41620_(count);
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(index).m_41777_();
        this.itemHandler.setStackInSlot(index, ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack oldStack = this.itemHandler.getStackInSlot(index);
        boolean flag = !stack.m_41619_() && stack.m_41656_(oldStack) && ItemStack.m_41746_((ItemStack)stack, (ItemStack)oldStack);
        this.itemHandler.setStackInSlot(index, stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !flag) {
            this.workHandler.clear();
            this.m_6596_();
        }
    }

    public void m_6211_() {
        this.workHandler = new WorkHandler(Config.CONFIG.CyaniteReprocessor.TotalWorkTime);
        this.itemHandler = new CyaniteReprocessorItemHandler();
        this.itemHandler.setSize(2);
        this.energyStorage = new EnergyStorage(Config.CONFIG.CyaniteReprocessor.EnergyTankCapacity);
        this.fluidTank = new FluidTank(Config.CONFIG.CyaniteReprocessor.WaterTankCapacity, fluid -> fluid.getFluid() == Fluids.f_76193_);
    }

    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public void m_142466_(@Nonnull CompoundTag parentCompound) {
        super.m_142466_(parentCompound);
        CompoundTag childCompound = parentCompound.m_128469_("cyaniteReprocessorState");
        this.workHandler = new WorkHandler(childCompound.m_128451_("workTimeTotal"), childCompound.m_128451_("workTime"));
        this.itemHandler.deserializeNBT(childCompound.m_128469_("inventory"));
        this.energyStorage = new EnergyStorage(childCompound.m_128451_("energyCapacity"), Config.CONFIG.CyaniteReprocessor.TransferRate, Config.CONFIG.CyaniteReprocessor.TransferRate, childCompound.m_128451_("energyStored"));
        this.fluidTank = this.fluidTank.readFromNBT(childCompound.m_128469_("fluidStorage"));
    }

    public final void m_183515_(@Nonnull CompoundTag parentCompound) {
        super.m_183515_(parentCompound);
        CompoundTag childCompound = new CompoundTag();
        childCompound.m_128405_("workTime", this.workHandler.getProgress());
        childCompound.m_128405_("workTimeTotal", this.workHandler.getGoal());
        childCompound.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        childCompound.m_128405_("energyStored", this.energyStorage.getEnergyStored());
        childCompound.m_128405_("energyCapacity", this.energyStorage.getMaxEnergyStored());
        childCompound.m_128365_("fluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        parentCompound.m_128365_("cyaniteReprocessorState", (Tag)childCompound);
    }

    private boolean canWork() {
        if (this.m_8020_(1).m_41613_() >= 64) {
            return false;
        }
        return this.energyStorage.getEnergyStored() >= Config.CONFIG.CyaniteReprocessor.EnergyConsumptionPerTick && this.fluidTank.getFluidAmount() >= Config.CONFIG.CyaniteReprocessor.WaterConsumptionPerTick;
    }

    public void tick() {
        BlockState currentBlockState;
        BlockState newBlockState;
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean doUpdate = false;
        boolean isActive = false;
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        if (!ItemStack.m_41746_((ItemStack)this.itemPresentLastTick, (ItemStack)inputStack)) {
            this.workHandler.clear();
        }
        this.itemPresentLastTick = inputStack.m_41777_();
        if (inputStack.m_41613_() >= 2) {
            if (this.canWork()) {
                isActive = true;
                doUpdate = true;
                this.workHandler.increment(1);
                this.energyStorage.extractEnergy(Config.CONFIG.CyaniteReprocessor.EnergyConsumptionPerTick, false);
                this.fluidTank.drain(Config.CONFIG.CyaniteReprocessor.WaterConsumptionPerTick, IFluidHandler.FluidAction.EXECUTE);
            } else if (this.workHandler.getProgress() > 0) {
                this.workHandler.decrement(2);
            }
            if (this.workHandler.isFinished()) {
                this.itemHandler.extractItem(0, 2, false);
                this.itemHandler.insertItem(1, new ItemStack((ItemLike)BlutoniumIngot.INSTANCE, 1), false);
                this.workHandler.clear();
            }
        }
        if (!(newBlockState = (BlockState)(currentBlockState = this.f_58857_.m_8055_(this.m_58899_())).m_61124_((Property)CyaniteReprocessor.ENABLED, (Comparable)Boolean.valueOf(isActive))).equals(currentBlockState)) {
            this.f_58857_.m_7731_(this.m_58899_(), newBlockState, 3);
            doUpdate = true;
        }
        if (doUpdate) {
            this.m_6596_();
        }
        this.updateState();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return this.ITEM_HANDLER_CAPABILITY.cast();
        }
        if (capability.equals((Object)CapabilityEnergy.ENERGY)) {
            return this.ENERGY_STORAGE_CAPABILITY.cast();
        }
        if (capability.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return this.FLUID_TANK_CAPABILITY.cast();
        }
        return Objects.requireNonNull(super.getCapability(capability, side));
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.itemHandler.isItemValid(index, stack);
    }

    public CyaniteReprocessorItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

