/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class SendGeneralDataPacket
extends BaseS2CMessage {
    public int claimed;
    public int loaded;
    public int maxClaimChunks;
    public int maxForceLoadChunks;

    public static void send(FTBChunksTeamData playerData, ServerPlayer player) {
        SendGeneralDataPacket data = new SendGeneralDataPacket();
        data.maxClaimChunks = FTBChunksWorldConfig.getMaxClaimedChunks(playerData, player);
        data.maxForceLoadChunks = FTBChunksWorldConfig.getMaxForceLoadedChunks(playerData, player);
        for (ClaimedChunk chunk : playerData.getClaimedChunks()) {
            ++data.claimed;
            if (!chunk.isForceLoaded()) continue;
            ++data.loaded;
        }
        data.sendTo(player);
    }

    public SendGeneralDataPacket() {
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_GENERAL_DATA;
    }

    SendGeneralDataPacket(FriendlyByteBuf buf) {
        this.claimed = buf.m_130242_();
        this.loaded = buf.m_130242_();
        this.maxClaimChunks = buf.m_130242_();
        this.maxForceLoadChunks = buf.m_130242_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.claimed);
        buf.m_130130_(this.loaded);
        buf.m_130130_(this.maxClaimChunks);
        buf.m_130130_(this.maxForceLoadChunks);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateGeneralData(this);
    }
}

