/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimResults;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.ForceLoadMode;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PrivacyMode;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.property.BooleanProperty;
import dev.ftb.mods.ftbteams.property.PrivacyProperty;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class FTBChunksTeamData {
    public static final BooleanProperty ALLOW_FAKE_PLAYERS = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_fake_players"), Boolean.valueOf(true));
    public static final PrivacyProperty BLOCK_EDIT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_edit_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty BLOCK_INTERACT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_interact_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty MINIMAP_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "minimap_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty LOCATION_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "location_mode"), PrivacyMode.ALLIES);
    public static final BooleanProperty ALLOW_EXPLOSIONS = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_explosions"), Boolean.valueOf(false));
    public final ClaimedChunkManager manager;
    private final Team team;
    public final Path file;
    private boolean shouldSave;
    public int maxClaimChunks;
    public int maxForceLoadChunks;
    public int extraClaimChunks;
    public int extraForceLoadChunks;
    public final Set<UUID> forceLoadMembers;
    private Boolean canForceLoadChunks;
    public int prevChunkX = Integer.MAX_VALUE;
    public int prevChunkZ = Integer.MAX_VALUE;
    public String lastChunkID = "";

    public FTBChunksTeamData(ClaimedChunkManager m, Path f, Team t) {
        this.manager = m;
        this.team = t;
        this.file = f;
        this.shouldSave = false;
        this.maxClaimChunks = -1;
        this.maxForceLoadChunks = -1;
        this.extraClaimChunks = 0;
        this.extraForceLoadChunks = 0;
        this.forceLoadMembers = new HashSet<UUID>();
    }

    public String toString() {
        return this.team.getStringID();
    }

    public ClaimedChunkManager getManager() {
        return this.manager;
    }

    public Team getTeam() {
        return this.team;
    }

    public UUID getTeamId() {
        return this.team.getId();
    }

    public Collection<ClaimedChunk> getClaimedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.claimedChunks.values()) {
            if (chunk.teamData != this) continue;
            list.add(chunk);
        }
        return list;
    }

    public Collection<ClaimedChunk> getForceLoadedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.claimedChunks.values()) {
            if (chunk.teamData != this || !chunk.isForceLoaded()) continue;
            list.add(chunk);
        }
        return list;
    }

    public void updateLimits(ServerPlayer ownerPlayer) {
        if (this.maxClaimChunks != -1 && this.team.getType().isParty() && !ownerPlayer.m_142081_().equals(this.team.getOwner())) {
            return;
        }
        int c = FTBChunksWorldConfig.getMaxClaimedChunks(this, ownerPlayer);
        int f = FTBChunksWorldConfig.getMaxForceLoadedChunks(this, ownerPlayer);
        if (this.maxClaimChunks != c || this.maxForceLoadChunks != f) {
            this.maxClaimChunks = c;
            this.maxForceLoadChunks = f;
            for (ServerPlayer p : this.team.getOnlineMembers()) {
                SendGeneralDataPacket.send(this, p);
            }
            this.save();
        }
    }

    public ClaimResult claim(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk != null) {
            return ClaimResults.ALREADY_CLAIMED;
        }
        if (FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.contains(pos.dimension)) {
            return ClaimResults.DIMENSION_FORBIDDEN;
        }
        if (!this.team.getType().isServer() && this.getClaimedChunks().size() >= FTBChunksWorldConfig.getMaxClaimedChunks(this, FTBChunksTeamData.playerOrNull(source))) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunk(this, pos);
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_CLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        this.manager.claimedChunks.put(pos, chunk);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_CLAIM.invoker()).after(source, chunk);
        this.save();
        return chunk;
    }

    public ClaimResult unclaim(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.m_6761_(2) && !source.m_81377_().m_129792_()) {
            return ClaimResults.NOT_OWNER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNCLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unclaim(source, true);
        return chunk;
    }

    public ClaimResult load(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.m_6761_(2) && !source.m_81377_().m_129792_()) {
            return ClaimResults.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResults.ALREADY_LOADED;
        }
        if (!this.team.getType().isServer() && this.getForceLoadedChunks().size() >= FTBChunksWorldConfig.getMaxForceLoadedChunks(this, FTBChunksTeamData.playerOrNull(source))) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_LOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(System.currentTimeMillis());
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_LOAD.invoker()).after(source, chunk);
        chunk.teamData.save();
        chunk.sendUpdateToAll();
        return chunk;
    }

    public ClaimResult unload(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.teamData == this || source.m_6761_(2) || source.m_81377_().m_129792_() || source.m_81373_() instanceof ServerPlayer && this.isTeamMember(source.m_81373_().m_142081_()))) {
            return ClaimResults.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResults.NOT_LOADED;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNLOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unload(source);
        return chunk;
    }

    public void save() {
        this.shouldSave = true;
        this.team.save();
    }

    public boolean isTeamMember(UUID p) {
        if (p.equals(this.getTeamId())) {
            return true;
        }
        return this.team.equals((Object)FTBTeamsAPI.getManager().getPlayerTeam(p));
    }

    public boolean isAlly(UUID p) {
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_ALL || this.team.isMember(p)) {
            return true;
        }
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_NONE) {
            return false;
        }
        return this.team.isAlly(p);
    }

    public boolean canUse(ServerPlayer p, PrivacyProperty property) {
        PrivacyMode mode = (PrivacyMode)this.team.getProperty((TeamProperty)property);
        if (mode == PrivacyMode.PUBLIC) {
            return true;
        }
        if (mode == PrivacyMode.ALLIES) {
            if (PlayerHooks.isFake((Player)p)) {
                return (Boolean)this.team.getProperty((TeamProperty)ALLOW_FAKE_PLAYERS);
            }
            return this.isAlly(p.m_142081_());
        }
        return this.team.isMember(p.m_142081_());
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.m_128405_("max_claim_chunks", this.maxClaimChunks);
        tag.m_128405_("max_force_load_chunks", this.maxForceLoadChunks);
        tag.m_128405_("extra_claim_chunks", this.extraClaimChunks);
        tag.m_128405_("extra_force_load_chunks", this.extraForceLoadChunks);
        ListTag forceLoadMembersTag = new ListTag();
        for (UUID id : this.forceLoadMembers) {
            forceLoadMembersTag.add((Object)StringTag.m_129297_((String)id.toString()));
        }
        tag.m_128365_("force_load_members", (Tag)forceLoadMembersTag);
        CompoundTag chunksTag = new CompoundTag();
        for (ClaimedChunk chunk : this.getClaimedChunks()) {
            String key = chunk.getPos().dimension.m_135782_().toString();
            ListTag chunksListTag = chunksTag.m_128437_(key, 10);
            if (chunksListTag.isEmpty()) {
                chunksTag.m_128365_(key, (Tag)chunksListTag);
            }
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.singleLine();
            o.m_128405_("x", chunk.getPos().x);
            o.m_128405_("z", chunk.getPos().z);
            o.m_128356_("time", chunk.getTimeClaimed());
            if (chunk.isForceLoaded()) {
                o.m_128356_("force_loaded", chunk.getForceLoadedTime());
            }
            chunksListTag.add((Object)o);
        }
        tag.m_128365_("chunks", (Tag)chunksTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.maxClaimChunks = tag.m_128451_("max_claim_chunks");
        this.maxForceLoadChunks = tag.m_128451_("max_force_load_chunks");
        this.extraClaimChunks = tag.m_128451_("extra_claim_chunks");
        this.extraForceLoadChunks = tag.m_128451_("extra_force_load_chunks");
        this.forceLoadMembers.clear();
        ListTag forgeLoadMembersTag = tag.m_128437_("force_load_members", 8);
        if (tag.m_128471_("chunk_load_offline")) {
            this.forceLoadMembers.add(this.team.getOwner());
        } else {
            for (int i = 0; i < forgeLoadMembersTag.size(); ++i) {
                this.forceLoadMembers.add(UUID.fromString(forgeLoadMembersTag.m_128778_(i)));
            }
        }
        this.forceLoadMembers.remove(Util.f_137441_);
        this.canForceLoadChunks = null;
        CompoundTag chunksTag = tag.m_128469_("chunks");
        for (String key : chunksTag.m_128431_()) {
            ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(key));
            ListTag chunksListTag = chunksTag.m_128437_(key, 10);
            for (int i = 0; i < chunksListTag.size(); ++i) {
                CompoundTag o = chunksListTag.m_128728_(i);
                ClaimedChunk chunk = new ClaimedChunk(this, new ChunkDimPos(dimKey, o.m_128451_("x"), o.m_128451_("z")));
                chunk.time = o.m_128454_("time");
                chunk.forceLoaded = o.m_128454_("force_loaded");
                this.manager.claimedChunks.put(chunk.pos, chunk);
            }
        }
    }

    public int getExtraClaimChunks() {
        return this.extraClaimChunks;
    }

    public int getExtraForceLoadChunks() {
        return this.extraForceLoadChunks;
    }

    public void setForceLoadMember(UUID id, boolean val) {
        if (val ? this.forceLoadMembers.add(id) : this.forceLoadMembers.remove(id)) {
            this.save();
            this.canForceLoadChunks = null;
            this.manager.updateForceLoadedChunks();
        }
    }

    public void saveNow() {
        if (this.shouldSave && SNBT.write((Path)this.file, (CompoundTag)this.serializeNBT())) {
            this.shouldSave = false;
        }
    }

    public boolean canForceLoadChunks() {
        if (this.canForceLoadChunks == null) {
            this.canForceLoadChunks = switch ((ForceLoadMode)((Object)FTBChunksWorldConfig.FORCE_LOAD_MODE.get())) {
                case ForceLoadMode.ALWAYS -> true;
                case ForceLoadMode.NEVER -> false;
                default -> this.hasForceLoadMembers();
            };
        }
        return this.canForceLoadChunks;
    }

    public boolean hasForceLoadMembers() {
        for (UUID uuid : this.team.getMembers()) {
            if (!this.forceLoadMembers.contains(uuid)) continue;
            return true;
        }
        return false;
    }

    public static ServerPlayer playerOrNull(CommandSourceStack source) {
        ServerPlayer player;
        Entity entity = source.m_81373_();
        return entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null;
    }

    public boolean allowExplosions() {
        return (Boolean)this.team.getProperty((TeamProperty)ALLOW_EXPLOSIONS);
    }
}

