/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.items;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class SyringeItem
extends Item {
    public static final int MAX_SYRINGE_MODEL_LEVEL = 5;
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.parameter((String)"level", this::getLevelString), TooltipBuilder.parameter((String)"mob", this::hasMob, SyringeItem::getMobName), TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"level", this::getLevelString), TooltipBuilder.parameter((String)"mob", this::hasMob, SyringeItem::getMobName)});

    public SyringeItem() {
        super(new Item.Properties().m_41491_(RFToolsUtility.setup.getTab()).m_41487_(1));
    }

    private String getLevelString(ItemStack stack) {
        return Integer.toString(SyringeItem.getLevel(stack));
    }

    private boolean hasMob(ItemStack stack) {
        return SyringeItem.getMobId(stack) != null;
    }

    public static int getLevel(ItemStack stack) {
        return NBTTools.getInt((ItemStack)stack, (String)"level", (int)((Integer)SpawnerConfiguration.maxMobInjections.get())) * 100 / (Integer)SpawnerConfiguration.maxMobInjections.get();
    }

    public static void initOverrides(SyringeItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("rftoolsutility", "level"), (stack, world, livingEntity, seed) -> {
            int level = NBTTools.getInt((ItemStack)stack, (String)"level", (int)((Integer)SpawnerConfiguration.maxMobInjections.get()));
            level = level * 5 / (Integer)SpawnerConfiguration.maxMobInjections.get();
            return level;
        });
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    @Nullable
    public static LivingEntity getEntityLivingFromClickedEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public static ItemStack createMobSyringe(ResourceLocation mobId) {
        ItemStack syringe = new ItemStack((ItemLike)SpawnerModule.SYRINGE.get());
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128359_("mobId", mobId.toString());
        syringe.m_41751_(tagCompound);
        return syringe;
    }

    public static String getMobId(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            return tagCompound.m_128461_("mobId");
        }
        return null;
    }

    public static String getMobName(ItemStack stack) {
        String id = SyringeItem.getMobId(stack);
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        if (type != null) {
            return type.m_20676_().getString();
        }
        return id;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
                if (((EntityType)entry.getValue()).m_20674_() == MobCategory.MISC) continue;
                items.add((Object)SyringeItem.createMobSyringe(id));
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            CompoundTag tagCompound = stack.m_41783_();
            if (tagCompound != null) {
                String mobName = SyringeItem.getMobName(stack);
                if (mobName != null) {
                    Logging.message((Player)player, (String)(ChatFormatting.BLUE + "Mob: " + mobName));
                }
                int level = tagCompound.m_128441_("level") ? tagCompound.m_128451_("level") : ((Integer)SpawnerConfiguration.maxMobInjections.get()).intValue();
                level = level * 100 / (Integer)SpawnerConfiguration.maxMobInjections.get();
                Logging.message((Player)player, (String)(ChatFormatting.BLUE + "Essence level: " + level + "%"));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity entityLiving = SyringeItem.getEntityLivingFromClickedEntity(entity);
        if (entityLiving != null) {
            String prevMobId = null;
            CompoundTag tagCompound = stack.m_41783_();
            if (tagCompound != null) {
                prevMobId = tagCompound.m_128461_("mobId");
            } else {
                tagCompound = new CompoundTag();
                stack.m_41751_(tagCompound);
            }
            String id = this.findSelectedMobId((Entity)entityLiving);
            if (id != null && !id.isEmpty()) {
                if (!id.equals(prevMobId)) {
                    tagCompound.m_128359_("mobName", Tools.getId((EntityType)entityLiving.m_6095_()).toString());
                    tagCompound.m_128359_("mobId", id);
                    tagCompound.m_128405_("level", 1);
                } else {
                    tagCompound.m_128405_("level", Math.min((tagCompound.m_128441_("level") ? tagCompound.m_128451_("level") : ((Integer)SpawnerConfiguration.maxMobInjections.get()).intValue()) + 1, (Integer)SpawnerConfiguration.maxMobInjections.get()));
                }
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private String findSelectedMobId(Entity entity) {
        ResourceLocation key = Tools.getId((EntityType)entity.m_6095_());
        return key != null ? key.toString() : null;
    }
}

