/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.logic.blocks.CounterTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.CounterPlusScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.CounterPlusClientScreenModule;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CounterPlusModuleItem
extends GenericModuleItem {
    public CounterPlusModuleItem() {
        super(new Item.Properties().m_41487_(1).m_41499_(1).m_41491_(RFToolsUtility.setup.getTab()));
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.COUNTERPLUS_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public Class<CounterPlusScreenModule> getServerScreenModule() {
        return CounterPlusScreenModule.class;
    }

    public Class<CounterPlusClientScreenModule> getClientScreenModule() {
        return CounterPlusClientScreenModule.class;
    }

    public String getModuleName() {
        return "Count";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", new String[]{"Label text"}).nl().label("L:").color("color", new String[]{"Color for the label"}).label("C:").color("cntcolor", new String[]{"Color for the counter"}).nl().format("format").choices("align", "Label alignment", new String[]{"Left", "Center", "Right"}).nl().label("Block:").block("monitor").nl();
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Uses " + ScreenConfiguration.COUNTERPLUS_RFPERTICK.get() + " RF/tick")));
        boolean hasTarget = false;
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Label: " + tagCompound.m_128461_("text"))));
            if (tagCompound.m_128441_("monitorx")) {
                int monitorx = tagCompound.m_128451_("monitorx");
                int monitory = tagCompound.m_128451_("monitory");
                int monitorz = tagCompound.m_128451_("monitorz");
                String monitorname = tagCompound.m_128461_("monitorname");
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")")));
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "Sneak right-click on a counter to set the")));
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "target for this counter module")));
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Player player = context.m_43723_();
        BlockEntity te = world.m_7702_(pos);
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
        }
        if (te instanceof CounterTileEntity) {
            tagCompound.m_128359_("monitordim", world.m_46472_().m_135782_().toString());
            tagCompound.m_128405_("monitorx", pos.m_123341_());
            tagCompound.m_128405_("monitory", pos.m_123342_());
            tagCompound.m_128405_("monitorz", pos.m_123343_());
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            String name = "<invalid>";
            if (block != null && !state.m_60795_()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            tagCompound.m_128359_("monitorname", name);
            if (world.f_46443_) {
                Logging.message((Player)player, (String)("Counter module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.m_128473_("monitordim");
            tagCompound.m_128473_("monitorx");
            tagCompound.m_128473_("monitory");
            tagCompound.m_128473_("monitorz");
            tagCompound.m_128473_("monitorname");
            if (world.f_46443_) {
                Logging.message((Player)player, (String)"Counter module is cleared");
            }
        }
        stack.m_41751_(tagCompound);
        return InteractionResult.SUCCESS;
    }
}

