/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkHooks;

public class RedstoneInformationItem
extends Item
implements ITabletSupport,
ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create((String)"rftoolsutility:logic/redstone_information");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"channels", stack -> {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        List list = channels.stream().sorted().toList();
        Object s = "";
        String prefix = "";
        for (Integer channel : list) {
            s = (String)s + prefix + channel;
            prefix = ", ";
        }
        return s;
    })});

    public RedstoneInformationItem() {
        super(new Item.Properties().m_41499_(1).m_41491_(RFToolsUtility.setup.getTab()));
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flag);
    }

    public Item getInstalledTablet() {
        return (Item)LogicBlockModule.TABLET_REDSTONE.get();
    }

    public void openGui(@Nonnull Player player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return ComponentFactory.literal((String)"Redstone Module");
            }

            public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                return new RedstoneInformationContainer(id, player.m_142538_(), player);
            }
        });
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            this.openGui(player, stack, stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static Set<Integer> getChannels(ItemStack stack) {
        return NBTTools.getTag((ItemStack)stack).map(tag -> IntStream.of(tag.m_128465_("Channels")).boxed().collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public static boolean addChannel(ItemStack stack, int channel) {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        if (!channels.contains(channel)) {
            channels = new HashSet<Integer>(channels);
            channels.add(channel);
            CompoundTag tag = stack.m_41784_();
            tag.m_128408_("Channels", new ArrayList<Integer>(channels));
            return true;
        }
        return false;
    }

    public static void removeChannel(ItemStack stack, int channel) {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        channels.remove(channel);
        CompoundTag tag = stack.m_41784_();
        tag.m_128408_("Channels", new ArrayList<Integer>(channels));
    }
}

