/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.varia;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class Tools {
    public static ResourceKey<Level> getDimensionKey(LevelAccessor world) {
        if (world instanceof Level) {
            return ((Level)world).m_46472_();
        }
        if (world instanceof ServerLevelAccessor) {
            return ((ServerLevelAccessor)world).m_6018_().m_46472_();
        }
        throw new IllegalStateException("Not possible to get a dimension key here!");
    }

    public static String getBiomeId(Holder<Biome> biomeHolder) {
        return (String)biomeHolder.m_203439_().map(key -> key.m_135782_().toString(), key -> "[unregistered " + key + "]");
    }

    @Nonnull
    public static String getBiomeIdSlowAndOldAndProbablySomewhatWrong(Biome biome) {
        if (biome.getRegistryName() == null) {
            Optional biomeRegistry = RegistryAccess.m_206197_().m_6632_(Registry.f_122885_);
            return biomeRegistry.map(r -> r.m_7854_((Object)biome).map(key -> key.m_135782_().toString()).orElse("")).orElse("");
        }
        return biome.getRegistryName().toString();
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(String name, Logger logger) {
        int i;
        for (i = 0; i < name.length() && (Character.isDigit(name.charAt(i)) || name.charAt(i) == '.'); ++i) {
        }
        if (i < name.length() && name.charAt(i) == '=') {
            float v;
            String f = name.substring(0, i);
            try {
                v = Float.parseFloat(f);
            }
            catch (NumberFormatException e) {
                v = 1.0f;
            }
            return Pair.of((Object)Float.valueOf(v), (Object)Tools.parseStack(name.substring(i + 1), logger));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Tools.parseStack(name, logger));
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(JsonObject obj, Logger logger) {
        ItemStack stack;
        float factor = 1.0f;
        if (obj.has("factor")) {
            factor = obj.get("factor").getAsFloat();
        }
        if ((stack = Tools.parseStack(obj, logger)) == null) {
            return null;
        }
        return Pair.of((Object)Float.valueOf(factor), (Object)stack);
    }

    @Nonnull
    public static ItemStack parseStack(String name, Logger logger) {
        if (name.contains("/")) {
            CompoundTag nbt;
            String[] split = StringUtils.split((String)name, (String)"/");
            ItemStack stack = Tools.parseStackNoNBT(split[0], logger);
            if (stack.m_41619_()) {
                return stack;
            }
            try {
                nbt = TagParser.m_129359_((String)split[1]);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing NBT in '" + name + "'!");
                return ItemStack.f_41583_;
            }
            stack.m_41751_(nbt);
            return stack;
        }
        return Tools.parseStackNoNBT(name, logger);
    }

    @Nullable
    public static ItemStack parseStack(JsonObject obj, Logger logger) {
        if (obj.has("empty")) {
            return ItemStack.f_41583_;
        }
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            ErrorHandler.error("Unknown item '" + name + "'!");
            return null;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (obj.has("damage")) {
            stack.m_41721_(obj.get("damage").getAsInt());
        }
        if (obj.has("count")) {
            stack.m_41764_(obj.get("count").getAsInt());
        }
        if (obj.has("nbt")) {
            String nbt = obj.get("nbt").toString();
            CompoundTag tag = null;
            try {
                tag = TagParser.m_129359_((String)nbt);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing json '" + nbt + "'!");
                return ItemStack.f_41583_;
            }
            stack.m_41751_(tag);
        }
        return stack;
    }

    private static ItemStack parseStackNoNBT(String name, Logger logger) {
        if (name.contains("@")) {
            String[] split = StringUtils.split((String)name, (String)"@");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
            if (item == null) {
                return ItemStack.f_41583_;
            }
            int meta = 0;
            try {
                meta = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                ErrorHandler.error("Unknown item '" + name + "'!");
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)item, 1);
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    public static ServerLevel getServerWorld(LevelAccessor world) {
        ServerLevel sw;
        if (world instanceof ServerLevel) {
            sw = (ServerLevel)world;
        } else if (world instanceof ServerLevelAccessor) {
            sw = ((ServerLevelAccessor)world).m_6018_();
        } else {
            throw new IllegalStateException("No world found!");
        }
        return sw;
    }
}

