/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.typed;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.Key;
import mcjty.incontrol.tools.typed.Type;
import mcjty.incontrol.tools.varia.JSonTools;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public class GenericAttributeMapFactory {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public GenericAttributeMapFactory attribute(@Nonnull Attribute a) {
        this.attributes.add(a);
        return this;
    }

    private boolean validate(JsonObject object, String file) {
        Set validKeys = this.attributes.stream().map(a -> a.key().name()).collect(Collectors.toSet());
        HashSet errors = new HashSet();
        object.keySet().forEach(attr -> {
            if (!validKeys.contains(attr)) {
                errors.add(attr);
            }
        });
        if (!errors.isEmpty()) {
            ErrorHandler.error("Invalid keywords for " + file + ": " + StringUtils.join(errors, (char)' '));
            return false;
        }
        return true;
    }

    @Nonnull
    public AttributeMap parse(@Nonnull JsonElement element, String file) {
        JsonObject jsonObject = element.getAsJsonObject();
        AttributeMap map = new AttributeMap();
        if (!this.validate(jsonObject, file)) {
            return map;
        }
        for (Attribute attribute : this.attributes) {
            Key key = attribute.key();
            Type type = key.type();
            if (attribute.multi()) {
                Function<JsonElement, Object> transformer = type == Type.INTEGER ? JsonElement::getAsInt : (type == Type.FLOAT ? JsonElement::getAsFloat : (type == Type.BOOLEAN ? JsonElement::getAsBoolean : (type == Type.STRING ? JsonElement::getAsString : (type == Type.JSON ? JsonElement::toString : (type == Type.DIMENSION_TYPE ? jsonElement -> {
                    ResourceKey worldkey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(jsonElement.getAsString()));
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (server != null && !server.m_129784_().contains(worldkey)) {
                        ErrorHandler.error("Dimension '" + jsonElement.getAsString() + "' not found!");
                    }
                    return worldkey;
                } : e -> "INVALID")))));
                JSonTools.getElement(jsonObject, key.name()).ifPresent(e -> JSonTools.asArrayOrSingle(e).map(transformer).forEach(s -> map.addListNonnull(key, s)));
                continue;
            }
            if (type == Type.INTEGER) {
                map.setNonnull(key, JSonTools.parseInt(jsonObject, key.name()));
                continue;
            }
            if (type == Type.FLOAT) {
                map.setNonnull(key, JSonTools.parseFloat(jsonObject, key.name()));
                continue;
            }
            if (type == Type.BOOLEAN) {
                map.setNonnull(key, JSonTools.parseBool(jsonObject, key.name()));
                continue;
            }
            if (type == Type.STRING) {
                if (!jsonObject.has(key.name())) continue;
                map.setNonnull(key, jsonObject.get(key.name()).getAsString());
                continue;
            }
            if (type == Type.DIMENSION_TYPE) {
                if (!jsonObject.has(key.name())) continue;
                JsonElement jsonElement2 = jsonObject.get(key.name());
                map.setNonnull(key, ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(jsonElement2.getAsString())));
                continue;
            }
            if (type != Type.JSON || !jsonObject.has(key.name())) continue;
            JsonElement el = jsonObject.get(key.name());
            if (el.isJsonObject()) {
                JsonObject obj = el.getAsJsonObject();
                map.setNonnull(key, obj.toString());
                continue;
            }
            if (!el.isJsonPrimitive()) continue;
            JsonPrimitive prim = el.getAsJsonPrimitive();
            if (prim.isString()) {
                map.setNonnull(key, prim.getAsString());
                continue;
            }
            if (prim.isNumber()) {
                map.setNonnull(key, "" + prim.getAsInt());
                continue;
            }
            throw new RuntimeException("Bad type for key '" + key.name() + "'!");
        }
        return map;
    }
}

