/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.tools.rules.CommonRuleEvaluator;
import mcjty.incontrol.tools.rules.CommonRuleKeys;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.varia.LookAtTools;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class RuleBase<T extends EventGetter> {
    protected final Logger logger;
    protected final List<Consumer<T>> actions = new ArrayList<Consumer<T>>();
    private static final Random rnd = new Random();
    private static Map<String, DamageSource> damageMap = null;

    public RuleBase(Logger logger) {
        this.logger = logger;
    }

    protected List<Pair<Float, ItemStack>> getItemsWeighted(List<String> itemNames) {
        ArrayList<Pair<Float, ItemStack>> items = new ArrayList<Pair<Float, ItemStack>>();
        Iterator<String> iterator = itemNames.iterator();
        while (iterator.hasNext()) {
            Pair<Float, ItemStack> pair;
            JsonParser parser = new JsonParser();
            String json = iterator.next();
            JsonElement element = parser.parse(json);
            if (element.isJsonPrimitive()) {
                String name = element.getAsString();
                pair = Tools.parseStackWithFactor(name, this.logger);
                if (((ItemStack)pair.getValue()).m_41619_()) {
                    ErrorHandler.error("Unknown item '" + name + "'!");
                    continue;
                }
                items.add(pair);
                continue;
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                pair = Tools.parseStackWithFactor(obj, this.logger);
                if (pair == null) continue;
                items.add(pair);
                continue;
            }
            ErrorHandler.error("Item description '" + json + "' is not valid!");
        }
        return items;
    }

    protected ItemStack getRandomItem(List<Pair<Float, ItemStack>> items, float total) {
        float r = rnd.nextFloat() * total;
        for (Pair<Float, ItemStack> pair : items) {
            if (r <= ((Float)pair.getLeft()).floatValue()) {
                return ((ItemStack)pair.getRight()).m_41777_();
            }
            r -= ((Float)pair.getLeft()).floatValue();
        }
        return ItemStack.f_41583_;
    }

    protected float getTotal(List<Pair<Float, ItemStack>> items) {
        float total = 0.0f;
        for (Pair<Float, ItemStack> pair : items) {
            total += ((Float)pair.getLeft()).floatValue();
        }
        return total;
    }

    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        map.consume(CommonRuleKeys.ACTION_COMMAND, this::addCommandAction);
        map.consume(CommonRuleKeys.ACTION_ADDSTAGE, stage -> this.addAddStage((String)stage, layer));
        map.consume(CommonRuleKeys.ACTION_REMOVESTAGE, stage -> this.addRemoveStage((String)stage, layer));
        map.consume(CommonRuleKeys.ACTION_HEALTHSET, this::addHealthSetAction);
        map.consume2(CommonRuleKeys.ACTION_HEALTHMULTIPLY, CommonRuleKeys.ACTION_HEALTHADD, this::addHealthAction);
        map.consume(CommonRuleKeys.ACTION_SPEEDSET, this::addSpeedSetAction);
        map.consume2(CommonRuleKeys.ACTION_SPEEDMULTIPLY, CommonRuleKeys.ACTION_SPEEDADD, this::addSpeedAction);
        map.consume(CommonRuleKeys.ACTION_DAMAGESET, this::addDamageSetAction);
        map.consume2(CommonRuleKeys.ACTION_DAMAGEMULTIPLY, CommonRuleKeys.ACTION_DAMAGEADD, this::addDamageAction);
        map.consume2(CommonRuleKeys.ACTION_SIZEMULTIPLY, CommonRuleKeys.ACTION_SIZEADD, this::addSizeActions);
        map.consumeAsList(CommonRuleKeys.ACTION_POTION, this::addPotionsAction);
        map.consume(CommonRuleKeys.ACTION_ANGRY, this::addAngryAction);
        map.consume(CommonRuleKeys.ACTION_CUSTOMNAME, this::addCustomName);
        map.consume(CommonRuleKeys.ACTION_MOBNBT, this::addMobNBT);
        map.consumeAsList(CommonRuleKeys.ACTION_HELDITEM, this::addHeldItem);
        map.consumeAsList(CommonRuleKeys.ACTION_ARMORBOOTS, items -> this.addArmorItem((List<String>)items, EquipmentSlot.FEET));
        map.consumeAsList(CommonRuleKeys.ACTION_ARMORLEGS, items -> this.addArmorItem((List<String>)items, EquipmentSlot.LEGS));
        map.consumeAsList(CommonRuleKeys.ACTION_ARMORHELMET, items -> this.addArmorItem((List<String>)items, EquipmentSlot.HEAD));
        map.consumeAsList(CommonRuleKeys.ACTION_ARMORCHEST, items -> this.addArmorItem((List<String>)items, EquipmentSlot.CHEST));
        map.consume(CommonRuleKeys.ACTION_FIRE, this::addFireAction);
        map.consume(CommonRuleKeys.ACTION_EXPLOSION, this::addExplosionAction);
        map.consume(CommonRuleKeys.ACTION_CLEAR, this::addClearAction);
        map.consume(CommonRuleKeys.ACTION_DAMAGE, this::addDoDamageAction);
        map.consume(CommonRuleKeys.ACTION_MESSAGE, this::addDoMessageAction);
        map.consumeAsList(CommonRuleKeys.ACTION_GIVE, this::addGiveAction);
        map.consumeAsList(CommonRuleKeys.ACTION_DROP, this::addDropAction);
        map.consume2(CommonRuleKeys.ACTION_SETBLOCK, CommonRuleKeys.BLOCKOFFSET, this::addSetBlockAction);
        map.consume(CommonRuleKeys.ACTION_SETHELDITEM, this::addSetHeldItemAction);
        map.consume(CommonRuleKeys.ACTION_SETHELDAMOUNT, this::addSetHeldAmountAction);
        map.consume(CommonRuleKeys.ACTION_SETSTATE, state -> {
            if (layer.hasEnigmaScript()) {
                this.addStateAction((String)state, layer);
            } else {
                this.logger.warn("EnigmaScript is missing: this action cannot work!");
            }
        });
        map.consume(CommonRuleKeys.ACTION_SETPSTATE, state -> {
            if (layer.hasEnigmaScript()) {
                this.addPStateAction((String)state, layer);
            } else {
                this.logger.warn("EnigmaScript is missing: this action cannot work!");
            }
        });
    }

    private static void addSource(DamageSource source) {
        damageMap.put(source.m_19385_(), source);
    }

    private void createDamageMap() {
        if (damageMap == null) {
            damageMap = new HashMap<String, DamageSource>();
            RuleBase.addSource(DamageSource.f_19305_);
            RuleBase.addSource(DamageSource.f_19306_);
            RuleBase.addSource(DamageSource.f_19307_);
            RuleBase.addSource(DamageSource.f_19308_);
            RuleBase.addSource(DamageSource.f_19309_);
            RuleBase.addSource(DamageSource.f_19310_);
            RuleBase.addSource(DamageSource.f_19311_);
            RuleBase.addSource(DamageSource.f_19312_);
            RuleBase.addSource(DamageSource.f_19313_);
            RuleBase.addSource(DamageSource.f_19314_);
            RuleBase.addSource(DamageSource.f_19315_);
            RuleBase.addSource(DamageSource.f_19316_);
            RuleBase.addSource(DamageSource.f_19317_);
            RuleBase.addSource(DamageSource.f_19318_);
            RuleBase.addSource(DamageSource.f_19319_);
            RuleBase.addSource(DamageSource.f_19320_);
            RuleBase.addSource(DamageSource.f_19321_);
            RuleBase.addSource(DamageSource.f_19322_);
            RuleBase.addSource(DamageSource.f_19323_);
        }
    }

    private void addCommandAction(String command) {
        this.actions.add(event -> {});
    }

    private void addAddStage(String stage, IModRuleCompatibilityLayer layer) {
        this.actions.add(event -> {
            Player player = event.getPlayer();
            if (player != null) {
                layer.addGameStage(player, stage);
            }
        });
    }

    private void addRemoveStage(String stage, IModRuleCompatibilityLayer layer) {
        this.actions.add(event -> {
            Player player = event.getPlayer();
            if (player != null) {
                layer.removeGameStage(player, stage);
            }
        });
    }

    private void addDoDamageAction(String damage) {
        this.createDamageMap();
        String[] split = StringUtils.split((String)damage, (String)"=");
        DamageSource source = damageMap.get(split[0]);
        if (source == null) {
            ErrorHandler.error("Can't find damage source '" + split[0] + "'!");
            return;
        }
        float amount = 1.0f;
        if (split.length > 1) {
            amount = Float.parseFloat(split[1]);
        }
        float finalAmount = amount;
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living != null) {
                living.m_6469_(source, finalAmount);
            }
        });
    }

    private void addDoMessageAction(String message) {
        this.actions.add(event -> {
            Player player = event.getPlayer();
            if (player == null) {
                player = event.getWorld().m_45930_((Entity)event.getEntityLiving(), 100.0);
            }
            if (player != null) {
                player.m_5661_((Component)new TextComponent(message), false);
            }
        });
    }

    private void addGiveAction(List<String> itemList) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                Player player = event.getPlayer();
                if (player != null && !player.m_150109_().m_36054_(item.m_41777_())) {
                    player.m_5552_(item.m_41777_(), 1.05f);
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                Player player = event.getPlayer();
                if (player != null) {
                    ItemStack item = this.getRandomItem(items, total);
                    if (!player.m_150109_().m_36054_(item.m_41777_())) {
                        player.m_5552_(item.m_41777_(), 1.05f);
                    }
                }
            });
        }
    }

    private void addStateAction(String s, IModRuleCompatibilityLayer layer) {
        String value;
        String state;
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        String finalState = state;
        String finalValue = value;
        this.actions.add(event -> layer.setState(event.getWorld(), finalState, finalValue));
    }

    private void addPStateAction(String s, IModRuleCompatibilityLayer layer) {
        String value;
        String state;
        String[] split = StringUtils.split((String)s, (char)'=');
        try {
            state = split[0];
            value = split[1];
        }
        catch (Exception e) {
            ErrorHandler.error("Bad state=value specifier '" + s + "'!");
            return;
        }
        String finalState = state;
        String finalValue = value;
        this.actions.add(event -> layer.setPlayerState(event.getPlayer(), finalState, finalValue));
    }

    @Nonnull
    private Function<EventGetter, BlockPos> parseOffset(String json) {
        int offsetZ;
        int offsetY;
        int offsetX;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("offset")) {
            JsonObject offset = obj.getAsJsonObject("offset");
            offsetX = offset.has("x") ? offset.get("x").getAsInt() : 0;
            offsetY = offset.has("y") ? offset.get("y").getAsInt() : 0;
            offsetZ = offset.has("z") ? offset.get("z").getAsInt() : 0;
        } else {
            offsetX = 0;
            offsetY = 0;
            offsetZ = 0;
        }
        if (obj.has("look")) {
            return event -> {
                HitResult result = LookAtTools.getMovingObjectPositionFromPlayer(event.getWorld(), event.getPlayer(), false);
                if (result instanceof BlockHitResult) {
                    return ((BlockHitResult)result).m_82425_().m_142082_(offsetX, offsetY, offsetZ);
                }
                return event.getPosition().m_142082_(offsetX, offsetY, offsetZ);
            };
        }
        return event -> event.getPosition().m_142082_(offsetX, offsetY, offsetZ);
    }

    private void addSetHeldItemAction(String json) {
        ItemStack stack;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String name = element.getAsString();
            stack = Tools.parseStack(name, this.logger);
        } else if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            stack = Tools.parseStack(obj, this.logger);
            if (stack == null) {
                return;
            }
        } else {
            ErrorHandler.error("Item description '" + json + "' is not valid!");
            return;
        }
        this.actions.add(event -> event.getPlayer().m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_()));
    }

    private void addSetHeldAmountAction(String amount) {
        int add = 0;
        int set = -1;
        if (amount.startsWith("+")) {
            add = Integer.parseInt(amount.substring(1));
        } else if (amount.startsWith("-")) {
            add = -Integer.parseInt(amount.substring(1));
        } else {
            set = amount.startsWith("=") ? Integer.parseInt(amount.substring(1)) : Integer.parseInt(amount);
        }
        int finalSet = set;
        if (finalSet >= 0) {
            this.actions.add(event -> {
                ItemStack item = event.getPlayer().m_21205_();
                item.m_41764_(finalSet);
                event.getPlayer().m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
            });
        } else {
            int finalAdd = add;
            this.actions.add(event -> {
                ItemStack item = event.getPlayer().m_21205_();
                int newCount = item.m_41613_() + finalAdd;
                if (newCount < 0) {
                    newCount = 0;
                } else if (newCount >= item.m_41741_()) {
                    newCount = item.m_41741_() - 1;
                }
                item.m_41764_(newCount);
                event.getPlayer().m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
            });
        }
    }

    private void addSetBlockAction(String json, String bo) {
        Function<EventGetter, BlockPos> posFunction = bo != null ? this.parseOffset(bo) : EventGetter::getPosition;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonPrimitive()) {
            String blockname = element.getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return;
            }
            BlockState state = block.m_49966_();
            this.actions.add(event -> {
                BlockPos pos = (BlockPos)posFunction.apply((EventGetter)event);
                if (pos != null) {
                    event.getWorld().m_7731_(pos, state, 3);
                }
            });
        } else {
            JsonObject obj = element.getAsJsonObject();
            if (!obj.has("block")) {
                ErrorHandler.error("Block is not valid!");
                return;
            }
            String blockname = obj.get("block").getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            if (block == null) {
                ErrorHandler.error("Block '" + blockname + "' is not valid!");
                return;
            }
            BlockState state = block.m_49966_();
            if (obj.has("properties")) {
                JsonArray propArray = obj.get("properties").getAsJsonArray();
                for (JsonElement el : propArray) {
                    JsonObject propObj = el.getAsJsonObject();
                    String name = propObj.get("name").getAsString();
                    String value = propObj.get("value").getAsString();
                    for (Property key : state.m_61147_()) {
                        if (!name.equals(key.m_61708_())) continue;
                        state = CommonRuleEvaluator.set(state, key, value);
                    }
                }
            }
            BlockState finalState = state;
            this.actions.add(event -> {
                BlockPos pos = (BlockPos)posFunction.apply((EventGetter)event);
                if (pos != null) {
                    event.getWorld().m_7731_(pos, finalState, 3);
                }
            });
        }
    }

    private void addDropAction(List<String> itemList) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                if (event.getWorld() instanceof Level) {
                    BlockPos pos = event.getPosition();
                    ItemEntity entityItem = new ItemEntity((Level)event.getWorld(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item.m_41777_());
                    event.getWorld().m_7967_((Entity)entityItem);
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                if (event.getWorld() instanceof Level) {
                    BlockPos pos = event.getPosition();
                    ItemStack item = this.getRandomItem(items, total);
                    ItemEntity entityItem = new ItemEntity((Level)event.getWorld(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item.m_41777_());
                    event.getWorld().m_7967_((Entity)entityItem);
                }
            });
        }
    }

    private void addClearAction(boolean clear) {
        if (clear) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                if (living != null) {
                    living.m_21219_();
                }
            });
        }
    }

    private void addFireAction(int fireAction) {
        this.actions.add(event -> {
            LivingEntity living = event.getEntityLiving();
            if (living != null) {
                living.m_6469_(DamageSource.f_19307_, 0.1f);
                living.m_20254_(fireAction);
            }
        });
    }

    private void addExplosionAction(String fireAction) {
        String[] split = StringUtils.split((String)fireAction, (String)",");
        float strength = 1.0f;
        boolean flaming = false;
        boolean smoking = false;
        try {
            strength = Float.parseFloat(split[0]);
            flaming = "1".equalsIgnoreCase(split[1]) || "true".equals(split[1].toLowerCase()) || "yes".equals(split[1].toLowerCase());
            smoking = "1".equalsIgnoreCase(split[2]) || "true".equals(split[2].toLowerCase()) || "yes".equals(split[2].toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        float finalStrength = strength;
        boolean finalFlaming = flaming;
        boolean finalSmoking = smoking;
        this.actions.add(event -> {
            BlockPos pos = event.getPosition();
            if (pos != null && event.getWorld() instanceof Level) {
                ((Level)event.getWorld()).m_46518_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, finalStrength, finalFlaming, Explosion.BlockInteraction.DESTROY);
            }
        });
    }

    protected void addPotionsAction(List<String> potions) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (String p : potions) {
            String[] splitted = StringUtils.split((String)p, (char)',');
            if (splitted == null || splitted.length != 3) {
                ErrorHandler.error("Bad potion specifier '" + p + "'! Use <potion>,<duration>,<amplifier>");
                continue;
            }
            MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(splitted[0]));
            if (potion == null) {
                ErrorHandler.error("Can't find potion '" + p + "'!");
                continue;
            }
            int duration = 0;
            int amplifier = 0;
            try {
                duration = Integer.parseInt(splitted[1]);
                amplifier = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException e) {
                ErrorHandler.error("Bad duration or amplifier integer for '" + p + "'!");
                continue;
            }
            effects.add(new MobEffectInstance(potion, duration, amplifier));
        }
        if (!effects.isEmpty()) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                if (living != null) {
                    for (MobEffectInstance effect : effects) {
                        MobEffectInstance neweffect = new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_());
                        living.m_7292_(neweffect);
                    }
                }
            });
        }
    }

    private void addHealthSetAction(float s) {
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlHealth") && (entityAttribute = entityLiving.m_21051_(Attributes.f_22276_)) != null) {
                entityAttribute.m_22100_((double)s);
                entityLiving.m_21153_((float)((double)s));
                entityLiving.m_20049_("ctrlHealth");
            }
        });
    }

    private void addHealthAction(Float m, Float a) {
        float finalM = m == null ? 1.0f : m.floatValue();
        float finalA = a == null ? 0.0f : a.floatValue();
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlHealth") && (entityAttribute = entityLiving.m_21051_(Attributes.f_22276_)) != null) {
                double newMax = entityAttribute.m_22115_() * (double)finalM + (double)finalA;
                entityAttribute.m_22100_(newMax);
                entityLiving.m_21153_((float)newMax);
                entityLiving.m_20049_("ctrlHealth");
            }
        });
    }

    private void addSpeedSetAction(float s) {
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlSpeed") && (entityAttribute = entityLiving.m_21051_(Attributes.f_22279_)) != null) {
                entityAttribute.m_22100_((double)s);
                entityLiving.m_20049_("ctrlSpeed");
            }
        });
    }

    private void addSpeedAction(Float m, Float a) {
        float finalM = m == null ? 1.0f : m.floatValue();
        float finalA = a == null ? 0.0f : a.floatValue();
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlSpeed") && (entityAttribute = entityLiving.m_21051_(Attributes.f_22279_)) != null) {
                double newMax = entityAttribute.m_22115_() * (double)finalM + (double)finalA;
                entityAttribute.m_22100_(newMax);
                entityLiving.m_20049_("ctrlSpeed");
            }
        });
    }

    private void addSizeActions(Float m, Float a) {
        m = Float.valueOf(m == null ? 1.0f : m.floatValue());
        a = Float.valueOf(a == null ? 0.0f : a.floatValue());
        ErrorHandler.error("Mob resizing not implemented yet!");
        this.actions.add(event -> {
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null) {
                // empty if block
            }
        });
    }

    private void addDamageSetAction(float s) {
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlDamage") && (entityAttribute = entityLiving.m_21051_(Attributes.f_22281_)) != null) {
                entityAttribute.m_22100_((double)s);
                entityLiving.m_20049_("ctrlDamage");
            }
        });
    }

    private void addDamageAction(Float m, Float a) {
        float finalM = m == null ? 1.0f : m.floatValue();
        float finalA = a == null ? 0.0f : a.floatValue();
        this.actions.add(event -> {
            AttributeInstance entityAttribute;
            LivingEntity entityLiving = event.getEntityLiving();
            if (entityLiving != null && !entityLiving.m_19880_().contains("ctrlDamage") && (entityAttribute = entityLiving.m_21051_(Attributes.f_22281_)) != null) {
                double newMax = entityAttribute.m_22115_() * (double)finalM + (double)finalA;
                entityAttribute.m_22100_(newMax);
                entityLiving.m_20049_("ctrlDamage");
            }
        });
    }

    protected void addArmorItem(List<String> itemList, EquipmentSlot slot) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    entityLiving.m_8061_(slot, item.m_41777_());
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    entityLiving.m_8061_(slot, this.getRandomItem(items, total));
                }
            });
        }
    }

    protected void addHeldItem(List<String> heldItems) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(heldItems);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            ItemStack item = (ItemStack)items.get(0).getRight();
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    if (entityLiving instanceof EnderMan) {
                        if (item.m_41720_() instanceof BlockItem) {
                            BlockItem b = (BlockItem)item.m_41720_();
                            ((EnderMan)entityLiving).m_32521_(b.m_40614_().m_49966_());
                        }
                    } else {
                        entityLiving.m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
                    }
                }
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null) {
                    ItemStack item = this.getRandomItem(items, total);
                    if (entityLiving instanceof EnderMan) {
                        if (item.m_41720_() instanceof BlockItem) {
                            BlockItem b = (BlockItem)item.m_41720_();
                            ((EnderMan)entityLiving).m_32521_(b.m_40614_().m_49966_());
                        }
                    } else {
                        entityLiving.m_21008_(InteractionHand.MAIN_HAND, item.m_41777_());
                    }
                }
            });
        }
    }

    private void addMobNBT(String mobnbt) {
        if (mobnbt != null) {
            CompoundTag tagCompound;
            try {
                tagCompound = TagParser.m_129359_((String)mobnbt);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Bad NBT for mob!");
                return;
            }
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                entityLiving.m_7378_(tagCompound);
            });
        }
    }

    private void addCustomName(String customName) {
        if (customName != null) {
            this.actions.add(event -> {
                LivingEntity entityLiving = event.getEntityLiving();
                entityLiving.m_6593_((Component)new TextComponent(customName));
            });
        }
    }

    protected void addAngryAction(boolean angry) {
        if (angry) {
            this.actions.add(event -> {
                Player player;
                LivingEntity entityLiving = event.getEntityLiving();
                if (entityLiving != null && (player = event.getWorld().m_45930_((Entity)entityLiving, 50.0)) != null) {
                    entityLiving.m_6703_((LivingEntity)player);
                    entityLiving.m_21335_((Entity)player);
                    if (entityLiving instanceof NeutralMob) {
                        ((NeutralMob)entityLiving).m_6710_((LivingEntity)player);
                    }
                }
            });
        }
    }

    public static interface EventGetter {
        public LivingEntity getEntityLiving();

        public Player getPlayer();

        public LevelAccessor getWorld();

        public BlockPos getPosition();
    }
}

