/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell.bulk;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import gripe._90.megacells.item.cell.bulk.IBulkCellItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BulkCellInventory
implements StorageCell {
    private static final String KEY = "key";
    private static final String COUNT = "count";
    private final ISaveProvider container;
    private final ItemStack i;
    private final IBulkCellItem cellType;
    private AEKey storedItem;
    private long itemCount;
    private IPartitionList partitionList;
    private boolean isPersisted = true;

    public BulkCellInventory(IBulkCellItem cellType, ItemStack o, ISaveProvider container) {
        this.i = o;
        this.cellType = cellType;
        this.container = container;
        this.storedItem = this.retrieveStoredItem();
        this.itemCount = this.retrieveItemCount();
        IPartitionList.Builder builder = IPartitionList.builder();
        ConfigInventory config = this.getConfigInventory();
        builder.addAll((Iterable)config.keySet());
        this.partitionList = builder.build();
    }

    private AEKey retrieveStoredItem() {
        if (this.getTag().m_128441_("keys")) {
            return AEKey.fromTagGeneric((CompoundTag)this.getTag().m_128437_("keys", 10).m_128728_(0));
        }
        return this.getTag().m_128441_(KEY) ? AEKey.fromTagGeneric((CompoundTag)this.getTag().m_128469_(KEY)) : null;
    }

    private long retrieveItemCount() {
        return this.getTag().m_128441_("ic") ? this.getTag().m_128454_("ic") : this.getTag().m_128454_(COUNT);
    }

    private CompoundTag getTag() {
        return this.i.m_41784_();
    }

    public static BulkCellInventory createInventory(ItemStack o, ISaveProvider container) {
        Objects.requireNonNull(o, "Cannot create cell inventory for null itemstack");
        Item item = o.m_41720_();
        if (!(item instanceof IBulkCellItem)) {
            return null;
        }
        IBulkCellItem cellType = (IBulkCellItem)item;
        return new BulkCellInventory(cellType, o, container);
    }

    private static boolean isCellEmpty(BulkCellInventory inv) {
        if (inv != null) {
            return inv.getAvailableStacks().isEmpty();
        }
        return true;
    }

    public CellState getStatus() {
        if (this.itemCount == 0L) {
            return CellState.EMPTY;
        }
        if (this.itemCount == Long.MAX_VALUE || !this.storedItem.equals(this.getFilterItem())) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    protected AEKey getFilterItem() {
        List config = this.getConfigInventory().keySet().stream().toList();
        if (config.isEmpty()) {
            return null;
        }
        return (AEKey)config.get(0);
    }

    public double getIdleDrain() {
        return 10.0;
    }

    public ConfigInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        BulkCellInventory meInventory;
        if (amount == 0L || !AEKeyType.items().contains(what) || !this.partitionList.isListed(what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && !BulkCellInventory.isCellEmpty(meInventory = BulkCellInventory.createInventory((itemKey = (AEItemKey)what).toStack(), null))) {
            return 0L;
        }
        if (this.storedItem != null && !this.storedItem.equals(what)) {
            return 0L;
        }
        if (this.itemCount - Long.MAX_VALUE + amount > 0L) {
            amount = Long.MAX_VALUE - this.itemCount;
        }
        if (mode == Actionable.MODULATE) {
            if (this.storedItem == null) {
                this.storedItem = what;
            }
            this.itemCount += amount;
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentCount = this.itemCount;
        if (this.itemCount > 0L && Objects.equals(this.storedItem, what)) {
            if (extractAmount >= currentCount) {
                if (mode == Actionable.MODULATE) {
                    this.storedItem = null;
                    this.itemCount = 0L;
                    this.saveChanges();
                }
                return currentCount;
            }
            if (mode == Actionable.MODULATE) {
                this.itemCount -= extractAmount;
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItem == null || this.itemCount < 0L) {
            this.getTag().m_128473_(KEY);
            this.getTag().m_128473_(COUNT);
        } else {
            this.getTag().m_128365_(KEY, (Tag)this.storedItem.toTagGeneric());
            this.getTag().m_128356_(COUNT, this.itemCount);
        }
        this.getTag().m_128473_("keys");
        this.getTag().m_128473_("amts");
        this.getTag().m_128473_("ic");
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedItem != null && this.itemCount > 0L) {
            out.add(this.storedItem, this.itemCount);
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return Objects.equals(what, this.storedItem) || this.partitionList.isListed(what);
    }

    public Component getDescription() {
        return this.i.m_41786_();
    }
}

